//
// C++ Implementation: kpgsqlparser
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsqlparser.h"

// include files for Qt
#include <qregexp.h>

// include files for KDE
#include <kdebug.h>

#include "../kpgutil.h"

// Parse SQL and update object aliases in OID/names list
void KPGSqlParser::updateAliases(const QString &strSql, KPGOidNameAliasesList & listOfCodeCompletionObjects)
{
	// Clear existing aliases
	for(KPGOidNameAliasesList::iterator it = listOfCodeCompletionObjects.begin(); it != listOfCodeCompletionObjects.end(); ++it)
    {
        (*it).clearAliases();
    }
    
    // Setup regexp's
	QRegExp patternIdentifier("^[\\w][\\w$]*$"); // SQL identifiers and key words must begin with a letter 
    // (a-z, but also letters with diacritical marks and non-Latin letters) or an underscore (_). 
    // Subsequent characters in an identifier or key word can be letters, underscores, digits (0-9), or dollar signs ($). 
    
    QRegExp patternCommentMultiline("/\\*[^*]*[^/]*\\*/"); 
    QRegExp patternCommentSingleline("--[^\\n]*$");
    QRegExp patternQuotedIdentifier("^\".*\"$");
        
    // Remove comments from the given SQL
    // 1. multi-line
    QString strSqlWithoutComments(strSql);
    strSqlWithoutComments.remove(patternCommentMultiline);
                
    // 2. single-line 
    QStringList linesIn = QStringList::split("\n", strSqlWithoutComments);
    QStringList linesOut;
    for(QStringList::Iterator it = linesIn.begin(); it != linesIn.end(); ++it ) 
    {
        QString line(*it);
        int iCommentPos = patternCommentSingleline.search(line, 0);
        if(iCommentPos < 0)
        {
            linesOut.append(line);
        }
        else
        {
            while(iCommentPos >= 0)
            {
                // TODO: Check, if the comment isn't arounded by the quotes
                //QRegExp patternQuotedString("'.?" + strRegExp + ".?'")
                                
                if(true)
                {    
                    line.remove(patternCommentSingleline);
                    linesOut.append(line);
                    
                    break;
                }
                else
                    iCommentPos = patternCommentSingleline.search(line, iCommentPos + 1);
            }
        }     
    }
            
    strSqlWithoutComments = linesOut.join("\n" );
    kdDebug() << "SQL without comments: " << strSqlWithoutComments << endl;
     
    // Process parsing 
    int iPos = 0;
    do
    {
    	QString strNamespace, strName, strAlias;
		bool bNameFound = false;
		bool bExpectAlias = false;
	
		// Read name, eventually fully qualified
		while(iPos < (int) strSql.length())
		{
			QChar ch = strSqlWithoutComments[iPos];
			if(ch.isSpace()) 
			{
				if(strName.isEmpty())
					{ iPos++; continue; } // eat whitespaces
				else
					{ 
						bNameFound = true ; // name is readed 
						bExpectAlias = true; // expect alias after name, because name is termiaded by space
						break; 
					} 
			}
			
			if(ch == '.')
			{
				strNamespace = strName;
				strName.setLength(0);
			}
			else if((ch == ',') || (ch == ';')) 
			{
				if(! strName.isEmpty()) bNameFound = true; // name is readed, but don't expect alias
				iPos++;
				break;
			}
			else
			{
				strName.append(ch);
			}

			iPos++;
		}
			
		// Try find the name in list of objects
		KPGOidNameAliases *pOidNameAliases = 0;
			
		if(bNameFound)
		{	
		     // Remove function arguments, if any 
		     int posLeftParenthesis; 
			 if((posLeftParenthesis = strName.find('(')) > 0)
			 {
			    strName = strName.left(posLeftParenthesis);
		     }
		     
		     // Remove quotes from identifier, if any
		     if(patternQuotedIdentifier.search(strName, 0) == 0)
             {
                strName = KPGUtil::unquotedName(strName);
             }
			     
		     // Find name, only if it's valid identifier
		     if((strName.length() > 0) && (!strName[0].isDigit()) && (patternIdentifier.search(strName, 0) == 0))
		     {
		        // TODO if(isKeyWord(strName) == false) ... 
		        
		        // Find name in the list ...
			    pOidNameAliases = listOfCodeCompletionObjects.getItemByName(strName);
			    if(!pOidNameAliases) bNameFound = false;
			 }
		}
			
		if(bNameFound && bExpectAlias) // ... and update it's alias
		{
			// Read alias
			while(iPos < (int) strSqlWithoutComments.length())
			{
				QChar ch = strSqlWithoutComments[iPos];
				if(ch.isSpace()) 
				{
					if(strAlias.isEmpty())
						{ iPos++; continue; } // eat whitespaces
					else
						break; // alias is readed
				}
			
				if((ch == '.') || (ch == ',') || (ch == ';'))
				{
					iPos++;
					break;
				}
				
				strAlias.append(ch);
				iPos++;
			}
		}
					
		if(!strAlias.isEmpty())
		{
		    if(pOidNameAliases && 
				(	(pOidNameAliases->type() == KPGTreeItem::nodeTable) || 
					(pOidNameAliases->type() == KPGTreeItem::nodeView) || 
					((pOidNameAliases->type() == KPGTreeItem::nodeFunction) && 	(pOidNameAliases->returnSet()) )
				)
			  ) // it is table, view or function returning set ?
			{
			    if(listOfCodeCompletionObjects.containAlias(strAlias))
			    {
			    		kdDebug() << "Alias " << strAlias << " is already used !" << endl;
			    }
			    else
			    {
			        pOidNameAliases->appendAlias(strAlias);
			        kdDebug() << "Setting alias " << strAlias << " for " << strName << endl;
			    }
			}
		}		
    } while(iPos < (int) strSqlWithoutComments.length());
}
