//
// C++ Implementation: kpgusersfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgusersfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgusersfolder.h"


KPGUsersFolderPropPage::KPGUsersFolderPropPage(QWidget* parent, KPGUsersFolder * pUsersFolder)
	: KPGPropertyPage(parent, "KPGUsersFolderPropPage")
{
	m_pUsersFolder = pUsersFolder;
	displayProperties();
}


KPGUsersFolderPropPage::~KPGUsersFolderPropPage()
{
}

void KPGUsersFolderPropPage::displayProperties()
{
	setLabelText(i18n("Users &list:"));
	
	//----------------------------------------------------------------------------
	// Display users list
		
	// Fill output area with query result
	int nRows = m_pUsersFolder->resultUsers().size();
	int nCols = m_pUsersFolder->resultUsers().columns();
	
	m_pTableItems->setNumRows(nRows);
	m_pTableItems->setNumCols(nCols);
	
	// field names
	QHeader* pHeader = m_pTableItems->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("User ID"));
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("May Create DB"));
	pHeader->setLabel(nCol++, i18n("Is Superuser"));
	pHeader->setLabel(nCol++, i18n("May update catalog"));
	pHeader->setLabel(nCol++, i18n("Valid until"));
		
	// data
	for(int nRow = 0; nRow < nRows; nRow++)
	{
		for(int nCol = 0; nCol < nCols; nCol++)
		{
			if(m_pUsersFolder->resultUsers().column_type(nCol) == 16) // boolean
			{
			   bool bValue;
			   m_pUsersFolder->resultUsers()[nRow][nCol].to(bValue);
					   
			   m_pTableItems->setPixmap(nRow, nCol, bValue ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
			}
			else
			{
			   QString strValue(m_pUsersFolder->resultUsers()[nRow][nCol].c_str());
			   m_pTableItems->setText(nRow, nCol, strValue);
			}
		}
	}
	
	for(int nCol = 0; nCol < nCols; nCol++)
	{
		m_pTableItems->adjustColumn(nCol);
	}
}


