/***************************************************************************
                          kpgsequencesfolder  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgsequencesfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpgschema.h"
#include "kpgsequence.h"

KPGSequencesFolder::KPGSequencesFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
	: KPGItemsFolder(parent, i18n("Sequences"), m_pIconFolderVioletClosed, m_pIconFolderVioletOpen)
{
	m_oidNameSpace = oidNameSpace;
}


KPGSequencesFolder::~KPGSequencesFolder()
{
}

void KPGSequencesFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items (databases)
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
    KPGSchema *pSchema = static_cast <KPGSchema *> (parent());	
    //                                              schema -> database -> server    
    KPGServer *pServer = static_cast <KPGServer *> (pSchema->parent()->parent());
    if(pServer->type() != nodeServer)
    {
        kdError() << k_funcinfo << " cannot find parent server." << endl;
        return;
    }

	// obtain list of sequences
    QString strQuery("SELECT cl.oid, relname, description, pg_get_userbyid(relowner) AS seqowner, relacl ");
	strQuery.append("FROM pg_catalog.pg_class cl ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=cl.oid ");
	strQuery.append("WHERE relkind = 'S' AND relnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY relname");
			
    KPGConnection *pConnection = connection();
    try
    {
		m_pqxxResultSequences = pConnection->runQuery(strQuery);
    
        KPGSequence *pSequence = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultSequences.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultSequences[i][0].to(oid);
            
            if(pSequence == 0)
                pSequence = new KPGSequence(this, m_pqxxResultSequences[i]["relname"].c_str(), oid);
            else
                pSequence = new KPGSequence(this, pSequence, m_pqxxResultSequences[i]["relname"].c_str(), oid);
                            
            pSequence->setProperties(m_pqxxResultSequences[i], pConnection);
                
        
            if((pServer->versionMajor() >= 8) || ((pServer->versionMajor() == 7) && (pServer->versionMiddle() >= 4)))
            {          	
                //-- Get seq. values
                strQuery = QString("SELECT last_value, min_value, max_value, cache_value, is_cycled, increment_by \
                FROM \"%1\".\"%2\";").arg(pSchema->text(0)).arg(m_pqxxResultSequences[i]["relname"].c_str());
                pqxx::result pqxxResultSeqValues = connection()->runQuery(strQuery);
                
                if (pqxxResultSeqValues.size() == 1)
                {
                    pSequence->setSeqValues(pqxxResultSeqValues[0]);
                }	
            }	
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
    } 
}

