//
// C++ Implementation: kpggroupsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpggroupsfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpggroup.h"

KPGGroupsFolder::KPGGroupsFolder(KPGServer *parent)
	: KPGItemsFolder(parent, i18n("Groups"), m_pIconFolderOrangeClosed, m_pIconFolderOrangeOpen)
{
}


KPGGroupsFolder::~KPGGroupsFolder()
{
}

void KPGGroupsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items (databases)
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
        // obtain list of tables
    QString strQuery("SELECT groname, grosysid FROM pg_catalog.pg_group ORDER BY groname;");
                
    KPGConnection *pConnection = connection();
    try
    {
        m_pqxxResultGroups = pConnection->runQuery(strQuery);
    
        KPGGroup *pGroup = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultGroups.size(); ++i)
        {
            if(pGroup == 0)
                pGroup = new KPGGroup(this, m_pqxxResultGroups[i]["groname"].c_str());
            else
                pGroup = new KPGGroup(this, pGroup, m_pqxxResultGroups[i]["groname"].c_str());
                
            pGroup->setProperties(m_pqxxResultGroups[i]);
                
            //-- Get users list
            strQuery = QString("SELECT grolist FROM pg_catalog.pg_group WHERE grosysid=%1;").arg(pGroup->sysId());
            pqxx::result pqxxResultUsersList = connection()->runQuery(strQuery);
            
            if(pqxxResultUsersList.size() > 0)
            {
                //fieldstream fs(pqxxResultUsersList[0]["grolist"]);
                QString strUsrList(pqxxResultUsersList[0]["grolist"].c_str());
                    
                if(strUsrList.length() > 2) // void list is "{}"
                {
                    strUsrList.remove('{');
                    strUsrList.remove('}');
                                                       
                    strQuery = QString("SELECT usename FROM pg_catalog.pg_user WHERE usesysid IN (%1);").arg(strUsrList);
                    pqxx::result pqxxResultUser = connection()->runQuery(strQuery);
                            
                    for(result::size_type j = 0; j != pqxxResultUser.size(); ++j)
                    {
                        pGroup->getListOfUsers().append(pqxxResultUser[j]["usename"].c_str());
                    }
                }
            } 
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
    } 
}
