//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpggeneralsettings.h"

#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kcolorbutton.h>

#include <qframe.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

#include "kpggeneralsettingspage.h"

#define CONF_ENTRY_NAME_AUTO_LOAD_SYS_SCHEMAS "AutoLoadSysSchemas"
#define DFLT_VALUE_AUTO_LOAD_SYS_SCHEMAS true

#define CONF_ENTRY_NAME_AUTO_LOAD_USR_SCHEMAS "AutoLoadUsrSchemas"
#define DFLT_VALUE_AUTO_LOAD_USR_SCHEMAS true

#define CONF_ENTRY_NAME_USE_DOLLARS_FOR_FNC_BODY "UseDollarsForFncBody"
#define DFLT_VALUE_USE_DOLLARS_FOR_FNC_BODY false

#define CONF_ENTRY_NAME_LAZY_LOAD_TBL_CHILDS "LazyLoadTablesChilds"
#define DFLT_VALUE_LAZY_LOAD_TBL_CHILDS false

#define CONF_ENTRY_NAME_XACT_TYPE "TransactionType"
#define DFLT_VALUE_XACT_TYPE KPGConnection::eTransNormal


KPGGeneralSettings::KPGGeneralSettings( QObject * pParent, const char * pszName )
 : KPGSettings( "General", pParent, pszName ),
   m_bAutoLoadSysSchemas( DFLT_VALUE_AUTO_LOAD_SYS_SCHEMAS ),
   m_bAutoLoadUsrSchemas( DFLT_VALUE_AUTO_LOAD_USR_SCHEMAS ),
   m_bUseDollarsForFncBody( DFLT_VALUE_USE_DOLLARS_FOR_FNC_BODY ),
   m_bLazyLoadTablesChilds( DFLT_VALUE_LAZY_LOAD_TBL_CHILDS ),
   m_eTransType( DFLT_VALUE_XACT_TYPE ),
   m_pDialogPage(0)
{
}

KPGGeneralSettings::~KPGGeneralSettings()
{
}

void KPGGeneralSettings::write( KConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_AUTO_LOAD_SYS_SCHEMAS, m_bAutoLoadSysSchemas );
	pConfig->writeEntry( CONF_ENTRY_NAME_AUTO_LOAD_USR_SCHEMAS, m_bAutoLoadUsrSchemas );
	pConfig->writeEntry( CONF_ENTRY_NAME_USE_DOLLARS_FOR_FNC_BODY, m_bUseDollarsForFncBody );
	pConfig->writeEntry( CONF_ENTRY_NAME_LAZY_LOAD_TBL_CHILDS, m_bLazyLoadTablesChilds );
	pConfig->writeEntry( CONF_ENTRY_NAME_XACT_TYPE, m_eTransType );
}

void KPGGeneralSettings::read( const KConfig * pConfig )
{
	m_bAutoLoadSysSchemas = pConfig->readBoolEntry( CONF_ENTRY_NAME_AUTO_LOAD_SYS_SCHEMAS, DFLT_VALUE_AUTO_LOAD_SYS_SCHEMAS );
	m_bAutoLoadUsrSchemas = pConfig->readBoolEntry( CONF_ENTRY_NAME_AUTO_LOAD_USR_SCHEMAS, DFLT_VALUE_AUTO_LOAD_USR_SCHEMAS );
	m_bUseDollarsForFncBody = pConfig->readBoolEntry( CONF_ENTRY_NAME_USE_DOLLARS_FOR_FNC_BODY, DFLT_VALUE_USE_DOLLARS_FOR_FNC_BODY );
	m_bLazyLoadTablesChilds = pConfig->readBoolEntry( CONF_ENTRY_NAME_LAZY_LOAD_TBL_CHILDS, DFLT_VALUE_LAZY_LOAD_TBL_CHILDS );
	m_eTransType = (KPGConnection::ETransType) pConfig->readNumEntry( CONF_ENTRY_NAME_XACT_TYPE, DFLT_VALUE_XACT_TYPE );
}

QString KPGGeneralSettings::dialogPageName() const
{
  	return i18n( "General" );
}

QString KPGGeneralSettings::dialogPageHeader() const
{
  	return i18n( "General setting" );
}

QString KPGGeneralSettings::dialogPageIcon() const
{
  	return "kpogre";
}

QWidget * KPGGeneralSettings::dialogPage( QFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KPGGeneralSettingsPage( pParent, "general setting config.dialog page" );
	
		// and fill its widgets with the corresponding values
		updatePage();
	
		connect( m_pDialogPage->m_pCheckBoxAutoLoadSysSchemas, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pCheckBoxAutoLoadUsrSchemas, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pCheckBoxUseDollarsForFncBody, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) ); 
		connect( m_pDialogPage->m_pCheckBoxLazyLoadTblChilds, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) ); 
		connect( m_pDialogPage->m_pRadioButtonNormalTX, SIGNAL(stateChanged(int)), this, SIGNAL(sigDialogPageChanged()) ); 
		connect( m_pDialogPage->m_pRadioButtonNonTX, SIGNAL(stateChanged(int)), this, SIGNAL(sigDialogPageChanged()) ); 
		connect( m_pDialogPage->m_pRadioButtonRobustTX, SIGNAL(stateChanged(int)), this, SIGNAL(sigDialogPageChanged()) ); 
	}
	
	return m_pDialogPage;
}

void KPGGeneralSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_bAutoLoadSysSchemas = m_pDialogPage->m_pCheckBoxAutoLoadSysSchemas->isChecked();
		m_bAutoLoadUsrSchemas = m_pDialogPage->m_pCheckBoxAutoLoadUsrSchemas->isChecked();
		m_bUseDollarsForFncBody = m_pDialogPage->m_pCheckBoxUseDollarsForFncBody->isChecked();
		m_bLazyLoadTablesChilds = m_pDialogPage->m_pCheckBoxLazyLoadTblChilds->isChecked();
		 
		if(m_pDialogPage->m_pRadioButtonNormalTX->isChecked()) m_eTransType = KPGConnection::eTransNormal;
		else if(m_pDialogPage->m_pRadioButtonNonTX->isChecked()) m_eTransType = KPGConnection::eTransNone;
		else if(m_pDialogPage->m_pRadioButtonRobustTX->isChecked()) m_eTransType = KPGConnection::eTransRobust;
	}
}

void KPGGeneralSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pCheckBoxAutoLoadSysSchemas->setChecked( m_bAutoLoadSysSchemas );
		m_pDialogPage->m_pCheckBoxAutoLoadUsrSchemas->setChecked( m_bAutoLoadUsrSchemas );
		m_pDialogPage->m_pCheckBoxUseDollarsForFncBody->setChecked( m_bUseDollarsForFncBody );
		m_pDialogPage->m_pCheckBoxLazyLoadTblChilds->setChecked( m_bLazyLoadTablesChilds );
		
		switch(m_eTransType)
		{
		  case KPGConnection::eTransNormal: m_pDialogPage->m_pRadioButtonNormalTX->setChecked(true);
		  break;
		  
		  case KPGConnection::eTransNone: m_pDialogPage->m_pRadioButtonNonTX->setChecked(true);
		  break;
		  
		  case KPGConnection::eTransRobust: m_pDialogPage->m_pRadioButtonRobustTX->setChecked(true);
		  break;
		}
	}
}

