//
// C++ Implementation: kpgcreateuserwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateuserwidget1.h"

// include files for Qt
#include <qpushbutton.h>
#include <qlabel.h>
#include <qradiobutton.h>

// include files for KDE
#include <klineedit.h>
#include <kpassdlg.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdatewidget.h>
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "../kpgutil.h"
#include "../DbObjects/kpgconnection.h"

KPGCreateUserWidget1::KPGCreateUserWidget1(QWidget *parent, const char *name)
 : KPGCreateUserWidget1Base(parent, name)
{
	m_pDateWidgetExpiration->setDate(QDate::currentDate().addYears(1));
	m_pLineEditUserName->setFocus();
}

KPGCreateUserWidget1::~KPGCreateUserWidget1()
{
}

void KPGCreateUserWidget1::slotRadioButtonExpirationChanged(int iState)
{
	m_pDateWidgetExpiration->setEnabled(iState == 0);
}

void KPGCreateUserWidget1::slotLineEditUserNameChanged(const QString &strUserName)
{
	emit sigEnableNextButton((strUserName.length() > 0) && (QString(m_pPasswordEdit1->password()) == QString(m_pPasswordEdit2->password())));
}

void KPGCreateUserWidget1::slotPasswordEdit1Changed(const QString &)
{
	bool bMatch = (QString(m_pPasswordEdit1->password()) == QString(m_pPasswordEdit2->password()));
	
	if(!bMatch)
		m_pTextLabelInfo->setText(i18n("Passwords not match"));
	else
		m_pTextLabelInfo->setText("");
		
	emit sigEnableNextButton(bMatch && (m_pLineEditUserName->text().length() > 0));
}

void KPGCreateUserWidget1::slotPasswordEdit2Changed(const QString &)
{
	bool bMatch = (QString(m_pPasswordEdit1->password()) == QString(m_pPasswordEdit2->password()));
	
	if(!bMatch)
		m_pTextLabelInfo->setText(i18n("Passwords not match"));
	else
		m_pTextLabelInfo->setText("");
		
	emit sigEnableNextButton(bMatch && (m_pLineEditUserName->text().length() > 0));
}

// Return part of SQL statement for CREATE USER
const QString KPGCreateUserWidget1::getSQL(KPGConnection *pConnection)
{
	QString strSQL(KPGUtil::quotedName(m_pLineEditUserName->text()));

	QString strWITH(" WITH\n");
	
	if(m_pLineEditSysId->text().length() > 0)
	{
		strWITH.append("SYSID " + m_pLineEditSysId->text() + "\n");
	}
	
	bool bEncrypted = false;
	if(m_pPasswordEdit1->text().length() > 0)
	{
		if(m_pComboBoxEncryption->currentItem() == 1)
		{
			strWITH.append(" ENCRYPTED ");
			bEncrypted = true;
		}
		else
		{
			if(m_pComboBoxEncryption->currentItem() == 2)
				strWITH.append(" UNENCRYPTED ");
		}
		
		strWITH.append("PASSWORD '");
		
		if(!bEncrypted)
		{
			strWITH.append(m_pPasswordEdit1->password());
		}
		else
		{
			QString strQuery("SELECT md5 FROM pg_catalog.md5('");
			strQuery.append(m_pPasswordEdit1->password());
			strQuery.append(m_pLineEditUserName->text());
			strQuery.append("');");
			
			QString strMD5;
			pqxx::result pqxxResult; 
			
			try
			{
				pqxxResult = pConnection->runQuery(strQuery);
			}
			catch (const std::exception &e)
			{
				KMessageBox::error(this, e.what());
			} 
			
			if (pqxxResult.size() >= 1)
			{
				strMD5 = pqxxResult[0][0].c_str();
				strWITH.append("md5" + strMD5);
			}
		}
		
		strWITH.append("'\n");
	}
	
	if(m_pCheckBoxCreateDb->isChecked())
		strWITH.append("CREATEDB\n");
		
	if(m_pCheckBoxCreateUsers->isChecked())
		strWITH.append("CREATEUSER\n");
		
	if(m_pRadioButtonExpiresOn->isChecked())
	{
		strWITH.append("VALID UNTIL '");
		
		QDate d = m_pDateWidgetExpiration->date();
		
		strWITH.append(d.toString("yyyy-MM-dd"));
		strWITH.append("'\n");
	}
	
	if(strWITH.length() > 7)
		strSQL.append(strWITH);
	
	return strSQL;
}

#include "kpgcreateuserwidget1.moc"
