//
// C++ Implementation: kpgcreatetablewidget5
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablewidget5.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qstringlist.h> 

// include files for KDE
#include <klistbox.h>
#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgitemsfolder.h"
#include "../kpgutil.h"

KPGCreateTableWidget5::KPGCreateTableWidget5(QWidget *parent, const char *name, bool bGrantOrRevoke)
 : KPGCreateTableWidget5Base(parent, name)
{
	m_bGrantOrRevoke = bGrantOrRevoke;
  
	if(bGrantOrRevoke)
	{
		strGR = "GRANT ";
		strTF = " TO ";
		m_pCheckBoxCascade->hide();
	}
	else
	{
		strGR = "REVOKE ";
		strTF = " FROM ";
		m_pCheckBoxGrantOptions->setText(i18n("Only revoke &GRANT privilege"));
	}
	
	m_pListViewGrants->setSortColumn(-1);
}


KPGCreateTableWidget5::~KPGCreateTableWidget5()
{
}

/////////////////////////////////////////////////////////////////////
//                       GRANTS FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget5::slotCheckBoxAllToggled(bool bState)
{
	m_pCheckBoxRule->setEnabled(!bState);
	m_pCheckBoxDelete->setEnabled(!bState);
	m_pCheckBoxUpdate->setEnabled(!bState);
	m_pCheckBoxInsert->setEnabled(!bState);
	m_pCheckBoxSelect->setEnabled(!bState);
	m_pCheckBoxReferences->setEnabled(!bState);
	m_pCheckBoxTrigger->setEnabled(!bState);
	
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxSelectToggled(bool)
{
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxInsertToggled(bool)
{
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxUpdateToggled(bool)
{
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxDeleteToggled(bool)
{
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxRuleToggled(bool)
{
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxReferencesToggled(bool)
{
  enableAddGrantButton();
}

void KPGCreateTableWidget5::slotCheckBoxTriggerToggled(bool)
{
  enableAddGrantButton();
}
	
void KPGCreateTableWidget5::slotCheckBoxPublicToggled(bool bState)
{
	m_pListBoxUsersGroups->setEnabled(!bState);
  	m_pCheckBoxGrantOptions->setEnabled(!bState); // Grant options can only be granted to individual users, not to groups or PUBLIC.
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotGrantOptionsToggled(bool bState)
{
  m_pCheckBoxCascade->setEnabled(!m_bGrantOrRevoke && bState);
}

void KPGCreateTableWidget5::slotListBoxUsersSelectionChanged()
{
	enableAddGrantButton();
}

void KPGCreateTableWidget5::enableAddGrantButton()
{
	bool bAnyPrivilegeChecked = false;
	
	if(m_pCheckBoxAll->isChecked()) bAnyPrivilegeChecked = true;
		else
			if(m_pCheckBoxRule->isChecked()) bAnyPrivilegeChecked = true;
				else
					if(m_pCheckBoxDelete->isChecked()) bAnyPrivilegeChecked = true;
					else
						if(m_pCheckBoxUpdate->isChecked()) bAnyPrivilegeChecked = true;
							else
								if(m_pCheckBoxInsert->isChecked()) bAnyPrivilegeChecked = true;
									else
										if(m_pCheckBoxSelect->isChecked()) bAnyPrivilegeChecked = true;
											else
												if(m_pCheckBoxReferences->isChecked()) bAnyPrivilegeChecked = true;
													else
														if(m_pCheckBoxTrigger->isChecked()) bAnyPrivilegeChecked = true;
	
	bool bAnyUserOrGroupChecked = false;				
	
	if(m_pCheckBoxPublic->isChecked()) 
		bAnyUserOrGroupChecked = true;
	else
		{
			if(m_pListBoxUsersGroups->count() > 0)
			{
				for(unsigned int i = 0; i <m_pListBoxUsersGroups->count(); i++)
				if(m_pListBoxUsersGroups->isSelected(i))
					{
					  bAnyUserOrGroupChecked = true;
						break;
					}
			}
		}
	m_pPushButtonGrantAdd->setEnabled(bAnyPrivilegeChecked && bAnyUserOrGroupChecked);
}

/////////////////////////////////////////////////////////////////////
//                     COMMON FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget5::slotGrantAdd()
{
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewGrants->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QStringList strListOfSQLs; // string list for SQL clauses GRANT ...
  
  	QString strWGO((m_bGrantOrRevoke && m_pCheckBoxGrantOptions->isChecked()) ? " WITH GRANT OPTION" : "");
	QString strGOF((!m_bGrantOrRevoke && m_pCheckBoxGrantOptions->isChecked()) ? "GRANT OPTION FOR " : "");
  	QString strC((!m_bGrantOrRevoke && m_pCheckBoxCascade->isChecked()) ? " CASCADE" : "");
    	
	if(m_pCheckBoxPublic->isChecked() && m_pCheckBoxAll->isChecked())
	{
		strListOfSQLs.append(strGR + "ALL ON TABLE " + KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + strTF + "PUBLIC");		
	}
	
	if(m_pCheckBoxPublic->isChecked() && !m_pCheckBoxAll->isChecked())
	{
    	QString strSQL(strGR);
    
    	if(m_pCheckBoxSelect->isChecked())
			strSQL.append("SELECT, ");
		
		if(m_pCheckBoxInsert->isChecked())
			strSQL.append("INSERT, ");
		
		if(m_pCheckBoxUpdate->isChecked())
			strSQL.append("UPDATE, ");
		
		if(m_pCheckBoxDelete->isChecked())
			strSQL.append("DELETE, ");
				
		if(m_pCheckBoxRule->isChecked())
			strSQL.append("RULE, ");
			
		if(m_pCheckBoxReferences->isChecked())
			strSQL.append("REFERENCES, ");
			
		if(m_pCheckBoxTrigger->isChecked())
			strSQL.append("TRIGGER");
      
    if(strSQL.right(2) == ", ")  
      strSQL = strSQL.left(strSQL.length() - 2);
      
    strSQL.append(" ON TABLE " + KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + strTF + "PUBLIC"); 	
    
    strListOfSQLs.append(strSQL);
	}
	
	if(!m_pCheckBoxPublic->isChecked() && m_pCheckBoxAll->isChecked())
	{
		for(unsigned int i = 0; i < m_pListBoxUsersGroups->count(); i++)
		{
			if(m_pListBoxUsersGroups->isSelected(i))
			{
				QListBoxItem * pLbItem = m_pListBoxUsersGroups->item(i);
        
        if(pLbItem->rtti() != RTTI_KPGLISTBOXITEM)
        {
          kdError() << k_funcinfo << " Bad object type !" << endl;
          return;
        }  
        
        KPGListBoxItem *pListBoxItem = static_cast <KPGListBoxItem *> (pLbItem);
				
		if(pListBoxItem->type() == KPGTreeItem::nodeGroup)
			strListOfSQLs.append(strGR + "ALL ON TABLE " + KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + strTF + "GROUP " + pListBoxItem->text());
		else
			strListOfSQLs.append(strGR + strGOF + "ALL ON TABLE " + KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + strTF + pListBoxItem->text() + strWGO + strC);
	
			}
		}
	}
	
	if(!m_pCheckBoxPublic->isChecked() && !m_pCheckBoxAll->isChecked())
	{
		for(unsigned int i = 0; i < m_pListBoxUsersGroups->count(); i++)
		{
			if(m_pListBoxUsersGroups->isSelected(i))
			{
				QListBoxItem * pLbItem = m_pListBoxUsersGroups->item(i);
        
        if(pLbItem->rtti() != RTTI_KPGLISTBOXITEM)
        {
          kdError() << k_funcinfo << " Bad object type !" << endl;
          return;
        }
        
        KPGListBoxItem *pListBoxItem = static_cast <KPGListBoxItem *> (pLbItem);        
                
        QString strSQL(strGR);
        
        if(pListBoxItem->type() != KPGTreeItem::nodeGroup)
           strSQL.append(strGOF);
            
        if(m_pCheckBoxSelect->isChecked())
          strSQL.append("SELECT, ");
        
        if(m_pCheckBoxInsert->isChecked())
          strSQL.append("INSERT, ");
        
        if(m_pCheckBoxUpdate->isChecked())
          strSQL.append("UPDATE, ");
        
        if(m_pCheckBoxDelete->isChecked())
          strSQL.append("DELETE, ");
            
        if(m_pCheckBoxRule->isChecked())
          strSQL.append("RULE, ");
          
        if(m_pCheckBoxReferences->isChecked())
          strSQL.append("REFERENCES, ");
          
        if(m_pCheckBoxTrigger->isChecked())
          strSQL.append("TRIGGER");
          
        if(strSQL.right(2) == ", ")  
          strSQL = strSQL.left(strSQL.length() - 2);
        
				if(pListBoxItem->type() == KPGTreeItem::nodeGroup)
					strSQL.append(" ON TABLE " + KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + strTF + "GROUP " + pListBoxItem->text());
				else
				  strSQL.append(" ON TABLE " + KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + strTF + pListBoxItem->text() + strWGO + strC);
            
        strListOfSQLs.append(strSQL);
			}
		}
	}
			
	// Create items for new grants
	for ( QStringList::Iterator it = strListOfSQLs.begin(); it != strListOfSQLs.end(); ++it ) 
	{
   	QString strSQL(*it);
		QListViewItem *pNewItem;
		
		if(pLastItem == 0) 
			pNewItem = new QListViewItem(m_pListViewGrants, strSQL);
		else
			pLastItem = pNewItem = new QListViewItem(m_pListViewGrants, pLastItem, strSQL);	
  }
  
  emit sigEnableNextButton(true);
}

void KPGCreateTableWidget5::slotGrantDelete()
{
	QListViewItem *pSelectedItem = m_pListViewGrants->selectedItem();
	if(pSelectedItem)
			delete pSelectedItem;
	
  if(m_pListViewGrants->childCount() == 0)
	   emit sigEnableNextButton(false);
   
  m_pPushButtonGrantDel->setEnabled(false);
  	
	enableAddGrantButton();
}

void KPGCreateTableWidget5::slotGrantsSelectionChanged(QListViewItem* pItem)
{
	m_pPushButtonGrantDel->setEnabled(pItem != 0);
}

void KPGCreateTableWidget5::slotGrantsCurrentChanged(QListViewItem* pItem)
{
	m_pPushButtonGrantDel->setEnabled(pItem != 0);
}

// Return part of SQL statement for GRANT
const QString KPGCreateTableWidget5::getSQL() const
{
	QString strSQL;
	
	QListViewItem * pItem = m_pListViewGrants->firstChild();
	while(pItem)
	{
		strSQL.append(pItem->text(0));
		strSQL.append(";\n");
					  
		pItem = pItem->nextSibling();
	}
	
	return strSQL;
}

	
#include "kpgcreatetablewidget5.moc"
