//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatefunctionwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "kpgcreatefunctionwidget1.h"
#include "kpgcreatefunctionwidget2.h"
#include "kpgcreatefunctionwidget3.h"
#include "kpgcreatefunctionwidget4.h"
#include "kpgcreatefunctionwidget5.h"


KPGCreateFunctionWizard::KPGCreateFunctionWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
 : KPG7StepsWizard(parent, name)
{
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
	
  KPGCreateFunctionWidget1 *pCreateFunctionWidget1 = new KPGCreateFunctionWidget1(WizardPage1, "KPGCreateFunctionWidget1", listOfSchemas, pDatabase->getLanguagesFolder());
  m_pPageWidget1 = pCreateFunctionWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateFunctionWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  KPGCreateFunctionWidget2 *pCreateFunctionWidget2 = new KPGCreateFunctionWidget2(WizardPage2, "KPGCreateFunctionWidget2", pDatabase);
  m_pPageWidget2 = pCreateFunctionWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  connect(pCreateFunctionWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  KPGCreateFunctionWidget3 *pCreateFunctionWidget3 = new KPGCreateFunctionWidget3(WizardPage3, "KPGCreateFunctionWidget3");
  m_pPageWidget3 = pCreateFunctionWidget3;
  WizardPage3Layout->addWidget(m_pPageWidget3, 0, 0);
  connect(pCreateFunctionWidget3, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton3(bool)));
  
	KPGCreateFunctionWidget4 *pCreateFunctionWidget4 = new KPGCreateFunctionWidget4(WizardPage4, "KPGCreateFunctionWidget4");
  m_pPageWidget4 = pCreateFunctionWidget4;
  WizardPage4Layout->addWidget(m_pPageWidget4, 0, 0);
  connect(pCreateFunctionWidget4, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton4(bool)));
  
  KPGCreateFunctionWidget5 *pCreateFunctionWidget5 = new KPGCreateFunctionWidget5(WizardPage5, "KPGCreateFunctionWidget5");
  m_pPageWidget5 = pCreateFunctionWidget5;
  WizardPage5Layout->addWidget(m_pPageWidget5, 0, 0);
  //connect(pCreateFunctionWidget5, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton5(bool)));
    
  pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateFunctionWidget5->m_pListBoxUsersGroups);
  pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateFunctionWidget5->m_pListBoxUsersGroups);
      
  // default schema in page 2 is the same as in page 1
  pCreateFunctionWidget2->m_pComboBoxRetTypeSchema->setCurrentText(pCreateFunctionWidget1->m_pComboBoxSchema->currentText());
  pCreateFunctionWidget2->m_pComboBoxArgTypeSchema->setCurrentText(pCreateFunctionWidget1->m_pComboBoxSchema->currentText());
    
  pCreateFunctionWidget2->refreshListOfReturnTypes();
  pCreateFunctionWidget2->refreshListOfArgumentTypes();  
    
  languageChange();
  
  setNextEnabled(WizardPage2, true);
}


KPGCreateFunctionWizard::~KPGCreateFunctionWizard()
{
}

void KPGCreateFunctionWizard::languageChange()
{
    KPG7StepsWizard::languageChange();
    
    setCaption( i18n( "Create new function" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Function name" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Return and arguments types" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Function properties" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Function definition" ) );
	setTitle( WizardPage5, i18n( "Step 5 - Grant execute privileges" ) );
    setTitle( WizardPage6, i18n( "Step 6 - Review SQL statement" ) );
    setTitle( WizardPage7, i18n( "Step 7 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateFunctionWizard::showPage(QWidget *pPage)
{ 
  if(pPage == WizardPage4) // Step 3 - Define function definition
  {
    //--- Initialize 2nd page
    KPGCreateFunctionWidget1 *pCreateFunctionWidget1 = static_cast <KPGCreateFunctionWidget1 *> (m_pPageWidget1);
    KPGCreateFunctionWidget4 *pCreateFunctionWidget4 = static_cast <KPGCreateFunctionWidget4 *> (m_pPageWidget4);
    
    // set appropriate page
    if(pCreateFunctionWidget1->m_pComboBoxLanguage->currentText() == "C")
      pCreateFunctionWidget4->switchToPage(0);
    else
      pCreateFunctionWidget4->switchToPage(1);
  }

	if(pPage == WizardPage5) // Step 5 - Define user rights
	{
		KPGCreateFunctionWidget1 *pCreateFunctionWidget1 = static_cast <KPGCreateFunctionWidget1 *> (m_pPageWidget1);
    KPGCreateFunctionWidget2 *pCreateFunctionWidget2 = static_cast <KPGCreateFunctionWidget2 *> (m_pPageWidget2);
		KPGCreateFunctionWidget5 *pCreateFunctionWidget5 = static_cast <KPGCreateFunctionWidget5 *> (m_pPageWidget5);
				
		// Set function name and schema
		pCreateFunctionWidget5->setFunctionName(pCreateFunctionWidget1->getFuncName(), pCreateFunctionWidget2->getFuncParams());
		pCreateFunctionWidget5->setNamespace(pCreateFunctionWidget1->m_pComboBoxSchema->currentText());
	}
	
  if(pPage == WizardPage6) // Step 6 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    strSQL.append((static_cast <KPGCreateFunctionWidget1 *> (m_pPageWidget1))->getSQL1());
    strSQL.append((static_cast <KPGCreateFunctionWidget2 *> (m_pPageWidget2))->getFuncParams());
    strSQL.append((static_cast <KPGCreateFunctionWidget2 *> (m_pPageWidget2))->getSQL());
	strSQL.append((static_cast <KPGCreateFunctionWidget1 *> (m_pPageWidget1))->getSQL2());
    strSQL.append((static_cast <KPGCreateFunctionWidget3 *> (m_pPageWidget3))->getSQL());
    strSQL.append((static_cast <KPGCreateFunctionWidget4 *> (m_pPageWidget4))->getSQL());
	strSQL.append(";\n\n");
	strSQL.append((static_cast <KPGCreateFunctionWidget5 *> (m_pPageWidget5))->getSQL()); 
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage7) // Step 7 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG7StepsWizard::showPage(pPage);
}


#include "kpgcreatefunctionwizard.moc"
