//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedomainwidget2.h"

// include files for Qt
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <klistbox.h> 
#include <kpushbutton.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtypesfolder.h"
#include "../DbObjects/kpgtype.h"
#include "../kpgutil.h"


#define NUM_BASIC_TYPES 33


KPGCreateDomainWidget2::KPGCreateDomainWidget2(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateDomainWidget2Base(parent, name)
{
    m_pDatabase = pDatabase;
    
    // fill schemas to combobox
    KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxSchema, true); // only user schemas
    
    // refresh types from selected schema  
    refreshListOfTypes();
    slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
}

KPGCreateDomainWidget2::~KPGCreateDomainWidget2()
{
}

void KPGCreateDomainWidget2::refreshListOfTypes()
{
    m_pComboBoxDataType->clear();
        
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "char(n)");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "varchar(n)");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "text");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnXml, "xml");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "smallint");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "integer");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigint");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "decimal(p, s)");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "numeric(p, s)");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "real");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "double precision");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "money");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnUuid, "uuid");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit(n)");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit varying(n)");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBool, "bool");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)]");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)] with time zone");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "date");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)]");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)] with time zone");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "interval [(p)]");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBin, "bytea");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "point");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "line");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "lseg");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "polygon");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "box");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "path");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "circle");
    
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "inet");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "cidr");
    m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "macaddr");
    
    if(m_pComboBoxDataType->count() != NUM_BASIC_TYPES)
        kdDebug() << "KPGCreateDomainWidget2::refreshListOfTypes : NUM_BASIC_ARG_TYPES wrong number" << endl;
    
    fillUserDatatypes();
    
    m_pComboBoxDataType->setCurrentItem(0);
}

void KPGCreateDomainWidget2::fillUserDatatypes()
{
    KPGTreeItem *pItem = m_pDatabase->getChildByName(m_pComboBoxSchema->currentText());
    if(!pItem)
    {
        kdDebug() << "KPGCreateDomainWidget2::fillUserDatatypes: no item found: " << m_pComboBoxSchema->currentText() << endl;
        return;
    }
            
    KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
    KPGTypesFolder *pTypesFolder = pSchema->getTypesFolder();
    
    pTypesFolder->fillComboBoxWithChildItems(m_pComboBoxDataType, true);
    
    m_pComboBoxDataType->setCurrentItem(0);
    slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
}

void KPGCreateDomainWidget2::slotSchemaActivated(int)
{
    refreshListOfTypes();
}


void KPGCreateDomainWidget2::slotComboDataTypeActivated(const QString &strText)
{
	// Enable/disable precision and scale spins
	m_pSpinBoxPrecision->setEnabled(false);
	m_pSpinBoxScale->setEnabled(false);
	m_pButtonSetDefaultNow->setEnabled(false);
	
	if(strText.find("(n)") > 0)
	{
		m_pSpinBoxPrecision->setEnabled(true);
	}
	
	if(strText.find("(p, s)") > 0)
	{
		m_pSpinBoxPrecision->setEnabled(true);
		m_pSpinBoxScale->setEnabled(true);
	}
	
	if(strText.find("[(p)]") > 0)
	{
		m_pSpinBoxPrecision->setEnabled(true);
	}
	
	// Set help text for selected data type
	if((strText == "char(n)") || (strText == "varchar(n)"))
	{ 
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 10 );
		
		return;
	}    
	
	if((strText == "decimal(p, s)") || (strText == "numeric(p, s)"))
	{ 
		m_pSpinBoxPrecision->setMinValue( 1 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxScale->setMinValue( 0 );
		m_pSpinBoxScale->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 10 );
		
		return;
	}    
	
	if((strText == "bit(n)") || (strText == "bit varying(n)"))
	{ 
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 255 );
		
		return;
	}
		
	if((strText == "time [(p)]") || (strText == "time [(p)] with time zone"))
	{ 
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 13 );
		
		m_pSpinBoxPrecision->setValue( 13 );
		return;
	}
	
	if(strText == "date")
	{	
		m_pButtonSetDefaultNow->setEnabled(true);
		return;
	}
	
	if((strText == "timestamp [(p)]") || (strText == "timestamp [(p)] with time zone") || (strText == "interval [(p)]"))
	{ 
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 6 );
		
		m_pSpinBoxPrecision->setValue( 6 );
		m_pButtonSetDefaultNow->setEnabled(true);
	
		return;
	}
}

void KPGCreateDomainWidget2::slotDefaultToggled(bool bDefault)
{
    m_pLineEditDefaultValue->setEnabled(bDefault);
    m_pCheckBoxQuotedDefault->setEnabled(bDefault);
    m_pLineEditDefaultValue->setFocus();
}

void KPGCreateDomainWidget2::slotSetDefaultToNow()
{
	m_pCheckBoxDefault->setChecked(true);
	m_pCheckBoxQuotedDefault->setChecked(false);
	m_pLineEditDefaultValue->setEnabled(true);
	m_pCheckBoxQuotedDefault->setEnabled(true);
	m_pLineEditDefaultValue->setText("now()");
}

void KPGCreateDomainWidget2::slotNumDimensionsChanged(int nDimensions)
{
    if(nDimensions > 0)
    {
      m_pLineEditArrayDimDef->setEnabled(true);
      QString strDimensionsDef;
      for(int i = 0; i < nDimensions; i++)
       strDimensionsDef.append("[]");
       
       m_pLineEditArrayDimDef->setText(strDimensionsDef);
    }
    else
    {
      m_pLineEditArrayDimDef->setEnabled(false);
      m_pLineEditArrayDimDef->setText("");
    }
}

const QString KPGCreateDomainWidget2::getSQL() const
{
	QString strSQL;
	
	// data type
	QString strDataType(m_pComboBoxDataType->currentText());
	QString strNamespace(m_pComboBoxSchema->currentText());
	
	QString strDefinition;
	
	if((m_pComboBoxDataType->currentItem() <= NUM_BASIC_TYPES - 1) || (strNamespace == "public"))
		strDefinition = strDataType;
	else
		strDefinition = "\"" + strNamespace + "\"." +  strDataType;
		
		
	int i;
	if((i = strDefinition.find("(n)")) > 0)
	{
		strDefinition = strDefinition.left(strDefinition.length() - 3); // strip (n)
			
		strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
	}
	
	if((i = strDefinition.find("(p, s)")) > 0)
	{
		strDefinition = strDefinition.left(strDefinition.length() - 6); // strip (p, s)
		
		strDefinition.append(QString("(%1, %2)").arg(m_pSpinBoxPrecision->value()).arg(m_pSpinBoxScale->value()));
	}
	
	if((i = strDefinition.find("[(p)]")) > 0)
	{
		QString strDefinitionPostfix(strDefinition.mid(i + 5, strDefinition.length() - i - 5));
		strDefinition = strDefinition.left(i); // strip (n)
		
		strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
		strDefinition.append(strDefinitionPostfix);
	}
	
	strSQL.append(strDefinition);
	
	// Append array specifiers
	if(m_pSpinBoxNumDimensions->value() > 0)
		strSQL.append(" " + m_pLineEditArrayDimDef->text());
	
	// Constraints --------------------------------------------------------------
	if(m_pCheckBoxNotNull->isChecked()) 
		strSQL.append(" NOT NULL");
			
	if(m_pCheckBoxDefault->isChecked() && ! m_pLineEditDefaultValue->text().isEmpty())
	{
		if(m_pCheckBoxQuotedDefault->isChecked() == false)
			strSQL.append(" DEFAULT " + m_pLineEditDefaultValue->text());
		else
			strSQL.append(" DEFAULT '" + m_pLineEditDefaultValue->text() + "'");
	}
		
	return strSQL;
}
  
#include "kpgcreatedomainwidget2.moc"
