//
// C++ Implementation: kpg2stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpg2stepswizard.h"

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <kcursor.h>
#include <klocale.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../DbObjects/kpgconnection.h"

KPG2StepsWizard::KPG2StepsWizard(QWidget *parent, const QString &strCaption, const QString &strSQL, bool bWithTransaction)
 : KPG2StepsWizardBase(parent, "KPG2StepsWizard")
{
    setCaption(strCaption);
    m_pConnection = 0;
    m_pTextEditSQL->setFont( KPoGreView::configuration()->sqleditor()->font() );   
	m_bWithTransaction = bWithTransaction;
	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditSQL);
	m_pTextEditSQL->setText(strSQL);
	
	m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
    m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
}


KPG2StepsWizard::~KPG2StepsWizard()
{
	delete m_pSyntaxHighlighter;
}

// Set connection for wizard operation
void KPG2StepsWizard::setConnection(KPGConnection * pConnection)
{
	m_pConnection = pConnection;
}

void KPG2StepsWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2)
	{
		// Run SQL statement
		if(m_pConnection == 0)
		{
			kdError() << "KPG2StepsWizard::showPage - Database not connected to server !" << endl;
			m_pTextEditResult->setText("Database not connected to server !");
		}
		else
		{	
			try
  		{	
        setCursor(KCursor::waitCursor());
        
        pqxx::result R = m_pConnection->runQuery(m_pTextEditSQL->text(), m_bWithTransaction ? KPGConnection::eTransNormal : KPGConnection::eTransNone);
				
        if(m_pConnection->notifications().count() > 0)
        {
           m_pTextEditResult->setText(m_pConnection->notifications().join("") + i18n("\nOperation successfull"));
           m_pConnection->clearNotifications();
        }
        else
          m_pTextEditResult->setText(i18n("Operation successfull"));
          
				setFinishEnabled(WizardPage2, true);
        setCursor(KCursor::arrowCursor());
			}
			catch (const std::exception &e)
			{
				m_pTextEditResult->setText(e.what());
        setCursor(KCursor::arrowCursor());  
			}
		}
	}
				
	// call parent
	KPG2StepsWizardBase::showPage(pPage);
}

#include "kpg2stepswizard.moc"
