//
// C++ Implementation: kpgtableconstraintsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtableconstraintsfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgtableconstraintsfolder.h"

KPGTableConstraintsFolderPropPage::KPGTableConstraintsFolderPropPage(QWidget* parent, KPGTableConstraintsFolder * pTableConstraintsFolder)
	: KPGPropertyPage(parent, "KPGTableConstraintsFolderPropPage")
{
	m_pTableConstraintsFolder = pTableConstraintsFolder;
	displayProperties();
}


KPGTableConstraintsFolderPropPage::~KPGTableConstraintsFolderPropPage()
{
}

void KPGTableConstraintsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Constraints &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Type"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Id Deferrable"));
	pHeader->setLabel(nCol++, i18n("Is Deferred"));
	pHeader->setLabel(nCol++, i18n("Namespace"));
  
  	KPGUtil::fillPropertiesTable(m_pTableConstraintsFolder->resultConstraints(), m_pTableItems);
}

