//
// C++ Implementation: kpggroupsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpggroupsfolderproppage.h"

#include <qtable.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "../DbObjects/kpggroupsfolder.h"

KPGGroupsFolderPropPage::KPGGroupsFolderPropPage(QWidget *pParent, KPGGroupsFolder * pGroupsFolder)
 : KPGPropertyPage(pParent, "KPGGroupsFolderPropPage")
{
	m_pGroupsFolder = pGroupsFolder;
	displayProperties();
}

KPGGroupsFolderPropPage::~KPGGroupsFolderPropPage()
{
}

void KPGGroupsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Groups &list:"));
	
	//----------------------------------------------------------------------------
	// Fill output area with query result
	int nRows = m_pGroupsFolder->resultGroups().size();
	int nCols = m_pGroupsFolder->resultGroups().columns();

	m_pTableItems->setNumRows(nRows);
	m_pTableItems->setNumCols(nCols);
	
	// field names
	QHeader* pHeader = m_pTableItems->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("System ID"));
		
	// data
	for(int nRow = 0; nRow < nRows; nRow++)
	{
		for(int nCol = 0; nCol < nCols; nCol++)
		{
	       	QString strValue(m_pGroupsFolder->resultGroups()[nRow][nCol].c_str());
		    m_pTableItems->setText(nRow, nCol, strValue);
		}
	}
	
	for(int nCol = 0; nCol < nCols; nCol++)
	{
		m_pTableItems->adjustColumn(nCol);
	}
}

