//
// C++ Interface: kpgfunctionproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGFUNCTIONPROPPAGE_H
#define KPGFUNCTIONPROPPAGE_H

#include "kpgfunctionproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"
#include "../DbObjects/kpgfunction.h"

class KPGSyntaxHighlighter;
class KPGFunction;


/**
  * Function property page
  *
  * @author Lumir Vanek
  */
class KPGFunctionPropPage : public KPGFunctionPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGFunctionPropPage(QWidget *parent, KPGFunction *);
    ~KPGFunctionPropPage();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
	// Display properties of underlying database object
	virtual void displayProperties();
	
    void displayACL();
    
    void displayArgumentsList();

protected:

    KPGFunction *m_pFunction;
    KPGAclItemList m_listOfAclItems;
    
protected slots:
    
    // Changes syntax highlighting colors.
    void slotSqlEditorSettingsChanged();

	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);
    virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();
    
    // Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
		
signals:
	void sigSearchObject(const pqxx::oid);
    void sigRunWizard(const QString &); 
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
			
protected:
	/** Syntax highlighter for rule definition */
  	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
};

#endif
