//
// C++ Interface: kpgdebuggerchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDEBUGGERCHILDVIEW_H
#define KPGDEBUGGERCHILDVIEW_H

#include <kmdichildview.h>
#include <kparts/factory.h> // KPart Factory

class KXMLGUIFactory;

class QBoxLayout;
class KPoGreView;
class KPGDebugger;
class KPGConnection;
class KPGFunction;


/**
  * MDI child window for PL/pgSQL debugger (not implemented yet ...)
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGDebuggerChildView : public KMdiChildView
{
	Q_OBJECT
public:
    KPGDebuggerChildView(KPoGreView *, KParts::Factory *, KXMLGUIFactory *, KPGConnection *, const QString &, KPGFunction *);
    ~KPGDebuggerChildView();

    KPGDebugger* getDebugger() const { return m_pDebugger; }

	// Return true, if window can be closed
	bool requestClose();
	
private:
	// PL/pgSQL debugger child window
	KPGDebugger*	m_pDebugger;
	
	QBoxLayout* m_pLayout;
	KPoGreView* m_pPoGreView;

public slots:

	// Add KPGDebugger GUI client and its Kate GUI client to factory
	void slotActivated();

	// Remove KPGDebugger GUI client and its Kate GUI client from factory
	void slotDeactivated();
};

#endif
