//
// C++ Implementation: kpgtypesfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtypesfolder.h"

#include <kdebug.h>
#include <kcombobox.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgschema.h"
#include "kpgtype.h"


KPGTypesFolder::KPGTypesFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
 : KPGItemsFolder(parent, i18n("Types"))
{
	setPixmap(0, *m_pIconFolderRed);
	m_oidNameSpace = oidNameSpace;
}


KPGTypesFolder::~KPGTypesFolder()
{
}

void KPGTypesFolder::refresh() throw(const KPGSqlException &)
{
	// delete all child items 
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	// obtain list of data types
	QString strQuery("SELECT t.oid, t.typname, description, CASE WHEN t.typtype = 'b' THEN 'base' WHEN t.typtype = 'c' THEN 'composite' WHEN t.typtype = 'p' THEN 'pseudo' ELSE 'other' END as type, t.typlen, t.typbyval, t.typisdefined, t.typdelim, CASE WHEN t.typalign = 'c' THEN 'char' WHEN t.typalign = 's' THEN 'short' WHEN t.typalign = 'i' THEN 'int' WHEN t.typalign = 'd' THEN 'double' ELSE 'other' END AS align, CASE WHEN t.typstorage = 'p' THEN 'PLAIN' WHEN t.typstorage = 'e' THEN 'EXTERNAL' WHEN t.typstorage = 'm' THEN 'MAIN' WHEN t.typstorage = 'x' THEN 'EXTENDED' END AS typstorage, t.typelem, e.typname as element, t.typinput::oid AS typinputoid, t.typinput, t.typoutput::oid AS typoutputoid, t.typoutput, ct.oid AS tableoid, ct.relname AS tablename, pg_get_userbyid(t.typowner) as owner ");
	strQuery.append("FROM pg_catalog.pg_type t ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_type e ON e.oid=t.typelem ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_class ct ON ct.oid=t.typrelid AND ct.relkind <> 'c' ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=t.oid ");
	strQuery.append("WHERE t.typtype != 'd' AND t.typnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY typname"); // AND t.typname NOT LIKE '\\\\_%%' 
				
	try
	{
		m_pqxxResultTypes = connection()->runQuery(strQuery);
	
		KPGType *pType = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultTypes.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultTypes[i][0].to(oid);
			
			if(pType == 0)
				pType = new KPGType(this, m_pqxxResultTypes[i]["typname"].c_str(), oid);
			else
				pType = new KPGType(this, pType, m_pqxxResultTypes[i]["typname"].c_str(), oid);
					
								
			pType->setProperties(m_pqxxResultTypes[i]);
				
			// Refresh attributes list
			pType->refresh();
		}
	}
	catch (const KPGSqlException &e)
	{
		kdError() << k_funcinfo << "Routing exception up. Types folder. " << text(0) << endl;
		throw; // if it is KPGSqlException re-throw it
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

void KPGTypesFolder::fillComboBoxWithChildItems(KComboBox *pComboBox, bool bOnlyUserTypes)
{
  QListViewItem * pItem = firstChild();
  while(pItem)
  {
    KPGType *pType = static_cast <KPGType *> (pItem);
    
    //               only base types, that names not starts with underscore
    if(!bOnlyUserTypes || ((pType->kind() == "base") && pType->text(0)[0] != '_'))
      pComboBox->insertItem(* pItem->pixmap(0), pItem->text(0));   
    
    pItem = pItem->nextSibling();
  }
}

