#ifndef KSIPREGISTRATIONS_H_INCLUDED
#define KSIPREGISTRATIONS_H_INCLUDED
#include <qdialog.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qbutton.h>
#include <qlabel.h>

#include "../dissipate2/sipcall.h"


class QLineEdit;
class SipUser;
class SipClient;
class SipRegister;
class KPhoneView;

struct Kstate {
  public:
        enum KsipState {
            OFFLINE    = 0,
            UNREG      = 1,
            REG        = 2, 
            AUTHREQ    = 3,
            PROC_UNREG = 10,
            PROC_REG   = 11,
            PROC_TRY   = 12,
            LAST = 99
        };
};

class KSipIdentityEdit : public QDialog , public Kstate
{
	Q_OBJECT
public:
	KSipIdentityEdit( QWidget *parent, const char *name,  QObject *reg );
	~KSipIdentityEdit( void );
	void setReadOnly( bool mode );
	void updateState( KsipState state );
	void setAutoRegister( bool newAutoRegister ) { autoRegister->setChecked( newAutoRegister ); }
	bool getAutoRegister( void ) { return autoRegister->isChecked(); }
	QString getFullname( void ) const;
	QString getUsername( void ) const;
	QString getHostname( void ) const;
	QString getSipProxy( void ) const;
	QString getSipProxyUsername( void ) const;
	QString getUri( void ) const;
	QString getQvalue( void ) const;
	void setFullname( const QString &newFullname );
	void setUsername( const QString &newUsername );
	void setHostname( const QString &newHostname );
	void setSipProxy( const QString &newSipProxy );
	void setSipProxyUsername( const QString &newSipProxyUsername );
	void setDefault( bool newDefault );
	void setQvalue( const QString &newSipProxy );

signals:
	void update( void );

protected slots:
	void slotOk( void );
	void slotCancel( void );

private:
	QLineEdit *fullname;
	QLineEdit *username;
	QLineEdit *hostname;
	QLineEdit *sipProxy;
	QLineEdit *sipProxyUsername;
	QLineEdit *qValue;
	QCheckBox *autoRegister;
	QLabel *labelRegister;
	QPushButton *buttonRegister;
	bool editMode;
	QPushButton *helpPushButton;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
};

class KSipRegistrations : public QObject , public Kstate
{
	Q_OBJECT
public:
	KSipRegistrations( SipClient *client,
		KPhoneView *phoneView = 0, QWidget *p = 0, const char *name = 0 );
	~KSipRegistrations( void );
	void showIdentity( void );
	void unregAllRegistration( void );
	bool getUseStun( void ) { return useStun; }
	QString getStunSrv( void ) { return stunSrv; }

private slots:
	void changeRegistration( void );
	void editRegistration( void );
	void update( void );
	void registerStatusUpdated( void );

private:
	void setRegisterState( void );
	void save( void );
	SipClient *c;
	KSipIdentityEdit *edit;
	KPhoneView *v;
	QString userPrefix;
	SipUser *u;
	SipRegister *sipreg;
	bool autoRegister;
	int expires;
	QWidget *parent;
	bool useStun;
	QString stunSrv;
};

#endif // KSIPREGISTRATIONS_H_INCLUDED
