
#include <kore/version.h>
#include <kore/servicemanager.h>
#include <kore/kernel.h>
#include <kore/modulemanager.h>

#include "modviewfact_impl.h"
#include "moduleview_impl.h"

#define MVF_MAJOR 0
#define MVF_MINOR 0
#define MVF_REVISION 1
#define MVF_VERSION "0.0.1"
#define MVF_API_MAJOR 0
#define MVF_API_MINOR 0
#define MVF_API_REVISION 2
#define MVF_API_VERSION "0.0.2"
#define MVF_NAME "ModuleView Factory"
#define MVF_TYPE MODULEVIEWFACTORY_TYPE
#define MVF_DESCRIPTION "Creates ModuleViews on demand."
#define MVF_SERVICE MODULEVIEWFACTORY_SERVICE
#define MVF_SERVICE_DESCRIPTION "'" MODULEVIEWFACTORY_SERVICE "' service"

ModViewFactImpl::ModViewFactImpl()
{
    _mvfVersion = new Version(MVF_MAJOR,MVF_MINOR,MVF_REVISION,MVF_VERSION);
    _mvfAPIVersion = new Version(MVF_API_MAJOR,MVF_API_MINOR,MVF_API_REVISION,MVF_API_VERSION);
    _mvfInfo = new Info(this, MVF_NAME, MVF_TYPE, MVF_DESCRIPTION, _mvfVersion, _mvfAPIVersion);
    setInfo(_mvfInfo);
    _mvfService = new Service(this, MVF_SERVICE, MVF_SERVICE_DESCRIPTION);
    addService(_mvfService);
}
ModViewFactImpl::~ModViewFactImpl()
{
    delete _mvfInfo;
    delete _mvfVersion;
    delete _mvfAPIVersion;
    delete _mvfService;
}

ModuleView* ModViewFactImpl::createView( Module* mod, QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0 )
{
    return new ModuleViewImpl(mod, parent, name, modal, fl);
}
ModuleView* ModViewFactImpl::reuseView( Module* mod, QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0 )
{
    // check for a provider for service "Kore/UI/Module View/<modname>"
    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*> (sm->registeredProvider("Kore/Kernel/Module Manager"));
    ModuleView* mv;
    char* srv = new char[ strlen(MODULEVIEW_SERVICE) + strlen(mod->info()->name()) + 4];
    strcat( strcat( strcat( strcpy( srv, MODULEVIEW_SERVICE),"/<" ), mod->info()->name() ), ">");
    mv = dynamic_cast<ModuleView*> (sm->registeredProvider(srv));
    if( !mv )
    {
        mv = createView(mod, parent, name, modal, fl);
        if( mm )
            mm->registerModule(mv);
        sm->registerProvider(mv);
    }
    return mv;
}
void ModViewFactImpl::destroyViews()
{
    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*> (sm->registeredProvider("Kore/Kernel/Module Manager"));
    ServiceProvider** mv = sm->registeredProviders(MODULEVIEW_SERVICE);
    for(int i= 0; mv[i]; i++)
    {
        if( mm )
            mm->unregisterModule(mv[i]);
        sm->unregisterProvider(mv[i]);
    }
}
