
#include <qapp.h>

#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>

//temporary
#include "modulebrowser_impl.h"
#include "modviewfact_impl.h"

int main(int argc, char**argv)
{
    QApplication app(argc, argv);

    // Temporary {
//    ModuleView* mv = new ModuleView_mod();
    ModuleViewFactory *factory = new ModViewFactImpl();
    ModuleBrowser *browser = new ModuleBrowserImpl(NULL, NULL, 0);
    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*> (sm->registeredProvider("Kore/Kernel/Module Manager"));
    if( mm )
    {
        mm->registerModule(factory);
        mm->registerModule(browser);
    }
    sm->registerProvider(factory);
    sm->registerProvider(browser);
    // Temporary }

    app.setMainWidget(browser);
    browser->show();
    int ret =  app.exec();

    factory->destroyViews();
    sm->unregisterProvider(browser);
    sm->unregisterProvider(factory);
    if( mm )
    {
        mm->unregisterModule(browser);
        mm->unregisterModule(factory);
    }
    delete browser;
    delete factory;
    delete Kernel::instance();
    return ret;
}
