#ifndef MODULEBROWSERIMPL_H
#define MODULEBROWSERIMPL_H

#include <qlistview.h>

#include "modulebrowser_qt.h"

namespace kore
{
class Version;
};

class ModuleBrowserImpl : public ModuleBrowserWidget
{
    Q_OBJECT

public:
    ModuleBrowserImpl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    virtual ~ModuleBrowserImpl();

protected slots:
    void slotClose();
    void slotRefreshColumns(int);
    void slotRefreshModuleList();
    void slotSelectionChanged();
    void slotShowModuleProperties();
    void slotUnregisterModules();

private:
    class ModuleListItem: public QListViewItem
    {
    public:
        ModuleListItem( QListView* parent, kore::Module* mod);

        kore::Module* module() { return _module; };
    private:
        kore::Module* _module;
    };

    // kore::Module and kore::ServiceProvider specific stuff
    // current version
    const kore::Version* _mbVersion;
    // Kernel API version required
    const kore::Version* _mbAPIVersion;
    // info
    const kore::Module::Info* _mbInfo;
    // service
    const kore::ServiceProvider::Service* _mbService;
};

#endif // MODULEBROWSERIMPL_H
