
#include <qlistview.h>
#include <qlabel.h>
#include <qlistview.h>

#include <kore/version.h>
#include <kore/module.h>

#include "moduleview_impl.h"

using namespace kore;

/*
 *  Constructs a ModuleViewImpl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ModuleViewImpl::ModuleViewImpl( Module* mod, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : ModulePropertiesDlg( parent, name, modal, fl )
{
    _module = mod;
    // disable sorting
    modulePropertiesView->setSorting(-1);
    const Module::Info* nfo = mod->info();
    setCaption( caption()+": "+nfo->name());
    descriptionLabel->setText( nfo->description() );
    // Module
    QListViewItem* item = modulePropertiesView->firstChild();
    QString addr;
    addr.sprintf("0x%08x", mod);
    item->setText(1, addr);
    // Info
    item = item->firstChild();
    addr.sprintf("0x%08x", nfo);
    item->setText(1, addr);
    // Name
    item = item->firstChild();
    item->setText(1, nfo->name() );
    // Type
    item = item->nextSibling();
    item->setText(1, nfo->type() );
    // Version
    item = item->nextSibling();
    item->setText(1, (const char*) (*nfo->version()) );
    // Version Major
    item = item->firstChild();
    item->setText(1, QString::number(nfo->version()->major()) );
    // Version Minor
    item = item->nextSibling();
    item->setText(1, QString::number(nfo->version()->minor()) );
    // Version Revision
    item = item->nextSibling();
    item->setText(1, QString::number(nfo->version()->revision()) );
    // API Version
    item = item->parent()->nextSibling();
    item->setText(1, (const char*) (*nfo->APIVersion()) );
    // API Major
    item = item->firstChild();
    item->setText(1, QString::number(nfo->APIVersion()->major()) );
    // API Minor
    item = item->nextSibling();
    item->setText(1, QString::number(nfo->APIVersion()->minor()) );
    // API Revision
    item = item->nextSibling();
    item->setText(1, QString::number(nfo->APIVersion()->revision()) );
    // Description
    item = item->parent()->nextSibling();
    item->setText(1, nfo->description() );
}

/*
 *  Destroys the object and frees any allocated resources
 */
ModuleViewImpl::~ModuleViewImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

