
#include <qapp.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qlistview.h>
#include <qstring.h>
#include "modulebrowser_impl.h"
#include "moduleview_impl.h"

/*
 *  Constructs a ModuleBrowserImpl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
ModuleBrowserImpl::ModuleBrowserImpl( QWidget* parent,  const char* name, WFlags fl )
    : ModuleBrowserWidget( parent, name, fl )
{
}

/*
 *  Destroys the object and frees any allocated resources
 */
ModuleBrowserImpl::~ModuleBrowserImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 * protected slot
 */
void ModuleBrowserImpl::slotClose()
{
    QApplication::exit(0);
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotRefreshColumns(int id)
{
    QButton* btn = showColumns->find(id);
    QString columnName(btn->name());
    columnName.remove(0,4);
    if( btn->isOn() )
    {
        moduleListView->addColumn( columnName );
    }
    else
    {
        int column;
        for(column = 0; column < moduleListView->columns() ; column++)
            if( moduleListView->columnText( column ) == columnName )
                break;
        moduleListView->removeColumn(column);
    }
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotRefreshModuleList()
{
    qWarning( "ModuleBrowserImpl::slotRefreshModuleList() not yet implemented!" );
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotSelectionChanged()
{
    qWarning( "ModuleBrowserImpl::slotSelectionChanged() not yet implemented!" );
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotShowModuleProperties()
{
    ModulePropertiesDlg* prop = new ModuleViewImpl();
    prop->show();
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotUnregisterModules()
{
    qWarning( "ModuleBrowserImpl::slotUnregisterModules() not yet implemented!" );
}

