
#ifndef KOREDLG_PLUGIN_H
#define KOREDLG_PLUGIN_H

#ifdef WIN32
#include <windows.h>
#ifdef KOREDLG_MFC_EXPORTS
#define KOREDLG_API __declspec(dllexport)
#else
#define KOREDLG_API __declspec(dllimport)
#endif
#else
#define KOREDLG_API
#endif

#include <kore/plugin.h>

#include "koredlg_mfc.h"

using namespace kore;

extern "C"
{
    KOREDLG_API PLUGIN_MAIN_HDR(libHandle,libName,libPath,libFlags);
}

class KoreDlgPlugin: public Plugin
{
public:
    KoreDlgPlugin(HMODULE libhandle, const char* libname, const char* libpath, int flags);
    ~KoreDlgPlugin();
    virtual void pluginLoaded();
    virtual void initPlugin();
    virtual void unloadingPlugin();
private:
    // KreDlgPlugin version
    const Version* _pluginVersion;
    // Kernel API version required by KoreDlgPlugin
    const Version* _pluginAPIVersion;
    // KoreDlgPlugin info
    const Info* _pluginInfo;
    KoreDlg_mfc* dlg;
};

#endif
