#ifndef KERNEL_H
#define KERNEL_H

#include <kore/kore.h>
#include <kore/serviceprovider.h>

namespace kore
{

class ServiceManager;
class PluginLoader;
class ModuleManager;
class PluginManager;

/**
 * class core::Kernel - the Kernel
 * This class is responsible for providing kore services to runtime modules
 * This is a singleton, use kore::Kernel::instance() for getting access to an instance
 */
class KORE_API Kernel: public ServiceProvider
{
public:
    /**
     * Gets the single instance of Kernel
     * @return - the only instance of this class
     */
    static Kernel* instance();
    /**
     * Gets the Kore ServiceManager.
     * @return - the ServiceManager associated to this Kernel
     */
    ServiceManager* serviceManager() const;

    /**
     * Destructor.
     */
    virtual ~Kernel();
protected:
    /**
     * Default contructor. Protected in order to prevent random instantion
     * outside this class, while allowing sub-classing.
     */
    Kernel();
    /**
     * Helper method for setting the Kernel single instance.
     * @param inst - the Kernel instance to be returned by Kernel::instance().
     */
    static void setInstance(Kernel* inst);
    /**
     * Helper method for setting the ServiceManager associated to this Kernel.
     * @param sm - the ServiceManager to be returned by
     * Kernel::instance()::serviceManager().
     */
    void setServiceManager(ServiceManager* sm);
private:
    // current kernel version
    const Version* _version;
    // Kernel info
    const Info* _info;
    // basic Kernel service
    const Service* _kernelService;
    // the Kernel single instance
    static Kernel* _instance;
    // the ServiceManager associated to this Kernel
    ServiceManager* _serviceManager;
    // the default Kore PluginLoader
    PluginLoader* _pluginLoader;
    // the default Kore ModuleManager
    ModuleManager* _moduleManager;
    // the default Kore PluginManager
    PluginManager* _pluginManager;
};

};

#endif
