
#include <iostream.h>
#include <kore/kore.h>
#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>
#include <kore/pluginloader.h>
#include <kore/plugin.h>

using namespace kore;

/**
 * Main Kore application.
 * It loads and starts the Kernel
 */
int main(int argc, char* argv[]) {
/*  KApplication app(argc,argv,"");

  if (app.isRestored())
    {
      RESTORE( App );
    }
  else 
    {
      App*  = new App( "" );
      ->show();
    }
  return app.exec();
*/
//    Kernel::instance()->init();
    cout << Kernel::instance()->info()->name() << " v" << (*(Kernel::instance()->info()->version())) << endl;
    PluginLoader* loader = dynamic_cast<PluginLoader*> (Kernel::instance()->serviceManager()->registeredProvider("Kore/Kernel/Plugin Loader"));
    Plugin* plugin = loader->openPlugin("koretest");
    if( plugin )
    {
        ModuleManager* mm = dynamic_cast<ModuleManager*> (Kernel::instance()->serviceManager()->registeredProvider("Kore/Kernel/Module Manager"));
        if( mm )
            mm->registerModule(plugin);
        cout << plugin->info()->name() << " v" << (*(plugin->info()->version())) << endl;
        if( mm )
            mm->unregisterModule(plugin);
        loader->closePlugin(plugin);
    }
    else
	cout << "<-- " << loader->lastError() << " -->" << endl;
    delete Kernel::instance();
    return 0;
}



