/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : 07/20/1999
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "xmlnode.h"

XMLNode::XMLNode()
{

}

XMLNode::XMLNode( XMLNode &t )
{
 	int i;
 	
 	setName( t.getName() );
 	setValue( t.getValue() );
 	
 	// Copy all the child nodes
 	for( i=0; i<t.numberChildNodes(); i++ )
 	{
 		XMLNode *newNode = new XMLNode( *t.getChildNode( i ) );
 		childNodes.append( newNode );
 	}
 	
 	// Copy all the attributes
 	for( i=0; i<t.numberAttributes(); i++ )
 	{
 		AttributePair *newAttrib = new AttributePair;
 		t.getAttributePair( i, newAttrib->parameter, newAttrib->value );
 		
 		attributes.append( newAttrib );
 	}
}

XMLNode::XMLNode( QString name )
{
	setName( name );
}

XMLNode::~XMLNode()
{

}
	
void XMLNode::addChildNode(XMLNode *t)
{
	childNodes.append( t );
}
	

void XMLNode::setAttribute(QString p, QString v)
{
	AttributePair *attribute = 0;
	unsigned int i;
	
	// First see if we can find an attribute by the same name
	for( i=0; i<attributes.count(); i++ )
	{
	 	if ( strcmp( attributes.at(i)->parameter, p ) == 0 )
	 		attribute = attributes.at(i);
	}

	if( attribute == 0 )
	{
		// No attribue by that name was found...so we will
		// add one
		attribute = new AttributePair;
		attribute->parameter = p.copy();
		attribute->value = v.copy();
		attributes.append( attribute );
	}
        else
                attribute->value = v.copy();

	// Update the parameter value
}

QString XMLNode::getAttribute(QString s)
{
	// Protect us from core dumps
	if (this == NULL)
		return NULL;

		
	AttributePair *attribute = 0;
	unsigned int i;
	
	// First see if we can find an attribute by the same name
	for( i=0; i<attributes.count(); i++ )
	{
	 	if ( strcmp( attributes.at(i)->parameter, s ) == 0 )
	 		attribute = attributes.at(i);
	}

	if (attribute == 0)
		return 0;
	else
		return attribute->value.copy();			
}

int XMLNode::numberAttributes()
{
	return attributes.count();
}

void XMLNode::getAttributePair( int n, QString &parameter, QString &value )
{
	AttributePair *attribute;

	parameter = (const char *)0;
	value = (const char *)0;
	
 	if ( (unsigned int)n >= attributes.count() )
 		return;
 		 	
 	attribute = attributes.at( n );
 	
 	parameter = attribute->parameter;
 	value = attribute->value;
}

QString XMLNode::getName()
{
 	return tagName.copy();
}

QString XMLNode::getValue()
{
	if (this == NULL)
		return (const char *)0;
	
	return tagValue.copy();
}

int XMLNode::numberChildNodes()
{
	return childNodes.count();
}

XMLNode *XMLNode::getChildNode(int n)
{
	return childNodes.at( n );
}

void XMLNode::deleteChildNode(int n)
{
	childNodes.remove( n );
}

XMLNode *XMLNode::getChildNode(QString s, bool autoCreate )
{
	unsigned int i;
	XMLNode *node=0;
	
	// Find our node by name
	for( i=0; i<childNodes.count(); i++)
	{
		if ( strcmp( childNodes.at(i)->getName(), s ) == 0 )
			node = childNodes.at(i);
	}
	
	if (autoCreate == true && node == 0)
	{
		node = new XMLNode();
		node->setName( s );
		childNodes.append( node );
	}

	return node;
}


/* This function will create XML from what it was given */
QString XMLNode::getXML()
{
	QString XML;
	int i;

	XML = "<";
	XML.append(getName());

	for (i=0; i<numberAttributes(); i++)
	{
		QString parameter, value;

		getAttributePair( i, parameter, value );

		parameter.sprintf("%s='%s'", (const char *)parameter, (const char *)escape(value) );

		XML.append(" ");
		XML.append(parameter);
	}


	if (numberChildNodes() > 0)
	{
		XML.append(">");

		for (i=0; i<numberChildNodes(); i++)
		{
			XML.append(getChildNode(i)->getXML());
		}
		XML.append("</");
		XML.append(getName());
		XML.append(">");
	}
	else if (!getValue().isNull())
	{
		XML.append(">");
		XML.append(escape(getValue()));
		XML.append("</");
		XML.append(getName());
		XML.append(">");
	}
	else
	{
		XML.append("/>");
	}

	return XML;

}

void XMLNode::setName(QString newName)
{
	tagName = newName.copy();
}

void XMLNode::setValue(QString newValue)
{
 	tagValue = newValue.copy();
}

QString XMLNode::escape(QString s)
{
	QString str;
	str = s;
	
	str.replace( QRegExp("&", false), "&amp;");
	str.replace( QRegExp("'", false), "&apos;");
	str.replace( QRegExp("\"", false), "&quot;");
	str.replace( QRegExp("<", false), "&lt;");
	str.replace( QRegExp(">", false), "&gt;");
	
	return str;
}

QString XMLNode::descape(QString s)
{
	QString str;
	str = s;
	
	str.replace( QRegExp("&amp;", FALSE), "&");
	str.replace( QRegExp("&apos;", FALSE), "'");
	str.replace( QRegExp("&quot;", FALSE), "\"");
	str.replace( QRegExp("&lt;", FALSE), "<");
	str.replace( QRegExp("&gt;", FALSE), ">");
	
	return str;
}

void XMLNode::printXML(XMLNode *t, int tabLevel)
{
	int count_i;
	QString tab = " ";

	// Determine the tab level
	for (count_i=0; count_i<tabLevel; count_i++)
		tab.append("\t");
	
 	printf( "%s<%s", (const char *)tab, (const char *)t->getName() );
 	
 	for(count_i=0; count_i<t->numberAttributes(); count_i++)
 	{
 		QString parameter, value;
 		t->getAttributePair( count_i, parameter, value );
 		printf(" %s='%s'", (const char *)parameter, (const char *)value);
 	}

 	if (t->numberChildNodes() != 0)
 	{ 	 	
 		printf(">\n");
	 	for(count_i=0; count_i<t->numberChildNodes(); count_i++)
	 	{
	 		XMLNode *next;
	 		next = t->getChildNode( count_i );
	 		
	 		printXML( next, tabLevel + 1 );
	 	}
 		
 		printf("%s</%s>\n", (const char *)tab, (const char *)t->getName());
 	}
 	else if (!t->getValue().isNull())
 	{
 		printf( ">%s</%s>\n", (const char *)t->getValue(), (const char *)t->getName());
	}
	else
	{
		printf("/>\n");
	} 		
}








