/***************************************************************************
                          xmlfile.h  -  description                              
                             -------------------                                         
    begin                : Fri Jun 9 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef XMLFILE_H
#define XMLFILE_H
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <dirent.h>

#include <qwidget.h>

#include <kapp.h>

#include <expat.h>
#include <xmlnode.h>

/**
  * This class provides a simple interface between XML files and the XML node class.
  *
  * All you have to do is "point" a new XMLFile class at the file you want to read
  * (or write to) and it will parse it.  Because this class inherits from XMLNode
  * you can call all your favorite functions, the root node is ALWAYS <file> with
  * this class.  When you are done making your changes to the XML file, call sync()
  * and your changes will be written back to the file.
  *
  *
  * @author Seth Hartbecke
  * @see Expat
  * @see XMLNode
  */

class XMLFile
	: public Expat, public XMLNode
{
   Q_OBJECT
public:
	/**
	 * Create a new XMLFile (or read an existing one)
	 * @param filePath   If null, then will default to $HOME/.kde/share/apps/konverse
	 * @param filename   The name of the file (in that directory) to read
	 * @param parent     Standard QObject parent stuff
	 * @param name       QT stuff again
	 */
	XMLFile(QString filePath, QString filename, QObject *parent=0, const char *name=0);
	~XMLFile();

	/**
	 * Writes any changes that you may have made back to the file.
	 * @return This will return a false value if it failes
	 */
	bool sync();
protected:
        /**
	 * You don't need to override this
	 */
	void recievedTag( XMLNode *n );

        /**
	 * You don't need to override this
	 */
	void rootTagRecieved( XMLNode *n );

private:
	void testDir(QString dir);
	void clear();
	void read();

	QString file;
	int fd;
};

#endif
