/***************************************************************************
                          userlistmenu.h  -  description
                             -------------------
    begin                : Sat Oct 21 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _SETSTATUS_H_
#define _SETSTATUS_H_

#include <qwidget.h>
#include <qpopupmenu.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qcombobox.h>

#include <jabbercore.h>
#include <qlabel.h>



/*

 	This class contains widgets for changing your lonline status.

        SetStatusMenu is a popup menu ment to be used in the tool tray for setting status
        that when an item is chosen creates a DlgSetStatus that confirms they want to change
        their status and allows them to enter a description for other clients to see.

*/

/**
 * This is a dialog that is used of changing the status of the logged in user.  Use the static method to
 * create it (makes sure there is only one open at any given time).
 */
class DlgSetStatus
	: public QWidget
{
	Q_OBJECT
public:
        /**
	 * Default constructor, auto selects the status in the dropdown specified
	 */
	DlgSetStatus( JabberCore::StatusType defaultStatus = JabberCore::Normal );
        ~DlgSetStatus();

	/**
	 * Opens a new set status dialog and sets the dropdown to the selection specified.
	 * If there is already a dialog open, it just sets the dropdown
	 */
        static void setStatus( JabberCore::StatusType defaultStatus = JabberCore::Normal );

private slots:
	void okClicked();
        void cancelClicked() { close(); };

        void statusChanged( int i );

private:
	static DlgSetStatus *openDlg;
	void closeEvent(QCloseEvent *);


	QLabel *lblStatus, *lblDescription, *lblPriority;
        QPushButton *ok, *cancel;
        QComboBox *cboStatus;
        QLineEdit *txtDescription;
	QSpinBox *spnPriority;
        QGridLayout *layout;
        QHBoxLayout *btnLayout;
};

/**
 * This is a status menu that you can include in other menus simpally
 *
 * This shows the valid status types to jabber and allows the user to select which one they want to
 * change to, upon selecting one it opens a set status dialog
 *
 * @see DlgSetStatus
 */
class SetStatusMenu
	: public QPopupMenu
{
	Q_OBJECT
public:
	SetStatusMenu(QWidget *parent=0, const char *name = 0);
        ~SetStatusMenu();

private slots:
        void connectionStatusChanged();
	void setChat() { DlgSetStatus::setStatus( JabberCore::Chat ); };
        void setNormal() { DlgSetStatus::setStatus( JabberCore::Normal ); };
        void setAway() { DlgSetStatus::setStatus( JabberCore::Away ); };
        void setExendedAway() { DlgSetStatus::setStatus( JabberCore::ExtendedAway ); };
        void setDND() { DlgSetStatus::setStatus( JabberCore::DND ); };
private:
	int idChat, idNormal, idAway, idxa, idDND;

};

/**
 * This is a combo box that the user can use to change their status.  It defaults to the current status of
 * the system, when the user selects a different status type it will open a DlgSetStatus.
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 * @short Combo box for changing status
 * @see DlgSetStatus
 */
class SetStatusCbo
        : public QComboBox
{
        Q_OBJECT
public:
        SetStatusCbo( QWidget *parent=0, const char *name = 0 );

private slots:
        void connectionStatusChanged();
        void selectionChanged();
};
#endif

