/***************************************************************************
                          rostertree.cpp  -  description
                             -------------------
    begin                : Tue Jan 11 2000
    copyright            : (C) 2000 by Seth Hartbecke
                                (C) 2001 Seth Hartbecke
                                              Jerome Lalande
    email                : gandalf@netins.net

    Modified:           2001-05-22 Jerome Lalande
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later versifmon.                                   *
 *                                                                         *
 ***************************************************************************/


#include "rostertree.h"

#include "userpresence.h"

RosterTree::RosterTree(QWidget *, const char * )
	: KMainWindow( 0, "Konverse" )
{
        setCaption("Roster");

	roster = new QListView( this, "arosterlist" );
        setCentralWidget( roster );

        _mainToolbar = toolBar( "buttonbar" );
        _mainToolbar->enable( KToolBar::Show );
        _mainToolbar->setBarPos( KToolBar::Top );
        _mainToolbar->insertButton( "connect_creating", -1, SIGNAL(clicked()), this, SLOT(changeConnection()), true, "Connect/Disconnect" );
        _mainToolbar->insertSeparator();
        _mainToolbar->insertButton( "add_user", -1, SIGNAL(clicked()), this, SLOT(addUser()), true, "Add User to Buddy List" );
        _mainToolbar->insertSeparator();
        _mainToolbar->insertButton( "new_message", -1, SIGNAL(clicked()), this, SLOT(newMessage()), true, "Start Chat" );
	// TODO: Enable for version 0.3
	// (currently no code yet for working with vcards)
        // _mainToolbar->insertButton( "vcard", -1, true, "Show VCard" );



        _statusToolbar = toolBar( "statusbar" );
        _statusToolbar->enable( KToolBar::Show );
        _statusToolbar->setBarPos( KToolBar::Bottom );

        currStatus = new SetStatusCbo( _statusToolbar, "cbochangestatus" );
        _statusToolbar->insertWidget( 1, currStatus->sizeHint().width(), currStatus );

	roster->addColumn("Roster");
	roster->setRootIsDecorated( true );

        connect( jabber, SIGNAL(newGroup(Group *)), this, SLOT(newGroup(Group *)) );

	connect( roster, SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(rightButtonClicked(QListViewItem *, const QPoint &)) );
	connect( roster, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(dblClick(QListViewItem *)) );

        rosterMnu = new QPopupMenu( this, "rostermenu" );
        addUserID = rosterMnu->insertItem( "&Add User...", this, SLOT(addUser()) );
        rosterMnu->insertSeparator();
        setStatusID = rosterMnu->insertItem( "&Set Status...", new SetStatusMenu );
        otherIMSystemsID = rosterMnu->insertItem( "&Other IM Systems...", this, SLOT(setupTransports()) );
        rosterMnu->insertItem( "&Join Chatroom...", this, SLOT(groupChat()) );
        rosterMnu->insertSeparator();
        rosterMnu->insertItem( "&Preferences", this, SLOT(showPrefs()) );
        rosterMnu->insertSeparator();
        connectID = rosterMnu->insertItem( "&Connect...", this, SLOT(connectToJabber()) );
        disconnectID = rosterMnu->insertItem( "&Disconnect", this, SLOT(disconnect()) );
        rosterMnu->insertSeparator();
        rosterMnu->insertItem( KGlobal::iconLoader()->loadIcon("fileclose", KIcon::Small), "&Close", this, SLOT(hide()) );
        rosterMnu->insertItem( KGlobal::iconLoader()->loadIcon("exit", KIcon::Small), "&Quit", this, SLOT(exit()) );

        rosterMnu->setItemEnabled( addUserID, false );
        rosterMnu->setItemEnabled( setStatusID, false );
        rosterMnu->setItemEnabled( otherIMSystemsID, false );
        rosterMnu->setItemEnabled( connectID, true );
        rosterMnu->setItemEnabled( disconnectID, false );

        helpMnu = helpMenu( );

        menuBar()->insertItem( "&Roster", rosterMnu );
        menuBar()->insertItem( "&Help", helpMnu );

        connect( jabber, SIGNAL(connected()), this, SLOT(connectionChanged()) );
        connect( jabber, SIGNAL(disconnected()), this, SLOT(connectionChanged()) );

        applyMainWindowSettings(kapp->config(), "Main Window");
}

void RosterTree::changeConnection()
{
	if (jabber->isConnected())
		disconnect();
	else
		connectToJabber();
}

void RosterTree::connectionChanged()
{
        if (jabber->isConnected())
        {
                rosterMnu->setItemEnabled( addUserID, true );
                rosterMnu->setItemEnabled( setStatusID, true );
                rosterMnu->setItemEnabled( otherIMSystemsID, true );
                rosterMnu->setItemEnabled( connectID, false );
                rosterMnu->setItemEnabled( disconnectID, true );
        }
        else
        {
                rosterMnu->setItemEnabled( addUserID, false );
                rosterMnu->setItemEnabled( setStatusID, false );
                rosterMnu->setItemEnabled( otherIMSystemsID, false );
                rosterMnu->setItemEnabled( connectID, true );
                rosterMnu->setItemEnabled( disconnectID, false );
        }
}

void RosterTree::newMessage()
{
	QListViewItem *selected = roster->selectedItem();
	if (selected)
		((RosterMenuItem *)selected)->dblClick();
}

void RosterTree::dblClick( QListViewItem *item )
{
 	((RosterMenuItem *)item)->dblClick();
}

void RosterTree::rightButtonClicked(QListViewItem *item, const QPoint &point)
{
	if ( item != 0 )
		((RosterMenuItem *)item)->rightClick( point );
}

bool RosterTree::queryClose()
{
        // Actually...we just want to hide
        hide();
        return FALSE;
}

RosterTree::~RosterTree()
{
        saveMainWindowSettings(kapp->config(), "Main Window");
        kapp->config()->sync();
}

void RosterTree::newGroup( Group *g )
{
 	(void)new GroupItem( g, roster, g->getName() );
}

/***********************************************************************
************************ RosterMenuItem*********************************
***********************************************************************/
RosterMenuItem::RosterMenuItem( QListViewItem *parent, const char *name )
	: QObject( 0, name )
        , QListViewItem( parent, name )
{
        _parentItem = parent;
        parentType = 1;
}

RosterMenuItem::RosterMenuItem( QListView *parent, const char *name )
	: QObject( parent, name )
        , QListViewItem( parent, name )
{
        _parentView = parent;
        parentType = 2;
}

void RosterMenuItem::dblClick()
{

}

void RosterMenuItem::rightClick( const QPoint & )
{

}

void RosterMenuItem::hide()
{
        QListView *list;

        if ( parentType == 1 )
                list = _parentItem->listView();
        else
                list = _parentView;


        list->takeItem( this );
}

void RosterMenuItem::show()
{
        if ( parentType == 1 )
                _parentItem->insertItem( this );
        else
                _parentView->insertItem( this );
}

/***********************************************************************
************************ GroupItem *************************************
***********************************************************************/
GroupItem::GroupItem( Group *g, QListView *parent, const char *name )
	: RosterMenuItem( parent, name )
{
        _parent = parent;
 	setOpen( true );

        int i;
        for (i=0; i<g->numberUsers(); i++)
        	addUser( g, g->getUser(i) );

        connect( g, SIGNAL(newUser(Group *, User *)), this, SLOT(addUser(Group *, User *)) );
        connect( g, SIGNAL(deleteUser(Group *, User*)), this, SLOT(deleteUser(Group *, User *)) );
        connect( g, SIGNAL(deletedGroup(Group *)), this, SLOT(deleteGroup(Group *)) );

        if ( g->getName().isEmpty() )
                _parent->takeItem( this ); // Make sure we do not show

}

void GroupItem::addUser(Group *g, User *u)
{
        UserItem *newUI;
        if ( g->getName().isEmpty() )
                newUI = new UserItem( _parent, u, g->getName() );
        else
 	        newUI = new UserItem( this, u, g->getName() );
        userItems.insert(u, newUI);
}

void GroupItem::deleteUser(Group *, User *u)
{
	if ( userItems.contains( u ) )
        {
        	delete userItems[u];
                userItems.remove( u );
        }
}

void GroupItem::deleteGroup(Group *)
{
	delete this;
}

/***********************************************************************
************************ UserItem **************************************
***********************************************************************/
UserItem::UserItem( QListViewItem *group, User *u, QString g )
        : RosterMenuItem( group, u->getRealName() )
{
        construct( u, g );
}

UserItem::UserItem( QListView *parent, User *u, QString g )
        : RosterMenuItem( parent, u->getRealName() )
{
        construct( u, g );
}

void UserItem::construct( User *u, QString g )
{
	whoAmI = u;

        if( u->getHighestPresence() != 0 )
        {
        	// Add in all the presences known of
        	int i;
                for (i=0; i<u->numberResources(); i++)
                	presenceChanged( u, u->getPresence(i) );
	}
        else

         	setPixmap( 0, KGlobal::iconLoader()->loadIcon("user_offline", KIcon::Small ) );

        connect( u, SIGNAL(informationChanged(User *)), this, SLOT(informationChanged(User *)) );
        connect( u, SIGNAL(presenceChanged(User *, UserPresence *)), this, SLOT(presenceChanged(User *, UserPresence *)) );

       	_popup = new QPopupMenu( 0, "rosterpopup" );
        if (!whoAmI->getNode().isEmpty())
        {
                _popup->insertItem( "Send Message", this, SLOT(startChat()) );
	        _popup->insertItem( "Show Information Dialog", this, SLOT(showUserInfo()) );
	        _popup->insertSeparator();
                if ( !g.isEmpty() )
	                _popup->insertItem( "Remove from group", this, SLOT(removeFromGroup()) );
                _popup->insertItem( "Remove from roster", this, SLOT(removeFromRoster()) );
        }
        else
                _popup->insertItem( "Remove Transport", this, SLOT(removeFromRoster()) );


        _group = g;
}

QString UserItem::getJID()
{
	return whoAmI->getJID();
}

void UserItem::informationChanged( User * )
{
 	setText( 0, whoAmI->getRealName() );
}

void UserItem::presenceChanged( User *u, UserPresence *p )
{
        setPixmap( 0, u->getHighestPresence()->getIcon() );

        if (!whoAmI->getNode().isEmpty())
        {
                // Add or update the resource in the menu
                if (!presenceMap.contains(p->resourceName()))
                {
                        // Add this resource
                        ResourceItem *newItem = new ResourceItem( this, p );
                        presenceMap.insert( p->resourceName(), newItem );

                        connect( p, SIGNAL(presenceDeleted(User *, UserPresence *)), this, SLOT(presenceDeleted(User *, UserPresence *)) );
                }

                ResourceItem *presenceItem = presenceMap[ p->resourceName() ];
                presenceItem->setPixmap( 0, p->getIcon() );
        }
}

void UserItem::presenceDeleted( User *, UserPresence *p )
{
        if (!whoAmI->getNode().isEmpty())
        {
                if (presenceMap.contains(p->resourceName()))
                {
                        ResourceItem *ri = presenceMap[ p->resourceName() ];
                        presenceMap.remove(p->resourceName());

                        delete ri;
                }
        }
}

void UserItem::showUserInfo()
{
	whoAmI->show();
}

void UserItem::startChat()
{
        jabber->messageBin()->startChat( getJID() )->show();
}

void UserItem::dblClick()
{
        if (!whoAmI->getNode().isEmpty())
        {
	        startChat();
        }
}

void UserItem::rightClick( const QPoint &p )
{
 	_popup->exec( p, 1 );
}

void UserItem::removeFromGroup()
{
        User *u = whoAmI;
        u->removeGroup( _group );
        u->commitGroups();
}

void UserItem::removeFromRoster()
{
        int i = KMessageBox::warningYesNo( 0, "Do you want to remove this user from your roster?" );

        if ( i == KMessageBox::Yes )
                whoAmI->removeUser();
}


/***********************************************************************
************************ ResourceItem **********************************
***********************************************************************/

ResourceItem::ResourceItem( UserItem *parent, UserPresence *presence )
	: RosterMenuItem( parent, presence->resourceName() )
{
	_presence = presence;

       	_popup = new QPopupMenu( 0, "rosterpopup" );
	_popup->insertItem( "Send Message", this, SLOT(startChat()) );
	_popup->insertItem( "Show Information Dialog", this, SLOT(showUserInfo()) );
}

ResourceItem::~ResourceItem()
{
	delete _popup;
}

void ResourceItem::dblClick()
{
	startChat();
}

void ResourceItem::rightClick( const QPoint &p )
{
 	_popup->exec( p, 1 );
}

void ResourceItem::startChat()
{
 	jabber->messageBin()->startChat( _presence->getUser()->getJID() + _presence->resourceName() )->show();
}

void ResourceItem::showUserInfo()
{
	_presence->getUser()->show();
}

