
#ifndef _PREFS_H_
#define _PREFS_H_

#include <qobject.h>
#include <qtimer.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qvbox.h>

#include <kdialogbase.h>

#include <xmlnode.h>

class InfoQuery;

/**
 * The preferences database is the container to the jabber namespace for storing client data on the server.  You can
 * change any data you want at any time, the class will automatically send the updates to the server after a short
 * time interval (this is so that if a dialog updates 12 data items the database is not uploaded 12 times).
 *
 *  Also containes a method that will show the current preferences dialog
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 * @short The preferences database
 */
class PrefsDB
        : public QObject
{
Q_OBJECT
public:
        PrefsDB( QObject *parent, const char *name=0 );
        ~PrefsDB();

        /**
	 * Sets the key value pair in the database.
	 */
        void setValue( const QString &key, const QString &value );

	/**
	 * Retrieves the value for the specified key from the database, the defaultvalue will
	 * be returned if the key is not found
	 */
        QString getValue( const QString &key, const QString &defaultValue = "" );

	/**
	 * Shows the preferences dialog, the page parameter can optionally be set to the name of the page
	 * to show (or else it will just show the first one
	 */
        void showPrefsDialog( QString page );

public slots:
        void write();
        void read();

signals:
        void valueChanged( const QString &key, const QString &value );
        void writeCompleted();
        void readCompleted();

private slots:
        void readResults( InfoQuery *, InfoQuery * );
        void writeResults( InfoQuery *, InfoQuery * );

private:
        QTimer *_syncTimer;
        XMLNode *_prefs;

};

/**
 * Preferences options for the roster.  This class is really of little interest unless you
 * are trying to add an option.
 *
 * @author Seth Hartbecke (gandalf@worf.netins.net)
 * @short Roster preferences page
 * @see PrefsDB
 */
class RosterTab
        : public QWidget
{
Q_OBJECT
public:
        RosterTab( QWidget *parent, const char *name = 0 );

	/**
	 * This method will cause the object to save all the current settings into the PrefsDB
	 */
        void save();
private:
        QGridLayout *_layout;

        QCheckBox *_hideOffline;
};

/**
 * Preferences options for the chat dialogs.  This class is really of little interest unless you
 * are trying to add an option.
 *
 * @author Seth Hartbecke (gandalf@worf.netins.net)
 * @short chat options page
 * @see PrefsDB
 */
class ChatDialogTab
        : public QWidget
{
Q_OBJECT
public:
        ChatDialogTab( QWidget *parent, const char *name = 0 );

	/**
	 * This method will cause the object to save all the current settings into the PrefsDB
	 */
        void save();
private:
        QGridLayout *_layout;

        QCheckBox *_smoothScroll;
        QCheckBox *_showTimestamp;
        QCheckBox *_enterSends;
};


#endif
