#include <prefs.h>

#include <infoquery.h>
#include <jabbercore.h>

PrefsDB::PrefsDB( QObject *parent, const char *name )
        : QObject( parent, name )
{
        _prefs = new XMLNode("iq");
        _syncTimer = new QTimer( this, "timer" );
        connect( _syncTimer, SIGNAL(timeout()), this, SLOT(write()) );
}

PrefsDB::~PrefsDB()
{
        delete _prefs;
}

void PrefsDB::setValue( const QString &key, const QString &value )
{
        _prefs->getChildNode( "query" )->getChildNode( "konverse" )->getChildNode( key )->setValue( value );
        emit( valueChanged( key, value ) );

        _syncTimer->start( 500 );
}

QString PrefsDB::getValue( const QString &key, const QString &defaultValue )
{
        if ( _prefs->getChildNode( "query" )->getChildNode( "konverse" )->getChildNode( key, false ) )
                return _prefs->getChildNode( "query" )->getChildNode( "konverse" )->getChildNode( key )->getValue();
        else
                return defaultValue;
}

void PrefsDB::write()
{
        _syncTimer->stop();

        /* I know, never call directly.  But I wrote it, so I can cheat */
        InfoQuery *writeRequest = new InfoQuery( jabber->queryManager(), _prefs );
        writeRequest->setType( "set" );
        writeRequest->setID( "" );      /* Get a new id */
        writeRequest->getChildNode( "query" )->getChildNode( "konverse" )->setAttribute( "xmlns", "konverse:prefs" );

        connect( writeRequest, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(writeResults(InfoQuery *, InfoQuery *)) );

        writeRequest->send();
}

void PrefsDB::read()
{
        InfoQuery *readRequest = jabber->queryManager()->createQuery();
        readRequest->setNameSpace( "jabber:iq:private" );
        readRequest->setType( "get" );
        readRequest->getChildNode( "query" )->getChildNode( "konverse" )->setAttribute( "xmlns", "konverse:prefs" );

        connect( readRequest, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(readResults(InfoQuery *, InfoQuery *)) );

        readRequest->send();
}

void PrefsDB::writeResults( InfoQuery *, InfoQuery * )
{
        emit( writeCompleted() );

}

void PrefsDB::readResults( InfoQuery *, InfoQuery *responce )
{
        delete _prefs;

        _prefs = new XMLNode( *responce );

        emit( readCompleted() );
}

void PrefsDB::showPrefsDialog( QString page )
{
        KDialogBase *kd = new KDialogBase(KDialogBase::IconList,
                                    i18n("Configure Konverse"),
                                    KDialogBase::Ok | KDialogBase::Cancel |
                                    KDialogBase::Help ,
                                    KDialogBase::Ok, 0, "tabdialog");

        // Roster options
        QVBox *_page=kd->addVBoxPage(i18n("Roster"), QString::null,
                        BarIcon("rightjust", KIcon::SizeMedium) );

        RosterTab *rosterTab = new RosterTab( _page, "rotseroptions" );

        // Chat Options
        _page=kd->addVBoxPage(i18n("Chat"), QString::null,
                        BarIcon("rightjust", KIcon::SizeMedium) );

        ChatDialogTab *chatTab = new ChatDialogTab( _page, "chatoptions" );

        if ( page == "chat" )
                kd->showPage( 1 );

         kd->resize (200,300);

        if ( kd->exec() )
        {
                /* save settings here */
                rosterTab->save();
                chatTab->save();
        }
}

/****************************************************************************
                        RosterTab
****************************************************************************/
RosterTab::RosterTab( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
        _layout = new QGridLayout( this, 2, 1 );
        _layout->setRowStretch( 1, 10 );

        _hideOffline = new QCheckBox( "&Hide offline users", this, "hideoffline" );
        _layout->addWidget( _hideOffline, 0, 0 );
        if ( jabber->prefs()->getValue( "roster:hideoffline", "false" ) == "true" )
                _hideOffline->setChecked( true );
        else
                _hideOffline->setChecked( false );

        _layout->activate();
}

void RosterTab::save()
{
        if ( _hideOffline->isChecked() )
                jabber->prefs()->setValue( "roster:hideoffline", "true" );
        else
                jabber->prefs()->setValue( "roster:hideoffline", "false" );
}

/****************************************************************************
                        ChatDialogTab
****************************************************************************/
ChatDialogTab::ChatDialogTab( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
        _layout = new QGridLayout( this, 4, 1 );
        _layout->setRowStretch( 3, 10 );

        _smoothScroll = new QCheckBox( "&Enable smooth scroll", this, "smoothscroll" );
        _layout->addWidget( _smoothScroll, 0, 0 );
        if ( jabber->prefs()->getValue( "chat:smoothscroll", "true" ) == "true" )
                _smoothScroll->setChecked( true );
        else
                _smoothScroll->setChecked( false );

        _showTimestamp = new QCheckBox( "Show &Timestamps", this, "showtimestamp" );
        _layout->addWidget( _showTimestamp, 1, 0 );
        if ( jabber->prefs()->getValue( "chat:showtimestamp", "true" ) == "true" )
                _showTimestamp->setChecked( true );
        else
                _showTimestamp->setChecked( false );

        _enterSends = new QCheckBox( "Enter &Sends", this, "showtimestamp" );
        _layout->addWidget( _enterSends, 2, 0 );
        if ( jabber->prefs()->getValue( "chat:entersends", "true" ) == "true" )
                _enterSends->setChecked( true );
        else
                _enterSends->setChecked( false );

        _layout->activate();
}

void ChatDialogTab::save()
{
        if ( _smoothScroll->isChecked() )
                jabber->prefs()->setValue( "chat:smoothscroll", "true" );
        else
                jabber->prefs()->setValue( "chat:smoothscroll", "false" );

        if ( _showTimestamp->isChecked() )
                jabber->prefs()->setValue( "chat:showtimestamp", "true" );
        else
                jabber->prefs()->setValue( "chat:showtimestamp", "false" );

        if ( _enterSends->isChecked() )
                jabber->prefs()->setValue( "chat:entersends", "true" );
        else
                jabber->prefs()->setValue( "chat:entersends", "false" );
}

