/***************************************************************************
                          jabbercore.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DLG_GRP_CHAT_H_
#define _DLG_GRP_CHAT_H_

#include <time.h>

#include <qsplitter.h>
#include <qlistview.h>
#include <qlayout.h>
#include <qdialog.h>
#include <qcombobox.h>
#include <qbutton.h>
#include <qdatetime.h>

#include <messagereciever.h>
#include <wrapedit.h>
#include <user.h>
#include <jabberid.h>
#include <xmlnode.h>
#include <jabbercore.h>

/**
 * This is the group chat dialog.
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 * @short Groupchat dialog
 */
class DlgGrpChat
        : public QWidget
        , MessageReciever
{
Q_OBJECT
public:
        DlgGrpChat( QString room, QString server, QString nick );
        ~DlgGrpChat();

protected:
        void newPacket( XMLNode * );
        void closeEvent( QCloseEvent * ) { delete this; };

private slots:
        void presenceChanged(User *u, UserPresence *p);
        void sendMessage();
        void memberDblClicked( QListViewItem * );
        void changedStatus();
        void userDeleted();

protected:
        void resizeEvent( QResizeEvent * );

private:
        QGridLayout *_layout;
        QSplitter *_main, *_top;
        ConversationView *_conversation;
        WrapEdit *_input;
        QListView *_members;

        QString _room, _server, _nick;

        User *_u;
};

class DlgJoinGrpChat
        : public QDialog
{
Q_OBJECT
public:
        DlgJoinGrpChat( QWidget *parent, const char *name=0 );
        ~DlgJoinGrpChat() { _current = 0; };

        static void showDialog();
protected:
        void closeEvent( QCloseEvent * ) { delete this; };

private slots:
        void joinClicked();

private:
        static DlgJoinGrpChat *_current;

        QGridLayout *_layout;
        QComboBox *_system;
        QPushButton *_join, *_cancel;
        QLineEdit *_nick, *_room;
        QLabel *_lblNick, *_lblRoom, *_lblSystem;
};
#endif
