/*******************************************************************************
**                               wizard.cpp
**                                part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// KDE includes
#include <klocale.h>
#include <kapplication.h>

// My includes
#include "konservedebug.h"
#include "wizard.h"

/////////////////////////////////////////////////////////////////////////////
///////	             class Wizard                                     ///////
/////////////////////////////////////////////////////////////////////////////
Wizard::Wizard()
    : KWizard( 0L, "KonserveWizard" )
{
    TRACE();
    setupPages();
    connect(
        this, SIGNAL( selected( const QString& ) ),
        this, SLOT( slotSelected( const QString& ) )
        );
    connect(
        cancelButton(), SIGNAL( pressed() ),
        this,           SLOT( slotReset() )
        );
    connect(
        helpButton(), SIGNAL( pressed() ),
        this,         SLOT( slotHelp() )
        );
    setFixedSize( QSize( 536, 300 ) );
}

Wizard::~Wizard()
{
    TRACE();
    // NOOP
}

void Wizard::slotSelected( const QString& title )
{
    TRACE();
    if ( title == "Step: 5" )
    {
        mpFinalWidget->identifierLable->setText(
            mpIdentifierWidget->identifierLineEdit->text()
            );
        mpFinalWidget->sourceUrlLabel->setText(
            mpSourceUrlWidget->sourceURLRequester->lineEdit()->text()
            );
        mpFinalWidget->backupUrlLabel->setText(
            mpBackupUrlWidget->backupURLRequester->lineEdit()->text()
            );
        mpFinalWidget->intervalLabel->setText(
            QString().setNum( mpTimeIntervalWidget->intervalKIntNumInput->value())
            + " " +
            mpTimeIntervalWidget->measureKComboBox->currentText()
            );
        if ( mpTimeIntervalWidget->activCheckBox->isChecked() )
            mpFinalWidget->activBackupResultLabel->setText( "yes" );
        else
            mpFinalWidget->activBackupResultLabel->setText( "no" );
    }
}

void Wizard::slotSetSource( QString source )
{
    TRACE();
    mpSourceUrlWidget->sourceURLRequester->setURL( source );
}

void Wizard::setupPages()
{
    TRACE();
    mpIdentifierWidget = new IdentifierWidget;
    addPage( mpIdentifierWidget,
             i18n( "Step: 1" ) );

    mpSourceUrlWidget = new SourceUrlWidget;
    addPage( mpSourceUrlWidget,
             i18n( "Step: 2" ) );

    mpSourceUrlWidget->sourceURLRequester->setMode(
        KFile::File | KFile::Directory |
        KFile::ExistingOnly
        );

    mpBackupUrlWidget = new BackupUrlWidget;
    addPage( mpBackupUrlWidget,
             i18n( "Step: 3" ) );

    mpBackupUrlWidget->backupURLRequester->setMode(
        KFile::File | KFile::Directory
        );

    mpTimeIntervalWidget = new TimeIntervalWidget;
    addPage( mpTimeIntervalWidget,
             i18n( "Step: 4" ) );

    mpFinalWidget = new FinalWidget;
    addPage( mpFinalWidget,
             i18n( "Step: 5" ) );

    setFinishEnabled( mpFinalWidget, true );
}

void Wizard::slotHelp()
{
    TRACE();
    kapp->invokeHelp( "", "konserve" );
}

void Wizard::accept()
{
    TRACE();
    ProfileMngrInterface::insert(
        BackupProfile::newBackupProfile(
            mpSourceUrlWidget->sourceURLRequester->url(),
            mpBackupUrlWidget->backupURLRequester->url(),
            mpIdentifierWidget->identifierLineEdit->text(),
            mpTimeIntervalWidget->intervalKIntNumInput->value(),
            mpTimeIntervalWidget->measureKComboBox->currentText(),
            mpTimeIntervalWidget->activCheckBox->isChecked(),
            *new QDateTime()
            )
        );
    hide();
    slotReset();
}

void Wizard::slotReset()
{
    TRACE();
    mpIdentifierWidget->identifierLineEdit->setText( "" );
    mpSourceUrlWidget->sourceURLRequester->setURL( "" );
    mpBackupUrlWidget->backupURLRequester->setURL( "" );
    mpTimeIntervalWidget->intervalKIntNumInput->setValue( 1 );
    mpTimeIntervalWidget->measureKComboBox->setCurrentItem( "day" );

    showPage( mpIdentifierWidget );
}

#include "wizard.moc"
