/***************************************************************************
 *   Copyright (C) 2007-2010 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATORURLLIST_H_
#define _KOMPARATORURLLIST_H_

#include <KPushButton>
#include <KUrl>
#include <QEvent>

class QListWidget;
class KPopupFrame;

class KomparatorUrlList : public KPushButton
{
	Q_OBJECT

	public:
		KomparatorUrlList( QWidget *parent, const char *name = NULL );
		KomparatorUrlList( const QString &text, QWidget *parent, const char *name = NULL );
		KomparatorUrlList( const KIcon &icon, const QString &text, QWidget *parent, const char *name = NULL );
		KomparatorUrlList( const KGuiItem &item, QWidget *parent, const char *name = NULL );
		~KomparatorUrlList();

		KUrl::List getUrlList();
		int getUrlNumber();

		void addUrl( const KUrl &url );
		void clear();

		void setReadOnly( bool ro );

	protected slots:
		void slotClicked();
		void slotAdd();
		void slotRemove();
		void slotClear();

	protected:
		bool eventFilter( QObject*, QEvent *e );

	private:
		QWidget *m_main_box;
		KPushButton *m_add_button;
		KPushButton *m_remove_button;
		KPushButton *m_clear_button;

		KPopupFrame *m_popup_frame;

		QListWidget *m_list_view;

		void init();
};

#endif
