/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QComboBox>

#include "accounttypefield.h"

using namespace Form;

AccountTypeField::AccountTypeField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mComboBox = new QComboBox( this );
  mComboBox->addItem( tr( "User Account" ) );
  mComboBox->addItem( tr( "Internal User Account" ) );
  mComboBox->addItem( tr( "Group Account" ) );
  mComboBox->addItem( tr( "Resource Account" ) );

  fieldLayout()->addWidget( mComboBox, 0, 0 );
}

void AccountTypeField::loadEntry( const Entry &entry )
{
  if ( entry.value( "accttype" ) == "user" )
    mComboBox->setCurrentIndex( 0 );
  else if ( entry.value( "accttype" ) == "internalUser" )
    mComboBox->setCurrentIndex( 1 );
  else if ( entry.value( "accttype" ) == "group" )
    mComboBox->setCurrentIndex( 2 );
  else if ( entry.value( "accttype" ) == "resource" )
    mComboBox->setCurrentIndex( 3 );
}

void AccountTypeField::saveEntry( Entry &entry ) const
{
  switch ( mComboBox->currentIndex() ) {
    case 0:
      entry.setValue( "accttype", "user" );
      break;
    case 1:
      entry.setValue( "accttype", "internalUser" );
      break;
    case 2:
      entry.setValue( "accttype", "group" );
      break;
    case 3:
      entry.setValue( "accttype", "resource" );
      break;
  }
}

bool AccountTypeField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void AccountTypeField::setEditable( bool editable )
{
  mComboBox->setEnabled( editable );
}
