/* -*- Mode: C++ -*-

  $Id: KDChartRingPainter.h,v 1.3.2.1 2001/12/08 12:15:41 khz Exp $

  KDChart - a multi-platform charting engine

  Copyright (C) 2001 by Klarlvdalens Datakonsult AB
*/

#ifndef __KDCHARTRINGPAINTER_H__
#define __KDCHARTRINGPAINTER_H__

#include <KDChartPainter.h>
#include <KDChartTable.h>

class KDChartParams;

class KDChartRingPainter : public KDChartPainter
{
    friend class KDChartPainter;
protected:
    KDChartRingPainter( KDChartParams* params );
    virtual ~KDChartRingPainter();

    virtual void paintData( QPainter* painter, KDChartTableData* data,
                            bool paint2nd,
                            KDChartDataRegionList* regions = 0 );
    void drawOneSegment( QPainter* painter,
                         uint outerRadius, uint innerRadius,
                         uint startAngle, uint endAngle,
                         uint dataset, uint value, uint chart,
                         bool explode,
                         KDChartDataRegionList* regions = 0 );

    virtual QString fallbackLegendText( uint dataset ) const;
    virtual uint numLegendFallbackTexts( KDChartTableData* data ) const;

    QRect _position;
    uint _size;
    uint _numValues; // PENDING(kalle) Move to base class
}
;

#endif
