/***************************************************************************
                          knutdock.cpp  -  description
                             -------------------
    begin                : t z? 23 2003
    copyright            : (C) 2003 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutdock.h"
#include "knutnet.h"

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kapp.h>
#include <kaboutapplication.h>
#include <kmessagebox.h>

#include <qpainter.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <qstring.h>


#include <math.h>
#include <stdio.h>
#include <stdlib.h>

//#include <iostream>

KNutDock::KNutDock(struct upsInfo* tActiveUpsInfo, SettingDataDef* tSettingData, KNutUpsData* tUpsRecords){
  QString valueName;
  bool okFloat;

  settingData = tSettingData;
  upsRecords = tUpsRecords;
  activeUpsInfo = tActiveUpsInfo;

  oldNetError = 0;

  typeOfIcon = settingData->typeOfKIcon;

  if (!settingData->customKIconColor) myBGColor = Qt::white;
  else myBGColor = settingData->kIconBackgroundColor;

  toolTipFlags=settingData->toolTipFlags;

    
//  dataOk = false; // dataOk spojeni nebylo navazano
//  nemazat pro informaci

  batteryChargeValue = 0;
  runtimeValue = 0;
  upsLoadValue = 0;
  statusValue = 0;
      
  KIconLoader *loader = KGlobal::iconLoader();
  mainPix = loader->loadIcon ("knutclient",KIcon::Small,16);
  errorPix = loader->loadIcon ("knutclienterr",KIcon::Small,16);

  initImage();

  createMainMenu();

  statusLayer = 0L;
  runtimeLayer = 0L;
  batteryLayer = 0L;
  upsLayer = 0L;
  
  
  if (typeOfIcon == knc::generalKI) {
    statusLayer = new QPixmap(24,24);
    runtimeLayer = new QPixmap(24,24);
    }
  else {
    batteryLayer = new QPixmap(24,24);
    upsLayer = new QPixmap(24,24);
    }
    
  loadLayer = new QPixmap(24,24);
  chargeLayer = new QPixmap(24,24);
  mainLayer = new QPixmap(24,24);

  
  if (activeUpsInfo->upsNet != 0) {
    QString nutStringVar;

    if (!activeUpsInfo->upsNet->existName(activeUpsInfo->runtimeVar)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->runtimeVar);
      if (nutStringVar.isEmpty()) runtimeValue = knc::numberVarError;
      else {
        runtimeValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) runtimeValue=knc::numberVarError;
        }
      }
    else runtimeValue=knc::numberVarError;

    if (activeUpsInfo->nutVariables == 1) valueName = "BATTPCT";
    else valueName = "battery.charge";
    if (!activeUpsInfo->upsNet->existName(valueName)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(valueName);
      if (nutStringVar.isEmpty()) batteryChargeValue=knc::numberVarError;
      else {
        batteryChargeValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) batteryChargeValue=knc::numberVarError;
        }
      }
    else batteryChargeValue=knc::numberVarError;
    

    if (activeUpsInfo->nutVariables == 1) valueName = "LOADPCT";
    else valueName = "ups.load";
    if (!activeUpsInfo->upsNet->existName(valueName)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(valueName);
      if (nutStringVar.isEmpty()) upsLoadValue=knc::numberVarError;
      else {
        upsLoadValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) upsLoadValue=knc::numberVarError;
        }
      }
    else upsLoadValue=knc::numberVarError;
    
    statusValue = (activeUpsInfo->upsNet->readStatus());
    statusBatValue =  statusValue & KNutNet::OB;  

    statusWarningValue = statusValue & (KNutNet::CAL | KNutNet::TRIM | KNutNet::BOOST
                         | KNutNet::OVER  | KNutNet::RB);
    }

  mainLayer->fill(myBGColor);
  if (typeOfIcon == knc::generalKI) {
    
    paintStatus (statusValue);
    paintLoad(upsLoadValue);
    paintRuntime (runtimeValue, statusValue);
    paintCharge (runtimeValue);

    bitBlt (mainLayer,0,0,statusLayer,0,0,24,24,AndROP);
    bitBlt (mainLayer,0,0,loadLayer,0,0,24,24,AndROP);
    bitBlt (mainLayer,0,0,runtimeLayer,0,0,24,24,AndROP);
    bitBlt (mainLayer,0,0,chargeLayer,0,0,24,24,AndROP);
    }
  else {
    // madefinuji pozadi pro baterii a UPS
    paintBattery();
    paintUps();
// pridata rozdeleni pro OL a OB

    if (statusValue & KNutNet::OL) bitBlt (mainLayer,0,0,loadLayer,0,0,24,24,AndROP);
    else bitBlt (mainLayer,0,0,chargeLayer,0,0,24,24,AndROP);
    if (!statusWarningValue) paintOKPoint();
    else paintErrorPoint();
    }
    
  
  toolTip(runtimeValue, statusValue, batteryChargeValue, upsLoadValue);
  repaint();

  }


KNutDock::~KNutDock(){

  if (statusLayer) delete statusLayer;
  if (runtimeLayer) delete runtimeLayer;
  if (upsLayer) delete upsLayer;
  if (batteryLayer) delete batteryLayer;

  delete loadLayer;
  delete chargeLayer;
  delete mainLayer;

  delete upsServerMenu;
  delete menu;
  }

void KNutDock::changeUps (void) {

  upsServerMenu->clear();
  createUpsMenu();
  }


void KNutDock::changeToolTip(void){

  toolTipFlags=settingData->toolTipFlags;
  toolTip(runtimeValue, statusValue, batteryChargeValue, upsLoadValue);
  }

  
void KNutDock::changeKIBColor(void) {
  // custom == true vlastni barva;

  if (!settingData->customKIconColor) myBGColor = Qt::white;
  else myBGColor = settingData->kIconBackgroundColor;
    
  repaintDock(oldNetError,true);
  }
  
void KNutDock::changeKIcon (void) {

  typeOfIcon = settingData->typeOfKIcon;
  if ( typeOfIcon == knc::generalKI) {
    if (!statusLayer) {
      statusLayer = new QPixmap(24,24);
      }
    if (!runtimeLayer) {
      runtimeLayer = new QPixmap(24,24);
      }
    paintStatus(statusValue);
    paintRuntime(runtimeValue, statusValue);
    delete upsLayer;
    upsLayer = 0L;
    delete batteryLayer;
    batteryLayer=0L;
    }
  else {
    if (!batteryLayer) {
      batteryLayer = new QPixmap(24,24);
      paintBattery();
      }
    if (!upsLayer) {
      upsLayer = new QPixmap(24,24);
      paintUps();
      }
    delete statusLayer;
    statusLayer = 0L;
    delete runtimeLayer;
    runtimeLayer=0L;
    }        
  paintLoad(upsLoadValue);
  paintCharge(batteryChargeValue);

  statusWarningValue = statusValue & (KNutNet::CAL | KNutNet::TRIM | KNutNet::BOOST
                     | KNutNet::OVER | KNutNet::RB);
  repaintDock(oldNetError,true);
  }  

void KNutDock::initImage(void) {
  setPixmap(mainPix);
  dataOk = connected;
  dataOkOld = dataOk;
  }

void KNutDock::setNewUPS(void) {
  upsServerMenu->clear();
  createUpsMenu();
  }


/********************* Protected ****************************/

void KNutDock::toolTip (int runtime, int status, int batteryCharge, int upsLoad ) {

  QString text;
  QString manufacturer = "";
  QString upsModel = "";
  QString serial = "";
  QString firmware = "";
  int myNetErr = 0;

  int min = abs(runtime/60);
  int sec = runtime - (min*60);

  if (activeUpsInfo->upsNet != 0) {
    myNetErr= activeUpsInfo->upsNet->getError();
    switch (activeUpsInfo->nutVariables) {
      case 1:
        manufacturer = activeUpsInfo->upsNet->readStringVar("MFR");
        upsModel = activeUpsInfo->upsNet->readStringVar("MODEL");
        serial = activeUpsInfo->upsNet->readStringVar("SERIAL");
        firmware = activeUpsInfo->upsNet->readStringVar("FIRMREV");
      break;
      case 2:
        manufacturer = activeUpsInfo->upsNet->readStringVar("ups.mfr");
        upsModel = activeUpsInfo->upsNet->readStringVar("ups.model");
        serial = activeUpsInfo->upsNet->readStringVar("ups.serial");
        firmware = activeUpsInfo->upsNet->readStringVar("ups.firmware");
      break;
      }
    }
    
  text = i18n("Name")+" : "+activeUpsInfo->record.name + "\n"
  +i18n("UPS name")+" : "+activeUpsInfo->record.upsName + "\n"
  +i18n("UPS address")+" : "+activeUpsInfo->record.upsAddress +"\n"
  +i18n("Status : ");

  if (status == -1) {
    text += i18n("Connection doesn't exist.");
    }
  else {
    if (status & KNutNet::OL) {
      text += i18n("UPS On line");
      }
    else {
      if (status & KNutNet::OB) {
        text += i18n("UPS On battery");
        }
      else {
        if (status & KNutNet::OFF) {
          text += i18n("UPS Of line");
          }
        }  
      }
    
    if (status & KNutNet::LB) {
      text += "\n" + i18n("Status : ") + i18n("UPS Battery is low");
      }
    if (status & KNutNet::RB) {
      text += "\n" + i18n("Status : ") + i18n("Replace battery");
      }
    if (status & KNutNet::CAL) {
      text += "\n" + i18n("Status : ") + i18n("UPS is performing calibration");
      }
    if (status & KNutNet::OVER) {
      text += "\n" + i18n("Status : ") + i18n("UPS is Overload");
      }
    if (status & KNutNet::TRIM) {
      text += "\n" + i18n("Status : ") + i18n("UPS is trimming voltage");
      }
    if (status & KNutNet::BOOST) {
      text += "\n" + i18n("Status : ")+ i18n("UPS is boosting voltage");
      }


    }
  if ((status == -1) && (myNetErr != KNutNet::NoError)) {
    text += "\n" + i18n("Error : ")+ KNutVarData::errorToText(myNetErr);
    }
  
  if (toolTipFlags & knc::TTMFR) text += "\n" + i18n("Manufac. : ")+ manufacturer;

  if (toolTipFlags & knc::TTModel) text += "\n" + i18n("Name")+" : "+ upsModel;

  if (toolTipFlags & knc::TTSerial) text += "\n" + i18n("Serial")+" : "+ serial;

  if (toolTipFlags & knc::TTFirm) text += "\n" + i18n("Firmware")+" : "+ firmware;
      
  if (toolTipFlags & knc::TTRun) {
    if (runtime != knc::numberVarError)
      text += "\n" + i18n("Runtime") + i18n(" : %1:%2 min").arg(min).arg(sec);
//  else
//    text += "\n" + i18n("Runtime") +" : ? min";
    }

  if (toolTipFlags & knc::TTCharge) {
    if (batteryCharge != knc::numberVarError)
      text += "\n" + i18n("Battery Charge") + QString(" : %1 %").arg(batteryCharge);
// else
//    text += "\n" + i18n("Battery Charge") + " : ? %";
    }
                
  if (toolTipFlags & knc::TTLoad) {
    if (upsLoad != knc::numberVarError)
      text += "\n" + i18n("UPS Load") + QString(" : %1 %").arg(upsLoad);
//  else
//    text += "\n" + i18n("UPS Load") + " : ? %";
    }

  QToolTip::remove(this);
  QToolTip::add(this,text);
 }


void KNutDock::mousePressEvent(QMouseEvent *e) {

  if( e->button()==LeftButton  ) emit activeMainWindow();
  if( e->button()==RightButton ) menu->popup(e->globalPos());
  }

void KNutDock::createUpsMenu(void) {

  int n = upsRecords->getCount();
  for (int i =0; i < n; i++) {
    if (activeUpsInfo->record.name == upsRecords->getName(i))
      upsServerMenu->insertItem(kapp->miniIcon(),upsRecords->getName(i), this, SLOT(slotUpsName(int)),0,101+i);
    else
      upsServerMenu->insertItem(upsRecords->getName(i), this, SLOT(slotUpsName(int)),0,101+i);
    }
  }
 

void KNutDock::createMainMenu(void) {

  menu = new KPopupMenu;
  upsServerMenu = new KPopupMenu;
  createUpsMenu();
      
  menu->insertTitle (kapp->miniIcon(),"knutclient");
  menu->insertSeparator();
  menu->insertItem("UPS",upsServerMenu);
  menu->insertSeparator();
  menu->insertItem(i18n("&Showing UPS variables and commands"), this, SLOT(slotPrintUPSVars()));
  menu->insertItem(i18n("&Running instant commands"), this, SLOT(slotInstComms()));
  menu->insertItem(i18n("Setting R&W variables"), this, SLOT(slotRWVars()));
  menu->insertSeparator();
  menu->insertItem(SmallIcon("reload"),i18n("Reconnect"), this, SLOT(slotRefreshConnection()));
  menu->insertSeparator();
  menu->insertItem(SmallIcon("configure"),i18n("&Preferences"), this, SLOT(slotPreferences()));
  menu->insertSeparator();
  menu->insertItem(kapp->miniIcon(),i18n("&About KNutClient"), this, SLOT(showMyAbout()));
  menu->insertSeparator();
  menu->insertItem(i18n("&Minimize"), this, SLOT(slotMinimize()));
  menu->insertSeparator();
  menu->insertItem (SmallIcon("exit"),i18n("&Exit"),this ,SLOT(slotExitApplication()));
  }

  
void KNutDock::showMyAbout() {
  KAboutApplication *dialog;

  dialog= new KAboutApplication;
  dialog->exec();
  delete dialog;
}

void KNutDock::slotExitApplication (void) {

  if (settingData->areYouSure) {
    if (KMessageBox::warningYesNo (0,i18n("Are you sure ?")) == 3)
      emit endApplication();
    }
  else emit endApplication();
  }

void KNutDock::slotUpsName(int i) {

  emit UPSChanged(upsRecords->getName(i-101));
  }


void KNutDock::slotMinimize(void) {

  emit minimize ();
  }

void KNutDock::slotPreferences(void) {

  emit preferences();
  }

void KNutDock::slotPrintUPSVars(void) {

  emit printUPSVars();
  }

void KNutDock::slotInstComms(void) {

  emit instComms();
  }

void KNutDock::slotRWVars(void) {

  emit RWVars();
  }

void KNutDock::slotRefreshConnection(void) {

  emit makeRefreshConnection();
  }

  
//------------------------------------------

void KNutDock::paintEvent (QPaintEvent *e) {
  if (dataOk == ok) {
    bitBlt (this,0,0,mainLayer,0,0,24,24,CopyROP,true);
    }
  else KSystemTray::paintEvent(e);
  }

void KNutDock::repaintDock (const int netError, const bool always) {
  QString nutStringVar;
  int myRuntimeValue;
  int myUpsLoadValue;
  int myStatusValue;  
  int myStatusBatValue;
  int myBatteryChargeValue;
  bool repaintNow = false;
  bool okFloat;
  QString valueName;


      
  if (activeUpsInfo->upsNet == 0) return;

  oldNetError =netError;
  if ((activeUpsInfo->upsNet->getState() == KNutNet::Connected) && (!activeUpsInfo->netError))  {
  
    dataOk = ok; // pro paint event udava ze mam pouzit nase ikony


    if (!activeUpsInfo->upsNet->existName(activeUpsInfo->runtimeVar)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->runtimeVar);
      if (nutStringVar.isEmpty()) myRuntimeValue=knc::numberVarError;
      else {
        myRuntimeValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) myRuntimeValue = knc::numberVarError;
        }
      }
    else myRuntimeValue = knc::numberVarError;
    
    switch (typeOfIcon) {
      case knc::generalKI:
//    *********STATUS****************  
      myStatusValue = activeUpsInfo->upsNet->readStatus();
      if (myStatusValue !=statusValue  ) {
        statusValue = myStatusValue;
        paintStatus(statusValue);
        repaintNow = true;
        }
        
//   **********RUNTIME***********
    myStatusBatValue = myStatusValue & KNutNet::OB;
    if ((myRuntimeValue != runtimeValue) || (myStatusBatValue != statusBatValue)) {
      runtimeValue = myRuntimeValue;
      statusBatValue = myStatusBatValue;
      paintRuntime(runtimeValue, statusValue);
      repaintNow = true;
      }
      break;
      
      case knc::pictureKI:
//    *********STATUS****************
      myStatusValue = activeUpsInfo->upsNet->readStatus();
      if (myStatusValue !=statusValue  ) {
        statusValue = myStatusValue;
        statusWarningValue = myStatusValue & (KNutNet::CAL | KNutNet::TRIM | KNutNet::BOOST
                         | KNutNet::OVER | KNutNet::RB);
        repaintNow = true;
        }

//   **********RUNTIME***********
      if (myRuntimeValue != runtimeValue) {
        runtimeValue = myRuntimeValue;
        repaintNow = true;
        }
      break;
      }

    // Other values are for all modes

//  **********UPS LOAD***************
    if (activeUpsInfo->nutVariables == 1) valueName = "LOADPCT";
    else valueName = "ups.load";
    if (!activeUpsInfo->upsNet->existName(valueName)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(valueName);
      if (nutStringVar.isEmpty()) myUpsLoadValue=knc::numberVarError;
      else {
        myUpsLoadValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) myUpsLoadValue=knc::numberVarError;
        }
      }
    else myUpsLoadValue=knc::numberVarError;

    if (myUpsLoadValue != upsLoadValue) {
      upsLoadValue = myUpsLoadValue;
      paintLoad(upsLoadValue);
      repaintNow = true;
      }

//  *********BATTERY CHARGE****************      
    if (activeUpsInfo->nutVariables == 1) valueName="BATTPCT";
    else valueName="battery.charge";
    if (!activeUpsInfo->upsNet->existName(valueName)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(valueName);
      if (nutStringVar.isEmpty()) myBatteryChargeValue=knc::numberVarError;
      else {
        myBatteryChargeValue = (int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) myBatteryChargeValue = knc::numberVarError;
        }
      }
    else myBatteryChargeValue=knc::numberVarError;

    if (myBatteryChargeValue != batteryChargeValue) {
      batteryChargeValue = myBatteryChargeValue;
      paintCharge(batteryChargeValue);
      repaintNow = true;
      }
//  ************* End of values********************

    if (repaintNow || always) {
      mainLayer->fill(myBGColor);
      if (typeOfIcon == knc::generalKI) {
        bitBlt (mainLayer,0,0,runtimeLayer,0,0,24,24,AndROP);
        bitBlt (mainLayer,0,0,loadLayer,0,0,24,24,AndROP);
        bitBlt (mainLayer,0,0,chargeLayer,0,0,24,24,AndROP);
        bitBlt (mainLayer,0,0,statusLayer,0,0,24,24,AndROP);
        }
      else {
        if (statusValue & KNutNet::OL) bitBlt (mainLayer,0,0,loadLayer,0,0,24,24,AndROP);
        else bitBlt (mainLayer,0,0,chargeLayer,0,0,24,24,AndROP);
         if (!statusWarningValue) paintOKPoint();
         else paintErrorPoint();
        }
        
      toolTip(runtimeValue, statusValue, batteryChargeValue, upsLoadValue);
      }
                    
    repaint();
    }
  else {
     if ((activeUpsInfo->upsNet->getState() == KNutNet::Connected) && (activeUpsInfo->netError))
        dataOk = error;
     toolTip(0, -1, 0, 0);
    }
  if (dataOk != ok) {
    if (dataOk != dataOkOld) {
      if (dataOk == connected) setPixmap(mainPix);
      else  setPixmap(errorPix);
      }
    }    
  }
   
void KNutDock::paintCharge (int charge ) {
  QPainter paint;

  chargeLayer->fill(Qt::white);
  paint.begin(chargeLayer);
  if (charge > 199) charge = 199;

  if (typeOfIcon == knc::generalKI) {
    if (charge != knc::numberVarError) {
      if (charge < 40) paint.setPen(Qt::red);
      else paint.setPen(Qt::black);
      paintNumbers(charge,8,2,&paint);
      }
    else {
      paint.setPen(Qt::black);
      paintDash (13,2,&paint);
      paintDash (18,2,&paint);
      }
    }
  else {
    // picture version
    if (charge != knc::numberVarError) {
      if (charge < 40) paint.setPen(Qt::red);
      else paint.setPen(Qt::black);
      paintNumbers(charge,-2,16,&paint);

      if (charge < 40) paint.setPen(Qt::red);
      else {
        if (charge < 50) paint.setPen(Qt::yellow);
        else paint.setPen(Qt::green);
        }
      int delka = abs((16*charge)/100);
      delka += abs((delka-1)/4) -1;
      paint.drawLine (2,7,2+delka,7);
      paint.drawLine (2,8,2+delka,8);
      paint.drawLine (2,9,2+delka,9);
      }
    else {
      paint.setPen(Qt::black);
      paintDash (3,16,&paint);
      paintDash (8,16,&paint);
      }

    }  
  paint.end();
  if (typeOfIcon != knc::generalKI) bitBlt (chargeLayer,0,0,batteryLayer,0,0,24,24,AndROP);
  }


void KNutDock::paintErrorPoint ( void ) {
  QPainter paint;

  paint.begin(mainLayer);

  paint.setPen(QColor(255,0,0));
  paint.drawRect(20,18,3,3);
  paint.setPen(QColor(128,0,0));
  paint.drawLine(20,19,22,19);
  paint.drawLine(21,18,21,20);
  paint.end();
  }


void KNutDock::paintOKPoint ( void ) {
  QPainter paint;

  paint.begin(mainLayer);

  paint.setPen(QColor(0,255,0));
  paint.drawRect(20,18,3,3);
  paint.setPen(QColor(0,128,0));
  paint.drawLine(20,19,22,19);
  paint.drawLine(21,18,21,20);
  paint.end();
  }
  
   
void KNutDock::paintStatus (int status ) {
  QPainter paint;
  int lastPos = 0;
   
  statusLayer->fill(Qt::white);
  paint.begin(statusLayer);

  if (status & KNutNet::OL) {
    paint.setPen(Qt::black);
    paintChar (1,2,'P',&paint);
    }
  else {
    if (status & KNutNet::OB) {
      paint.setPen(Qt::red);
      paintChar (1,2,'B',&paint);
      }
    }

  if (status & KNutNet::LB) {
    paint.setPen(Qt::red);
    paintChar (6,2,'L',&paint);
    }
  if ((lastPos <2) && (status & KNutNet::RB)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'R',&paint);
    lastPos++;
    }
  if ((lastPos <2) && (status & KNutNet::BOOST)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'B',&paint);
    lastPos++;
    }
  if ((lastPos <2) && (status & KNutNet::TRIM)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'T',&paint);
    lastPos++;
    }
  if ((lastPos <2) && (status & KNutNet::CAL)) {
    paint.setPen(Qt::red);
    paintChar (6,2,'C',&paint);
    lastPos++;
    }
  paint.end();
  }
   
void KNutDock::paintRuntime (int runtime, int status ) {
  QPainter paint;
  
  runtimeLayer->fill(Qt::white);
  paint.begin(runtimeLayer);

  if (status & KNutNet::OB)
    paint.setPen(Qt::red);
  else
    paint.setPen(Qt::black);
  if (runtime != knc::numberVarError) {
    
    int min = abs(runtime/60);
    int sec = runtime - (min*60);

    paintNumber(1,11, abs(min/10) ,&paint);
    paintNumber(6,11,min-((abs(min/10))*10) ,&paint);
    paintNumber(13,11, abs(sec/10) ,&paint);
    paintNumber(18,11,sec-((abs(sec/10))*10) ,&paint);
    }
  else {
    paintDash (1,11,&paint);
    paintDash (6,11,&paint);
    paintDash (13,11,&paint);
    paintDash (18,11,&paint);
    }
  paint.drawLine (11,12,11,13);
  paint.drawLine (11,15,11,16);
  paint.end();
  }   

void KNutDock::paintLoad (int load ) {
  QPainter paint;
  int myLoad;

  loadLayer->fill(Qt::white);
  paint.begin(loadLayer);
  if (load == knc::numberVarError) myLoad=0;
  else myLoad = abs(load/10);

  if (typeOfIcon == knc::generalKI) {
    if (load != knc::numberVarError) {
      if (myLoad > 11) myLoad=11;
      if (myLoad < 9) paint.setPen(Qt::green);
      else {
        if (myLoad < 11) paint.setPen(Qt::yellow);
        else paint.setPen(Qt::red);
        }
      paint.setPen(Qt::green.light(60));
      for (int i = 0; i < myLoad; i++) {
      paint.drawLine((i*2)+1,19,(i*2)+1,21);
        }
      paint.setPen(Qt::cyan.light(150));
      for (int i = myLoad; i < 11; i++) {
        paint.drawLine((i*2)+1,19,(i*2)+1,21);
        }
      }  
    }
  else { // picture version
    if (load != knc::numberVarError) {
      if (myLoad > 12) myLoad=12;
      if (myLoad > 10) myLoad++; // preskocime rysku pro 100 %
      if (myLoad < 9) paint.setPen(QColor(0,192,0));
      else {
        if (myLoad < 11) paint.setPen(QColor(255,255,0)); //yellow
        else paint.setPen(QColor(255,0,0));//red
        }
      for (int i = 20; i < 23; i++) paint.drawLine(i,13,i,13-myLoad +1);
    
      if (myLoad < 13) {
        paint.setPen(QColor(168,220,255));
        for (int i = 20; i < 23; i++ ) paint.drawLine(i,1,i,13-myLoad);
        }
      }
    paint.setPen(Qt::black);
    paintNumbers (load, -2, 16, &paint );
    } // end picture version
  paint.end();

  if (typeOfIcon != knc::generalKI) bitBlt (loadLayer,0,0,upsLayer,0,0,24,24,AndROP);
  }

void KNutDock::paintBattery (void) {
  QPainter paint;

  batteryLayer->fill(Qt::white);
  paint.begin(batteryLayer);

  paint.setPen(QColor(128,128,128));//128/128/128
  paint.drawLine(2,5,20,5);

  paint.setPen(QColor(160,160,160));//160/160/160
  paint.drawLine(2,6,20,6);

  paint.setPen(QColor(88,88,88));//88/88/88
  paint.drawLine(2,10,20,10);

  paint.setPen(QColor(48,48,48));//48/48/48
  paint.drawLine(2,11,20,11);

  paint.setPen(Qt::black);
  paint.drawLine(1,4,21,4);
  paint.lineTo(21,12);
  paint.lineTo(1,12);
  paint.lineTo(1,4);
  paint.drawLine(22,6,22,10);
  
  paint.drawLine(6,6,6,10);
  paint.drawLine(11,5,11,11);
  paint.drawLine(16,6,16,10);
        
  paint.drawLine(13,22,17,16);
  paint.drawRect (13,16,2,2);
  paint.drawRect (16,21,2,2);

  paint.end();  
  }

void KNutDock::paintUps (void) {
  QPainter paint;

  upsLayer->fill(Qt::white);
  paint.begin(upsLayer);
  paint.setPen(Qt::black);
  paint.drawLine(4,1,4,13);
  paint.drawLine(5,1,5,13);
  paint.drawLine(6,1,6,13);
  paint.drawLine(7,1,7,13);
  paint.drawLine(8,1,8,13);
  paint.drawLine(9,1,9,13);
  paint.drawLine(10,1,10,13);
  paint.setPen(QColor(0,0,192));// modra
  paint.drawLine(10,1,10,13);
  paint.drawLine(11,1,11,13);
  paint.drawLine(12,1,12,13);
  paint.drawLine(13,1,13,13);

  paint.setPen(Qt::white);
  paint.drawPoint (4,7);
  paint.setPen(QColor(195,195,195));
  paint.drawPoint (4,6);
  paint.drawPoint (4,8);
  paint.setPen(QColor(160,160,160));
  paint.drawPoint (4,5);
  paint.drawPoint (4,9);
  paint.setPen(QColor(128,128,128));
  paint.drawPoint (4,4);
  paint.drawPoint (4,10);
  paint.setPen(QColor(88,88,88));
  paint.drawPoint (4,3);
  paint.drawPoint (4,11);
  paint.setPen(QColor(48,48,48));
  paint.drawLine(7,10,7,12);
  paint.drawLine(6,10,6,12);

  paint.setPen(QColor(0,88,192));
  paint.drawLine (14,6,14,8);
  paint.setPen(QColor(88,168,255));
  paint.drawLine (14,4,14,5);
  paint.drawLine (14,9,14,10);
  paint.setPen(QColor(168,220,255));
  paint.drawPoint (14,3);
  paint.drawPoint (14,11);

  paint.setPen(QColor(0,192,0));
  paint.drawLine (11,3,13,3);
  paint.drawLine (12,2,12,4);
  paint.drawPoint (11,6);
  paint.drawPoint (13,6);
  paint.drawPoint (11,8);
  paint.drawPoint (13,8);
  paint.setPen(QColor(0,255,0));
  paint.drawPoint (12,3);
  paint.setPen(QColor(0,128,0));
  paint.drawPoint (11,10);
  paint.drawPoint (13,10);

  paint.setPen(Qt::black);
  paint.drawLine(19,3,22,3);
  paint.drawLine(19,14,22,14);

  paint.drawLine(13,22,17,16);
  paint.drawRect (13,16,2,2);                      
  paint.drawRect (16,21,2,2);
  paint.end();
  }



void KNutDock::paintNumbers (int numbers, int x, int y, QPainter* p ) {
  bool first = false;

  if (numbers > 199) numbers = 199;

  if (numbers != knc::numberVarError) {

    if (numbers > 99) {
      paintNumber (x,y,1,p);
      numbers -= 100;
      first=true;
      }
    int second = abs (numbers/10);
    int third = numbers - (second * 10);

    if ((second != 0) || (first)) paintNumber (x+5,y,second,p);
    paintNumber (x+10,y,third,p);

    }
  else {
    p->setPen(Qt::black);
    paintDash (x+5,y,p);
    paintDash (x+10,y,p);
    }
  }

                        
void KNutDock::paintDash (int x, int y, QPainter *p) {

  p->drawLine(x,y+3,x+3,y+3);
  }

void KNutDock::paintNumber (int x, int y, int number, QPainter *p) {
  // x and y are left top corner

  if ((number > -1) && (number < 10)) {
   // kreslim
    switch (number) {
      case 0:
      p->drawRect(x,y,4,7);
      break;
      case 1:
        p->drawLine (x+3,y,x+3,y+6);
      break;
      case 2:
        p->drawLine(x,y,x+3,y);
        p->lineTo(x+3,y+3);
        p->lineTo(x,y+3);
        p->lineTo(x,y+6);
        p->lineTo(x+3,y+6);
      break;
      case 3:
        p->drawLine(x,y,x+3,y);
        p->lineTo(x+3,y+6);
        p->lineTo(x,y+6);
        p->drawLine(x,y+3,x+3,y+3);
      break;
      case 4:
        p->drawLine(x,y,x,y+3);
        p->lineTo(x+3,y+3);
        p->drawLine (x+3,y,x+3,y+6);
      break;
      case 5:
        p->drawLine(x+3,y,x,y);
        p->lineTo(x,y+3);
        p->lineTo(x+3,y+3);
        p->lineTo(x+3,y+6);
        p->lineTo(x,y+6);
      break;
      case 6:
        p->drawRect(x,y+3,4,4);
        p->drawLine(x,y+3,x,y);
        p->lineTo(x+3,y);
      break;
      case 7:
        p->drawLine(x,y,x+3,y);
        p->lineTo(x+3,y+6);
      break;
      case 8:
        p->drawRect(x,y,4,7);
        p->drawLine(x,y+3,x+3,y+3);
      break;
      case 9:
        p->drawRect(x,y,4,4);
        p->drawLine(x+3,y+3,x+3,y+6);
        p->lineTo(x,y+6);
      break;
      }
    } 
  }


void KNutDock::paintChar (int x, int y, char LCDChar, QPainter *p) {
  // x and y are left up  corner
  switch (LCDChar) {
    case 'L':
      p->drawLine(x,y,x,y+6);
      p->lineTo(x+3,y+6);
    break;
    case 'O':
      p->drawRect(x,y,4,7);
    break;
    case 'B':
      p->drawLine(x,y,x,y+6);
      p->lineTo(x+2,y+6);
      p->drawLine(x,y,x+2,y);
      p->drawLine(x,y+3,x+2,y+3);
      p->drawLine(x+3,y+1,x+3,y+2);
      p->drawLine(x+3,y+4,x+3,y+5);
    break;
    case 'U':
      p->drawLine(x,y,x,y+6);
      p->lineTo(x+3,y+6);
      p->lineTo(x+3,y);
    break;
    case 'C':
      p->drawLine(x+3,y+1,x+3,y);
      p->lineTo(x,y);
      p->lineTo(x,y+6);
      p->lineTo(x+3,y+6);
      p->lineTo(x+3,y+5);
    break;
    case 'R':
      p->drawLine(x,y,x,y+6);
      p->drawLine(x,y,x+2,y);
      p->drawLine(x,y+3,x+2,y+3);
      p->drawLine(x+3,y+1,x+3,y+2);
      p->drawLine(x+3,y+4,x+3,y+6);
    break;
    case 'P':
      p->drawLine(x,y,x,y+6);
      p->drawLine(x,y,x+2,y);
      p->drawLine(x,y+3,x+2,y+3);
      p->drawLine(x+3,y+1,x+3,y+2);
    break;
    case 'T':
      p->drawLine(x+2,y,x+2,y+6);
      p->drawLine(x,y,x+4,y);
    break;
    }
  }


#include "knutdock.moc"
