/***************************************************************************
                          core.h  -  description
                             -------------------
    begin                : Tue Oct 2 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CORE_H
#define CORE_H

#include <qwidget.h>
#include <qtimer.h>
#include "definitions.h"
#include "resource.h"
#include "knightsmap.h"
#include "idmanager.h"
#include "io_base.h"

class list_pgn;
class thinbuttons;
class match;
class match_param;

/**
  *@author Troy Corbin Jr.
  */

typedef KnightsMap<int, match*> MatchMap;
typedef KnightsMap<int, io_base*> IOMap;

class core : public QWidget
{
   Q_OBJECT
  public:
                                core(QWidget *parent=0, const char *name=0, resource *Rsrc=0);
                                ~core();
    QStringList*                notation( void );
    QString                     caption( void );
    bool                        modified( void );
    bool                        paused( void );
    bool                        isOnline( void );
    bool                        flag( const bool );
    char                        onMove( void );
    char                        whiteInput( void );
    char                        blackInput( void );
    char                        inputOnMove( bool reverse=FALSE );
    void                        createNewIO( int type, int ID, int side=BLACK, int str=0 );
    void                        goOffline(void);

  public slots:
    match*                      newMatch( match_param* );
    bool                        clearMatch( int id=Null );
    bool                        clearAll( void );
    void                        setMatch( int );
    void                        command2IO( const Command& );
    void                        command2Match( const Command& );
    void                        resetServer( void );
    void                        matchMenu( int );
    void                        resize( void );
    bool                        save( const int ID, const bool Prompt, const bool SaveAs );
    bool                        load( void );
    bool                        load( const QString& );
    bool                        load( const QString&, const int& );
    void                        slot_setNotation( void );
    void                        slot_setClocks( void );
    void                        slot_setStatusBar( const int&, const QString& );
    void                        print( int ID=Null );
    void                        review( int );
    QString                     clock( const bool );

  signals:
    void                        requestResize( void );
    void                        setStatusBar( const int &ID, const QString& MSG=QString::null );
    void                        setNotation( void );
    void                        setClocks( void );
    void                        initMatch( void );
    void                        serverDestroyed( void );

  protected:
    bool                        findMatch( const int );
    void                        serverSelfDestruct( void );

  protected slots:
		void												thinButtonMenu( int id, int item );

  private:
    IDManager                   myIDManager;
    resource                    *myResource;
    QTimer                      myCoreClock;
    thinbuttons                 *myButtonGroup;
    list_pgn                    *listPGN;
    IOMap                       myIOMap;
    MatchMap                    myMatchMap;
    match                       *currentMatch;
};

#endif
