/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICESTORE_DBUS_H
#define KNETWORKMANAGER_DEVICESTORE_DBUS_H

#include <hal/libhal.h>
#include <NetworkManager/dbus-helpers.h>

class Device;
class DialUp;
class Network;

class DeviceStoreDBus 
{
	public:

	  static void activateDialUp   (DialUp*);
	  static void deactivateDialUp (DialUp*);
	  static void activateDevice   (Device*);
	  static void activateNetwork  (Network*, Device*);

	  static void setHalDeviceInfo (Device*);
	  static void getHalProperty   (const QCString&, const QCString&, QCString&);

	  static void updateActivationStage (const char*, NMActStage);

	  static void removeNetwork         (const char*, const char*);
	  static void updateNetworkStrength (const char*, const char*, int);
	  static void updateNetworkCallback (DBusPendingCall*, void*);
	  static void updateNetwork         (const char*, const char*, const char*, const char * signal_name = 0 );

	  static void removeDevice         (const char*);
	  static void updateDeviceCallback (DBusPendingCall*, void*);
	  static void updateDevice         (const char*, const char* signal_name = 0); 

	  static void clearStore ();

	  static void getDialUpCallback (DBusPendingCall*, void*);
	  static void getDialUp         (void);
	  
	  static void getDevicesCallback (DBusPendingCall*, void*);
	  static void getDevices         (void);
	  
	  static void populateStore      (void);

	  static void push (KNetworkManager*);

	private:

	  static KNetworkManager* _ctx;
};

#endif /* KNETWORKMANAGER_DEVICESTORE_DBUS_H */
