  /*

  knat v 3.4.0

  Copyright (C) 2005 Luigi Genoni
  		     venom@sns.it
  */
  
#include <strings.h>
#include <kmessagebox.h>
#include <kiconloader.h>

#include <kmenubar.h>
#include <kmainwindow.h>
// This is for some "strange compilers" running with "strange" big mass distributions
#include <stdlib.h>

#include "knat.moc"

#include "version.h"

knetfilter::knetfilter( QWidget *, const char *name )
  : KMainWindow( 0, name )
{
  
    interfaceChoice = "eth";
    interfacenrChoice = 0;
    interfacenrChoicedmp = "0";
    masqinterfaceChoice = "eth";
    masqinterfacenrChoice = 0;
    masqinterfacenrChoicedmp = "0";
    shaperinterfaceChoice = "eth";
    shaperinterfacenrChoice = 0;
    shaperinterfacenrChoicedmp = "0";
    shapermonitorinterfaceChoice = "eth";
    shapermonitorinterfacenrChoice = 0;
    shapermonitorinterfacenrChoicedmp = "0";
    chainChoice = "INPUT";
    stateChoice = "nostate";
    policyChoice = "DROP";
    flagChoice = "-v";
    ecnflagChoice = "-v";
    hasEcn = "-v";
    ecnParam = "-v";
    markchainChoice = "INPUT";
    markpolicyChoice = "DROP";
    markflagChoice = "-v";
    markstateChoice = "nostate";
    polchainChoice = "INPUT";
    chainpolicyChoice = "ACCEPT";
    monitor_resolution = 1;
    natchainChoice= "PREROUTING";
    natchainResult="DNAT";
    natpolchainChoice = "PREROUTING";
    natchainpolicyChoice = "ACCEPT";
    natprotocolChoice = "tcp";
    masqprotocolChoice = "all";
    manglechainChoice = "PREROUTING";
    manglepolchainChoice ="PREROUTING";
    manglechainpolicyChoice = "ACCEPT";
    mangleprotocolChoice = "tcp";
    mangleactionChoice = "TOS";
    mangletosChoice = "Normal-Service";
    mangleSyn = "-v";
    mangleecnflagChoice = "-v";
    hasmangleEcn = "-v";
    mangleecnParam = "-v";
    nmapopt = "-sT";
    nmapopt_icmp = "-PB";
    logLevel = "0";
    log1="-v";
    log2="-v";
    log3="-v";
    tcpmssChoice="FORWARD";
    qdisc_exec=0;
    class_exec=0;
    subclass_exec=0;
	
    setupMenuBar();
    setupToolBar();
    setupStatusBar();

    setupknetfilterWidget();

    setupConnect();
    
    // do i need this to be done?
    //startprobeInterface();

    statusbar->message(i18n("Welcome to knetfilter"), 2000);
 

	/* 
	 * Initialize pointers -- this is necassary for
	 * *List == NULL test to work later.
	 */
    markList = NULL;
    polList = NULL;
    natList = NULL;
    natpolList = NULL;
    masqList = NULL;
    mangleList = NULL;
    manglepolList = NULL;
    routeList = NULL;
    dumpList = NULL;
    mapList = NULL;
    masqWin = NULL;
    tcpmssList = NULL;
    shaperList = NULL;
    shapermonList = NULL;
};


knetfilter::~knetfilter() {

  delete file;
  delete tables;
  delete nat_tables;
  delete mangle;
  delete options;
  delete help;
  delete toolbar;

};

// creating menubar
void knetfilter::setupMenuBar() {

  file = 	new QPopupMenu();
  tables = 	new QPopupMenu();
  nat_tables =  new QPopupMenu();
  mangle =      new QPopupMenu();
  options = 	new QPopupMenu();

/*----- REMOVE LATER ----------
  polcheck = 0; 
  rulecheck = 0;
  dumpcheck = 0;
  natcheck = 0;
  natpolcheck = 0;
  masqcheck = 0;
-------------------------------*/

  FILE *tc;
  FILE *tc2;
  FILE *tc3;
  FILE *tc4;
  FILE *tc5;
  FILE *tc6;

  tc = fopen("/sbin/tc", "r");
  tc2 = fopen("/bin/tc", "r");
  tc3 = fopen("/usr/sbin/tc", "r");
  tc4 = fopen("/bin/tc", "r");
  tc5 = fopen("/usr/local/sbin/tc", "r");
  tc6 = fopen("/usr/local/sbin/sbin/tc", "r");
  
  /*
   * Check if we have tc
   */
  if (tc==NULL && tc2==NULL && tc3==NULL && tc4==NULL && tc5==NULL && tc6==NULL)
    {
      system_has_tc = 0;
    }
  else
    {
      system_has_tc = 1;
    }

 
  file->insertItem(i18n("&Save all rules"), 
  				this, SLOT(saveAll()));
  file->insertItem(i18n("&Load all rules"), 
  				this, SLOT(loadAll()));
  file->insertSeparator();
  file->insertItem(i18n("&Exit"), 
  				this, SLOT(slotExit()), CTRL+Key_E);

  tables->insertItem(i18n("Define Tables Chain policy"),
			        this, SLOT(polRules()));
  tables->insertSeparator();
  tables->insertItem(i18n("&Add rule to all"), 
  				this, SLOT(addRule()), CTRL+Key_A);
  tables->insertItem(i18n("&Del rule to all"), 
  				this, SLOT(delRule()), CTRL+Key_D);
  tables->insertSeparator();
  tables->insertItem(i18n("Add rule to tcp"), 
  				this, SLOT(addRule_tcp()));
  tables->insertItem(i18n("Del rule to tcp"), 
  				this, SLOT(delRule_tcp()));
  tables->insertSeparator();
  tables->insertItem(i18n("Add rule to udp"), 
  				this, SLOT(addRule_udp()));
  tables->insertItem(i18n("Del rule to udp"), 
  				this, SLOT(delRule_udp()));
  tables->insertSeparator();
  tables->insertItem(i18n("Add rule to icmp"), 
  				this, SLOT(addRule_icmp()));
  tables->insertItem(i18n("Del rule to icmp"), 
  				this, SLOT(delRule_icmp()));
  tables->insertSeparator();
  tables->insertItem(i18n("M&ark based rules"),
		                this, SLOT(markRules()));
  tables->insertSeparator();
  tables->insertItem(i18n("Flush iptables &rules"), 
		                this, SLOT(stopAll()), CTRL+Key_R);

  
  useMasq = nat_tables->insertItem(i18n("Masquerade"), 
				this, SLOT(masqRules()));
  nat_tables->insertItem(i18n("NAT & Redirections"),
  			        this, SLOT(natRules()));
  nat_tables->insertItem(i18n("Define Nat Chain policy"),
			        this, SLOT(natpolRules()));
  nat_tables->insertItem(i18n("Flush Nat Rules"),
			        this, SLOT(stopNAT()), CTRL+Key_N);
  mangle->insertSeparator();
  mangle->insertItem(i18n("Mangle"),
                		this, SLOT(mangleRules())); 
  mangle->insertItem(i18n("Define Mangle Chain policy"),
                		this, SLOT(manglepolRules())); 
  mangle->insertItem(i18n("Flush Mangle Rules"),
                		this, SLOT(stopMangle()), CTRL+Key_M); 

  options->insertSeparator();
  options->insertItem(i18n("TcpMSS set up"),
		                this, SLOT(tcpmssRules()));
  options->insertSeparator();
  options->insertItem(i18n("List Rules, &NAT, Mangle entries"),
  				this, SLOT(iptablesRules()));
  options->insertItem(i18n("List &Routes, Ipaddrs, Route Cache"),
  				this, SLOT(routeRules()));
  if ( system_has_tc == 1 )
    {
      options->insertSeparator();
      options->insertItem(i18n("Traffic Shaper"),
			            this, SLOT(trafficShaper()));
      options->insertItem(i18n("Traffic Shaper's Rules Monitor"),
			            this, SLOT(trafficShaperMonitor()));
    }
  options->insertSeparator();
  options->insertItem(i18n("TcpDump"),
  				this, SLOT(tcpDump()));
  options->insertItem(i18n("NMap"),
  				this, SLOT(NMap()));
  options->insertSeparator();
  options->insertItem(i18n("Probe interface"),
	  			this, SLOT(startprobeInterface()));
  options->insertSeparator();
  options->insertItem(i18n("&Clear list"), 
  				this, SLOT(clearLog()));
  //  isMasqon = FALSE;

  QString about;
  about.sprintf ("knetfilter %s\n\n"
	  	"original kfirewall has been created by Kim Andre Norheim\n"
		"knetfilter for 2.4.x kernels has been done by Luigi Genoni\n"
		"all addons to the original kfirewall have been done by Luigi Genoni\n"
		"please send feedback to venom@sns.it", KNETFILTER_VERSION);
		
  QPopupMenu *help = helpMenu ( about );

  menubar = new KMenuBar( this, "menubar" );

  menubar->insertItem(i18n("&File"), file);
  menubar->insertItem(i18n("&TablesPolicy"), tables);
  menubar->insertItem(i18n("&NatPolicy"), nat_tables);
  menubar->insertItem(i18n("&ManglePolicy"), mangle);
  menubar->insertItem(i18n("&Options"), options);
  menubar->insertItem(i18n("&Help"), help);

};


// creating toolbar
void knetfilter::setupToolBar() {

  toolbar = new KToolBar( this );

  toolbar->insertButton("knflt_play.png",add,SIGNAL(clicked()),
			this,SLOT(addRule()),TRUE,i18n("Add rule to both tcp & udp")); 
  toolbar->insertButton("knflt_stop.png",del,SIGNAL(clicked()),
			this,SLOT(delRule()),TRUE,i18n("Delete rule to both tcp & udp"));
  toolbar->insertSeparator();
  toolbar->insertButton("knflt_play_tcp.png",add,SIGNAL(clicked()),
			this,SLOT(addRule_tcp()),TRUE,i18n("Add rule to tcp")); 
  toolbar->insertButton("knflt_stop_tcp.png",del,SIGNAL(clicked()),
			this,SLOT(delRule_tcp()),TRUE,i18n("Delete rule to tcp"));
  toolbar->insertSeparator();
  toolbar->insertButton("knflt_play_udp.png",add,SIGNAL(clicked()),
			this,SLOT(addRule_udp()),TRUE,i18n("Add rule to udp")); 
  toolbar->insertButton("knflt_stop_udp.png",del,SIGNAL(clicked()),
			this,SLOT(delRule_udp()),TRUE,i18n("Delete rule to udp"));
  toolbar->insertSeparator();
  toolbar->insertButton("knflt_play_icmp.png",add,SIGNAL(clicked()),
			this,SLOT(addRule_icmp()),TRUE,i18n("Add rule to icmp")); 
  toolbar->insertButton("knflt_stop_icmp.png",del,SIGNAL(clicked()),
			this,SLOT(delRule_icmp()),TRUE,i18n("Delete rule to icmp"));
  toolbar->insertSeparator();
  toolbar->insertButton("knflt_mark.png",add,SIGNAL(clicked()),
			this,SLOT(markRules()),TRUE,i18n("Set Up Mark based rules"));
  toolbar->insertSeparator();
  toolbar->insertButton("knflt_probe.png",add,SIGNAL(clicked()),
			this,SLOT(startprobeInterface()),TRUE,i18n("Probe Network Interface"));
  toolbar->setBarPos( KToolBar::Top );

};


// creating statusbar
void knetfilter::setupStatusBar() {

  statusbar = new KStatusBar( this );

};

// exit
void knetfilter::slotExit() {

  close();
  exit(0);
};
