  /*
  
   knetfilter v 3.0.2

   Copyright (C) 2002 Luigi Genoni
                      venom@sns.it
  */

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"

// execute tc command line

void knetfilter::startshaperRules() {
    QString shapermark, shaperglobalband, shaperrateband, shaperqdischandle, shaperrootclassid, shaperrootclassweight, shaperrootclassprio, shapersubclassid, shapersubclassweight, shapersubclassprio, shaperinterface, shaperrootclassparent;
    
    char shaperinterfaceChoice2[5];
    strcpy (shaperinterfaceChoice2, shaperinterfaceChoice ); 
    shaperinterfaceChoicedmp = strcat ( shaperinterfaceChoice2, shaperinterfacenrChoicedmp); 
    shaperinterface.sprintf(shaperinterfaceChoicedmp); 

    shapermark.sprintf((const char *)(shaperMark->text()));
    shaperglobalband.sprintf((const char *)(shaperglobalBand->text()));
    shaperrateband.sprintf((const char *)(shaperrateBand->text()));
    shaperqdischandle.sprintf((const char *)(shaperqdiscHandle->text()));
    shaperrootclassid.sprintf((const char *)(shaperrootclassId->text()));
    shaperrootclassweight.sprintf((const char *)(shaperrootclassWeight->text()));
    shaperrootclassprio.sprintf((const char *)(shaperrootclassPrio->text()));
    shapersubclassid.sprintf((const char *)(shapersubclassId->text()));
    shapersubclassweight.sprintf((const char *)(shapersubclassWeight->text()));
    shapersubclassprio.sprintf((const char *)(shapersubclassPrio->text()));
    
    addshaperqdisc.clearArguments();
    addshaperrootclass.clearArguments();
    addshapersubclass.clearArguments();
    addshaperfilter.clearArguments();

    if ( qdisc_exec == 0 && class_exec == 0 && subclass_exec == 0)
      {
	QMessageBox::critical(0, "Error",
			      "You have to say which action you want to perform! \n Remember to create qdisc at first, then the root class \n and at the end the sub classes!\n"); 
      }
    else if(shaperglobalband.length()==0)
      {
	QMessageBox::critical(0, "Error",
			      "You have to supply global bandwidht on net device \n e.g. 100Mbit! \n");
      }


    if ( qdisc_exec == 1 )
      {
	if (shaperqdischandle.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the qdisc handle! \n e.g. 1! \n");
	  }
	else
	  {
	    addshaperqdisc << "tc" << "qdisc" << "add" << "dev" << shaperinterface << "root" << "handle" << shaperqdischandle <<  "cbq" << "bandwidth" << shaperglobalband << "avpkt" << "1000"; 
	  }
	bool successqdisc=addshaperqdisc.start(); 
	if (successqdisc) {
	  statusbar->message(i18n("New qdisc created"), 2000);
	  QString msg;
	  msg.sprintf("qdisc created for device %s\n", shaperinterfaceChoicedmp);
	  messageLog->insertItem(msg);
	} else {
	  statusbar->message(i18n("tc died"), 2000);
	  QMessageBox::critical(0, "Error",
				"qdisc has not been created, please check your parameters! \n");
	}
      }

    char *shaperrootclassParent;
    char shaperrootclassParent2[5];
	
    strcpy (shaperrootclassParent2, (const char *)(shaperqdiscHandle->text()) ); 
    shaperrootclassParent = strcat ( shaperrootclassParent2, "0"); 
    shaperrootclassparent.sprintf(shaperrootclassParent); 

    if ( class_exec == 1 )
      {

	if (shaperqdischandle.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the qdisc handle! \n e.g. 1! \n So knetfilter can establish the root class parent. \n");
	  }
	else if (shaperrootclassid.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the root classID! \n e.g. 1:10! \n");
	  }
	else if (shaperrootclassweight.length()==0) 
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the root class data flow weight! :)\n e.g. 1Mbit! \n");
	  }
	else if (shaperrootclassprio.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "you have to supply the root class priority!\n e.g. 8! \n");
	  }
	else
	  {
	    addshaperrootclass << "tc" << "class" << "add" << "dev" << shaperinterface << "parent" << shaperrootclassparent << "classid" << shaperrootclassid << "cbq" << "bandwidth" << shaperglobalband << "rate" << shaperglobalband <<  "allot" << "1514"<< "weight" << shaperrootclassweight << "prio" << shaperrootclassprio << "maxburst" << "20" << "avpkt" << "1000";   
	
		bool successrootclass=addshaperrootclass.start(); 
		if (successrootclass) {
		  statusbar->message(i18n("New root class created"), 2000);
		  QString msg;
		  msg.sprintf("root class created for device %s\n", shaperinterfaceChoicedmp);
		  messageLog->insertItem(msg);
		} else {
		  statusbar->message(i18n("tc died"), 2000);
		  QMessageBox::critical(0, "Error",
					"root class has not been created, please check your parameters! \n");
		}		
	  }
	
      }

    if ( subclass_exec == 1 )
      {
	if(shaperrateband.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the amount on bandwidth on net device \n you want to reser for XX marked packets \n e.g. 600Kbit! \n");
	  }
	else if (shaperqdischandle.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the qdisc handle! \n e.g. 1! \n So knetfilter can establish the filter parent. \n");
	  }
	else if(shapermark.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the mark that the traffic shaper \n should use to count the packet for a reserved rate. \n e.g. 0x03! \n");
	  }
	else if (shaperrootclassid.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the root class ID! \n so knetfilter can establish to which parent the rule \n has to be conencted\n e.g. 1:10! \n");
	  }	
	else if (shapersubclassid.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the subclass ID!\n e.g 1:11! \n");

				  }
	else if (shapersubclassweight.length()==0) 
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the subclass data flow weight! :)\n e.g. 600Kbit! \n");
	  }
	else if (shapersubclassprio.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "you have to supply the sub class priority!\n e.g. 5! \n");
	  }
	else
	  {
	    addshapersubclass << "tc" << "class" << "add" << "dev" << shaperinterface << "parent" << shaperrootclassid << "classid" << shapersubclassid << "cbq" << "bandwidth" << shaperglobalband << "rate" << shaperrateband << "allot" << "1514" << "weight" << shapersubclassweight << "prio" << shapersubclassprio << "maxburst" << "20" << "avpkt" << "1000";
	    addshaperfilter << "tc" << "filter" << "add" << "dev" << shaperinterface << "protocol" << "ip" << "parent" << shaperrootclassparent << "prio" << "1" << "handle" << shapermark << "fw" << "classid" << shapersubclassid; 
	  
	    bool successsubclass=addshapersubclass.start(); 
	    bool successfilter=addshaperfilter.start();
	    if (successsubclass && successfilter) {
	      statusbar->message(i18n("New shaper filter created"), 2000);
	      QString msg;
	      msg.sprintf("sub class created for device %s\n", shaperinterfaceChoicedmp);
	      messageLog->insertItem(msg);
	      msg.sprintf("new shaper filter created for device %s\n", shaperinterfaceChoicedmp);
	      messageLog->insertItem(msg);
	    } else {
	      statusbar->message(i18n("tc died"), 2000);
	      QMessageBox::critical(0, "Error",
				    "sub class or filter has not been created, please check your parameters! \n");
	    }		
	  }
      }
  };

void knetfilter::delshaperRules() {
    QString shapermark, shaperglobalband, shaperrateband, shaperqdischandle, shaperrootclassid, shaperrootclassweight, shaperrootclassprio, shapersubclassid, shapersubclassweight, shapersubclassprio, shaperinterface, shaperrootclassparent;
    
    char shaperinterfaceChoice2[5];
    strcpy (shaperinterfaceChoice2, shaperinterfaceChoice ); 
    shaperinterfaceChoicedmp = strcat ( shaperinterfaceChoice2, shaperinterfacenrChoicedmp); 
    shaperinterface.sprintf(shaperinterfaceChoicedmp); 

    shapermark.sprintf((const char *)(shaperMark->text()));
    shaperglobalband.sprintf((const char *)(shaperglobalBand->text()));
    shaperrateband.sprintf((const char *)(shaperrateBand->text()));
    shaperqdischandle.sprintf((const char *)(shaperqdiscHandle->text()));
    shaperrootclassid.sprintf((const char *)(shaperrootclassId->text()));
    shaperrootclassweight.sprintf((const char *)(shaperrootclassWeight->text()));
    shaperrootclassprio.sprintf((const char *)(shaperrootclassPrio->text()));
    shapersubclassid.sprintf((const char *)(shapersubclassId->text()));
    shapersubclassweight.sprintf((const char *)(shapersubclassWeight->text()));
    shapersubclassprio.sprintf((const char *)(shapersubclassPrio->text()));
    
    delshaperqdisc.clearArguments();
    delshaperrootclass.clearArguments();
    delshapersubclass.clearArguments();
    delshaperfilter.clearArguments();

    if ( qdisc_exec == 0 && class_exec == 0 && subclass_exec == 0)
      {
	QMessageBox::critical(0, "Error",
			      "You have to say which action you want to perform! \n Remember to remove subclasses  at first, then the root class \n and at the end the qdisc!\n"); 
      }
    else if(shaperglobalband.length()==0)
      {
	QMessageBox::critical(0, "Error",
			      "You have to supply global bandwidht on net device \n e.g. 100Mbit! \n");
      }


    char *shaperrootclassParent;
    char shaperrootclassParent2[5];
	
    strcpy (shaperrootclassParent2, (const char *)(shaperqdiscHandle->text()) ); 
    shaperrootclassParent = strcat ( shaperrootclassParent2, "0"); 
    shaperrootclassparent.sprintf(shaperrootclassParent); 



    if ( subclass_exec == 1 )
      {
	if(shaperrateband.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the amount on bandwidth on net device \n you want to reser for XX marked packets \n e.g. 600Kbit! \n");
	  }
	else if (shaperqdischandle.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the qdisc handle! \n e.g. 1! \n So knetfilter can establish the filter parent. \n");
	  }
	else if(shapermark.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the mark that the traffic shaper \n should use to count the packet for a reserved rate. \n e.g. 0x03! \n");
	  }
	else if (shaperrootclassid.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the root class ID! \n so knetfilter can establish to which parent the rule \n has to be conencted\n e.g. 1:10! \n");
	  }	
	else if (shapersubclassid.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the subclass ID!\n e.g 1:11! \n");

				  }
	else if (shapersubclassweight.length()==0) 
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the subclass data flow weight! :)\n e.g. 600Kbit! \n");
	  }
	else if (shapersubclassprio.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "you have to supply the sub class priority!\n e.g. 5! \n");
	  }
	else
	  {
	    delshapersubclass << "tc" << "class" << "del" << "dev" << shaperinterface << "parent" << shaperrootclassid << "classid" << shapersubclassid << "cbq" << "bandwidth" << shaperglobalband << "rate" << shaperrateband << "allot" << "1514" << "weight" << shapersubclassweight << "prio" << shapersubclassprio << "maxburst" << "20" << "avpkt" << "1000";
	    delshaperfilter << "tc" << "filter" << "del" << "dev" << shaperinterface << "protocol" << "ip" << "parent" << shaperrootclassparent << "prio" << "1" << "handle" << shapermark << "fw" << "classid" << shapersubclassid; 
	  
	    bool successfilter=delshaperfilter.start();
	    bool successsubclass=delshapersubclass.start(); 
	    if (successfilter && successsubclass) {
	      statusbar->message(i18n("shaper filter deleted"), 2000);
	      QString msg;
	      msg.sprintf("sub class created for device %s\n", shaperinterfaceChoicedmp);
	      messageLog->insertItem(msg);
	      msg.sprintf("shaper filter deleted for device %s\n", shaperinterfaceChoicedmp);
	      messageLog->insertItem(msg);
	    } else {
	      statusbar->message(i18n("tc died"), 2000);
	      QMessageBox::critical(0, "Error",
				    "sub class or filter has not been deleted, please check your parameters! \n");
	    }		
	  }
      }



    if ( class_exec == 1 )
      {

	if (shaperqdischandle.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the qdisc handle! \n e.g. 1! \n So knetfilter can establish the root class parent. \n");
	  }
	else if (shaperrootclassid.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the root classID! \n e.g. 1:10! \n");
	  }
	else if (shaperrootclassweight.length()==0) 
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the root class data flow weight! :)\n e.g. 1Mbit! \n");
	  }
	else if (shaperrootclassprio.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "you have to supply the root class priority!\n e.g. 8! \n");
	  }
	else
	  {
	    delshaperrootclass << "tc" << "class" << "del" << "dev" << shaperinterface << "parent" << shaperrootclassparent << "classid" << shaperrootclassid << "cbq" << "bandwidth" << shaperglobalband << "rate" << shaperglobalband <<  "allot" << "1514"<< "weight" << shaperrootclassweight << "prio" << shaperrootclassprio << "maxburst" << "20" << "avpkt" << "1000";   
	
		bool successrootclass=delshaperrootclass.start(); 
		if (successrootclass) {
		  statusbar->message(i18n("New root class deleted"), 2000);
		  QString msg;
		  msg.sprintf("root class deleted for device %s\n", shaperinterfaceChoicedmp);
		  messageLog->insertItem(msg);
		} else {
		  statusbar->message(i18n("tc died"), 2000);
		  QMessageBox::critical(0, "Error",
					"root class has not been deleted, please check your parameters! \n");
		}		
	  }
	
      }



    if ( qdisc_exec == 1 )
      {
	if (shaperqdischandle.length()==0)
	  {
	    QMessageBox::critical(0, "Error",
				  "You have to supply the qdisc handle! \n e.g. 1! \n");
	  }
	else
	  {
	    delshaperqdisc << "tc" << "qdisc" << "del" << "dev" << shaperinterface << "root" << "handle" << shaperqdischandle <<  "cbq" << "bandwidth" << shaperglobalband << "avpkt" << "1000"; 
	  }
	bool successqdisc=delshaperqdisc.start(); 
	if (successqdisc) {
	  statusbar->message(i18n("qdisc deleted"), 2000);
	  QString msg;
	  msg.sprintf("qdisc deleted for device %s\n", shaperinterfaceChoicedmp);
	  messageLog->insertItem(msg);
	} else {
	  statusbar->message(i18n("tc died"), 2000);
	  QMessageBox::critical(0, "Error",
				"qdisc has not been deleted, please check your parameters! \n");
	}
      }

  };



// set up interface

void knetfilter::trafficShaper() {
    if ( shaperList == NULL )
      {
	//	setupConnect();
	
	shaperList = new KNFWidget();
	shaperList->resize(640,480);
	shaperList->setCaption("Traffic Shaper");
	
	QBoxLayout *top = new QBoxLayout(shaperList, QBoxLayout::LeftToRight, 12); 
	QGridLayout * grid = new QGridLayout(10,11);
	top->addLayout(grid,11);
	
	
	QLabel *labelshaperInterface = new QLabel(shaperList);
	labelshaperInterface->setText("Interface:");
	grid->addMultiCellWidget(labelshaperInterface,0,0,0,0);
	
	shaperinterface = new QComboBox( FALSE, shaperList, "interface");
	shaperinterface->insertItem("eth");
	shaperinterface->insertItem("tr");
	shaperinterface->insertItem("lec");
	shaperinterface->insertItem("atm");
	shaperinterface->insertItem("bond");
	shaperinterface->insertItem("lo");
	shaperinterface->insertItem("slip");
	shaperinterface->insertItem("plip");
	shaperinterface->insertItem("ppp");
	shaperinterface->insertItem("ippp");
	shaperinterface->insertItem("tap");
	shaperinterface->insertItem("tun");
	shaperinterface->setFixedHeight(shaperinterface->sizeHint().height());
	connect(shaperinterface,SIGNAL(activated(int)), SLOT(shaperinterfaceActivated(int)));
	grid->addMultiCellWidget(shaperinterface,0,0,1,2);
	
	QLabel *labelshaperInterfacenr = new QLabel(shaperList);
	labelshaperInterfacenr->setText("Interface nr:");
	grid->addMultiCellWidget(labelshaperInterfacenr,1,1,0,0);
	
	shaperinterfacenr = new QComboBox( FALSE, shaperList, "interface nr");
	shaperinterfacenr->insertItem("0");
	shaperinterfacenr->insertItem("1");
	shaperinterfacenr->insertItem("2");
	shaperinterfacenr->insertItem("3");
	shaperinterfacenr->insertItem("4");
	shaperinterfacenr->insertItem("5");
	shaperinterfacenr->setFixedHeight(shaperinterfacenr->sizeHint().height());
	connect(shaperinterfacenr,SIGNAL(activated(int)), SLOT(shaperinterfacenrActivated(int)));
	grid->addMultiCellWidget(shaperinterfacenr,1,1,1,2);
	
	
	QLabel *labelshaperglobalBand = new QLabel(shaperList);
	labelshaperglobalBand->setText("net bandwidth (e.g 100Mbit):");
	shaperglobalBand = new QLineEdit(shaperList);
	shaperglobalBand->setFixedHeight(shaperglobalBand->sizeHint().height());
	shaperglobalBand->setText("");
	
	grid->addMultiCellWidget(labelshaperglobalBand,0,0,3,3);
	grid->addMultiCellWidget(shaperglobalBand,0,0,4,5);
	
	
	QLabel *labelshaperrateBand = new QLabel(shaperList);
	labelshaperrateBand->setText("reserved rate (e.g 2Mbit):");
	shaperrateBand = new QLineEdit(shaperList);
	shaperrateBand->setFixedHeight(shaperrateBand->sizeHint().height());
	shaperrateBand->setText("");
	
	grid->addMultiCellWidget(labelshaperrateBand,1,1,3,3);
	grid->addMultiCellWidget(shaperrateBand,1,1,4,5);
	
	
	QLabel *labelshaperMark = new QLabel(shaperList);
	labelshaperMark->setText("marked packets to filter:");
	shaperMark = new QLineEdit(shaperList);
	shaperMark->setFixedHeight(shaperMark->sizeHint().height());
	shaperMark->setText("");
	
	grid->addMultiCellWidget(labelshaperMark,2,2,0,1);
	grid->addMultiCellWidget(shaperMark,2,2,2,3);
	
	QLabel *labelshaperaccts = new QLabel(shaperList);
	labelshaperaccts->setText("Actions: ");
	
	grid->addMultiCellWidget(labelshaperaccts,3,3,0,0);
	
	QLabel *labelshaperqdisc = new QLabel(shaperList);
	labelshaperqdisc->setText("add CBQ scheduler to net device:");
	shaperqdisc = new QCheckBox( shaperList, "QdiscBox" );
	shaperqdisc->setGeometry(8,8,8,8);
	shaperqdisc->setText("mandatory to set up rules");
	shaperqdisc->setAutoRepeat( FALSE );
	shaperqdisc->setAutoResize( FALSE );
	connect(shaperqdisc,SIGNAL(clicked()), SLOT(shaperQdisc()));
	
	grid->addMultiCellWidget(labelshaperqdisc,3,3,1,2);
	grid->addMultiCellWidget(shaperqdisc,3,3,3,5);
	
	QLabel *labelshaperclass = new QLabel(shaperList);
	labelshaperclass->setText("create the root class on net device:");
	shaperclass = new QCheckBox( shaperList, "QdiscBox" );
	shaperclass->setGeometry(8,8,8,8);
	shaperclass->setText("to set up global bandwidht");
	shaperclass->setAutoRepeat( FALSE );
	shaperclass->setAutoResize( FALSE );
	connect(shaperclass,SIGNAL(clicked()), SLOT(shaperClass()));
	
	grid->addMultiCellWidget(labelshaperclass,4,4,1,2);
	grid->addMultiCellWidget(shaperclass,4,4,3,5);
	
	QLabel *labelshapersubclass = new QLabel(shaperList);
	labelshapersubclass->setText("create sub class on net device:");
	shapersubclass = new QCheckBox( shaperList, "QdiscBox" );
	shapersubclass->setGeometry(8,8,8,8);
	shapersubclass->setText("to reserve rate for marked packets");
	shapersubclass->setAutoRepeat( FALSE );
	shapersubclass->setAutoResize( FALSE );
	connect(shapersubclass,SIGNAL(clicked()), SLOT(shaperSubclass()));
	
	grid->addMultiCellWidget(labelshapersubclass,5,5,1,2);
	grid->addMultiCellWidget(shapersubclass,5,5,3,5);
	
	// mandatory field

	QLabel *labelmandatoryshaper = new QLabel(shaperList);
	labelmandatoryshaper->setText("Mandatory data: (please pay attention! All data have to be correctly supplied)");

	grid->addMultiCellWidget(labelmandatoryshaper,6,6,0,7);

	// qdisc
	QLabel *labelqdischandle = new QLabel(shaperList);
	labelqdischandle->setText("qdisc handle:");
	
	shaperqdiscHandle = new QLineEdit(shaperList);
	shaperqdiscHandle->setFixedHeight(shaperqdiscHandle->sizeHint().height());
	shaperqdiscHandle->setText("1:");

	grid->addMultiCellWidget(labelqdischandle,7,7,0,0);
	grid->addMultiCellWidget(shaperqdiscHandle,7,7,1,1);

	// root class
	
	QLabel *labelrootclassid = new QLabel(shaperList);
	labelrootclassid->setText("root class id:");
	
	shaperrootclassId = new QLineEdit(shaperList);
	shaperrootclassId->setFixedHeight(shaperrootclassId->sizeHint().height());
	shaperrootclassId->setText("1:10");

	grid->addMultiCellWidget(labelrootclassid,8,8,0,0);
	grid->addMultiCellWidget(shaperrootclassId,8,8,1,1);

	QLabel *labelrootclassweight = new QLabel(shaperList);
	labelrootclassweight->setText("weight:");
	
	shaperrootclassWeight = new QLineEdit(shaperList);
	shaperrootclassWeight->setFixedHeight(shaperrootclassWeight->sizeHint().height());
	shaperrootclassWeight->setText("1Mbit");

	grid->addMultiCellWidget(labelrootclassweight,8,8,2,2);
	grid->addMultiCellWidget(shaperrootclassWeight,8,8,3,3);

	QLabel *labelrootclassprio = new QLabel(shaperList);
	labelrootclassprio->setText("priority:");
	
	shaperrootclassPrio = new QLineEdit(shaperList);
	shaperrootclassPrio->setFixedHeight(shaperrootclassPrio->sizeHint().height());
	shaperrootclassPrio->setText("8");

	grid->addMultiCellWidget(labelrootclassprio,8,8,4,4);
	grid->addMultiCellWidget(shaperrootclassPrio,8,8,5,5);


	// subclass 

	QLabel *labelsubclassid = new QLabel(shaperList);
	labelsubclassid->setText("sub class id:");
	
	shapersubclassId = new QLineEdit(shaperList);
	shapersubclassId->setFixedHeight(shapersubclassId->sizeHint().height());
	shapersubclassId->setText("1:11");

	grid->addMultiCellWidget(labelsubclassid,9,9,0,0);
	grid->addMultiCellWidget(shapersubclassId,9,9,1,1);

	QLabel *labelsubclassweight = new QLabel(shaperList);
	labelsubclassweight->setText("weight:");
	
	shapersubclassWeight = new QLineEdit(shaperList);
	shapersubclassWeight->setFixedHeight(shapersubclassWeight->sizeHint().height());
	shapersubclassWeight->setText("600Kbit");

	grid->addMultiCellWidget(labelsubclassweight,9,9,2,2);
	grid->addMultiCellWidget(shapersubclassWeight,9,9,3,3);

	QLabel *labelsubclassprio = new QLabel(shaperList);
	labelsubclassprio->setText("priority:");
	
	shapersubclassPrio = new QLineEdit(shaperList);
	shapersubclassPrio->setFixedHeight(shapersubclassPrio->sizeHint().height());
	shapersubclassPrio->setText("5");

	grid->addMultiCellWidget(labelsubclassprio,9,9,4,4);
	grid->addMultiCellWidget(shapersubclassPrio,9,9,5,5);



	/*	shaperBox = new QListBox(shaperList);
	 *	grid->addMultiCellWidget(shaperBox,7,8,0,9);*/
	
	QPushButton *btnShaper = new QPushButton(shaperList);
	btnShaper->setText("Commit");
	btnShaper->setFixedHeight(btnShaper->sizeHint().height());
	connect(btnShaper,SIGNAL(clicked()), this, SLOT(startshaperRules()));
	grid->addWidget(btnShaper,11,1);	  

	QPushButton *btndelShaper = new QPushButton(shaperList);
	btndelShaper->setText("Delete");
	btndelShaper->setFixedHeight(btndelShaper->sizeHint().height());
	connect(btndelShaper,SIGNAL(clicked()), this, SLOT(delshaperRules()));
	grid->addWidget(btndelShaper,11,3);	  

	QPushButton *btnClose = new QPushButton(shaperList);
	btnClose->setText("Close");
	btnClose->setFixedHeight(btnClose->sizeHint().height());
	connect(btnClose,SIGNAL(clicked()), this, SLOT(closeshaperRules()));
	grid->addWidget(btnClose,11,6);	  
	
	shaperList->show();
	setCentralWidget(shaperList);
      }
    else
      {
	if ( !shaperList->isVisible() )
	  {
	    shaperList->show();
	  }
	else
	  {
	    QMessageBox::critical(0,"Warning", "Already Running\n");
	  }
      }
  };   

void knetfilter::closeshaperRules() {
  
  shaperList->close();

};


void knetfilter::shaperRules(KProcess *, char *data, int len) {

  if (len<0)
    return;
  static QString remainder;
  QString list;

  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;

  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;
  
   while (1)
  {
    newindex=list.find('\n',index);
    if(newindex==-1) {
      remainder=list.right(list.length()-index);
      break;
    } else {
      lines.append(list.mid(index,newindex-index));
      index=newindex+1;
    };
  };
 
   /*  if(lines.count()>0){
    *    shaperBox->insertStrList(&lines);
    *};
    *
    *shaperBox->insertItem(remainder.data());
    *shaperBox->setTopItem(shaperBox->count()-shaperBox->numItemsVisible());*/
};


// menu widget choice interface
void knetfilter::shaperinterfaceActivated(int index) {

  switch(index) {
  default:
    shaperinterfaceChoice = "eth";
  case 0:
    shaperinterfaceChoice = "eth";
    break;
  case 1:
    shaperinterfaceChoice = "tr";
    break;
  case 2:
    shaperinterfaceChoice = "lec";
    break;
  case 3:
    shaperinterfaceChoice = "atm";
    break;
  case 4:
    shaperinterfaceChoice = "bond";
    break;
  case 5:
    shaperinterfaceChoice = "lo";
    break;
  case 6:
    shaperinterfaceChoice = "slip";
    break;
  case 7:
    shaperinterfaceChoice = "plip";
    break;
  case 8:
    shaperinterfaceChoice = "ppp";
    break;
  case 9:
    shaperinterfaceChoice = "ippp";
    break;
  case 10:
    shaperinterfaceChoice = "tap";
    break;
  case 11:
    shaperinterfaceChoice = "tun";
    break;
  };

};


void knetfilter::shaperinterfacenrActivated(int index) {

  switch(index) {
  default:
    shaperinterfacenrChoice = 0;
  case 0:
    shaperinterfacenrChoice = 0;
    shaperinterfacenrChoicedmp = "0";
    break;
  case 1:
    shaperinterfacenrChoice = 1;
    shaperinterfacenrChoicedmp = "1";
    break;
  case 2:
    shaperinterfacenrChoice = 2;
    shaperinterfacenrChoicedmp = "2";
    break;
  case 3:
    shaperinterfacenrChoice = 3;
    shaperinterfacenrChoicedmp = "3";
    break;
  case 4:
    shaperinterfacenrChoice = 4;
    shaperinterfacenrChoicedmp = "4";
    break;
  case 5:
    shaperinterfacenrChoice = 5;
    shaperinterfacenrChoicedmp = "5";
    break;
  };

};


void knetfilter::shaperQdisc() {
  if (shaperqdisc->isChecked())
    {
      qdisc_exec=1;
    }
  else
    {
      qdisc_exec=0;
    }
};


void knetfilter::shaperClass() {
  if (shaperclass->isChecked())
    {
      class_exec=1;
    }
  else
    {
      class_exec=0;
    }
};


void knetfilter::shaperSubclass() {
  if (shapersubclass->isChecked())
    {
      subclass_exec=1;
    }
  else
    {
      subclass_exec=0;
    }
};

	
// Traffic Shaper's Rules Monitor


void knetfilter::startqdiscMonitor() {
  
  showip.clearArguments();
  showqdisc.clearArguments();
  char shapermonitorinterfaceChoice2[5];
  strcpy ( shapermonitorinterfaceChoice2, shapermonitorinterfaceChoice );

  shapermonitorinterfaceChoicedmp = strcat ( shapermonitorinterfaceChoice2, shapermonitorinterfacenrChoicedmp ); 

  showip << "ip" << "addr" << "show" << "dev" << shapermonitorinterfaceChoicedmp ; 
  showqdisc << "tc" << "qdisc" << "show" << "dev" << shapermonitorinterfaceChoicedmp ; 

  
  bool showaddr=showip.start(KProcess::NotifyOnExit,
			     KProcess::AllOutput);
  bool success=showqdisc.start(KProcess::NotifyOnExit,
			       KProcess::AllOutput);
  if (showaddr && success)
    statusbar->message(i18n("Running..."), 2000);
  else
    statusbar->message(i18n("Couldn't start tc"), 2000);

};


void knetfilter::startclassMonitor() {

  showip.clearArguments();
  showclass.clearArguments();
  char shapermonitorinterfaceChoice2[5];
  strcpy ( shapermonitorinterfaceChoice2, shapermonitorinterfaceChoice );

  shapermonitorinterfaceChoicedmp = strcat ( shapermonitorinterfaceChoice2, shapermonitorinterfacenrChoicedmp ); 

  showip << "ip" << "addr" << "show" << "dev" << shapermonitorinterfaceChoicedmp ; 
  showclass << "tc" << "class" << "show" << "dev" << shapermonitorinterfaceChoicedmp ; 

  bool showaddr=showip.start(KProcess::NotifyOnExit,
			     KProcess::AllOutput);
  bool success=showclass.start(KProcess::NotifyOnExit,
			       KProcess::AllOutput);
  if (showaddr && success)
    statusbar->message(i18n("Running..."), 2000);
  else
    statusbar->message(i18n("Couldn't start tc"), 2000);

};


void knetfilter::startfilterMonitor() {

  showip.clearArguments();
  showfilter.clearArguments();
  char shapermonitorinterfaceChoice2[5];
  strcpy ( shapermonitorinterfaceChoice2, shapermonitorinterfaceChoice );

  shapermonitorinterfaceChoicedmp = strcat ( shapermonitorinterfaceChoice2, shapermonitorinterfacenrChoicedmp ); 

  showip << "ip" << "addr" << "show" << "dev" << shapermonitorinterfaceChoicedmp ; 
  showfilter << "tc" << "filter" << "show" << "dev" << shapermonitorinterfaceChoicedmp ; 

  bool showaddr=showip.start(KProcess::NotifyOnExit,
			     KProcess::AllOutput);
  bool success=showfilter.start(KProcess::NotifyOnExit,
				KProcess::AllOutput);
  if (showaddr && success)
    statusbar->message(i18n("Running..."), 2000);
  else
    statusbar->message(i18n("Couldn't start tc"), 2000);

};


void knetfilter::trafficShaperMonitor() {
  if ( shapermonList == NULL )
    {
      //      setupConnect();

      shapermonList = new KNFWidget();
      shapermonList->resize(680,420);
      shapermonList->setCaption("current traffic shaper rules, qdisc, class and filter entries");
      
      QBoxLayout *top = new QBoxLayout(shapermonList, QBoxLayout::LeftToRight, 7); 
      QGridLayout *grid = new QGridLayout(7,5);
      top->addLayout(grid,5);
      
      shapermonBox = new QListBox(shapermonList);
      grid->addMultiCellWidget(shapermonBox,0,5,0,5);

      QLabel *labelshapermonInterface = new QLabel(shapermonList);
      labelshapermonInterface->setText("Interface:");
      grid->addMultiCellWidget(labelshapermonInterface,6,6,1,1);

      shapermoninterface = new QComboBox( FALSE, shapermonList, "interface");
      shapermoninterface->insertItem("eth");
      shapermoninterface->insertItem("tr");
      shapermoninterface->insertItem("lec");
      shapermoninterface->insertItem("atm");
      shapermoninterface->insertItem("bond");
      shapermoninterface->insertItem("lo");
      shapermoninterface->insertItem("slip");
      shapermoninterface->insertItem("plip");
      shapermoninterface->insertItem("ppp");
      shapermoninterface->insertItem("ippp");
      shapermoninterface->insertItem("tap");
      shapermoninterface->insertItem("tun");
      shapermoninterface->setFixedHeight(shapermoninterface->sizeHint().height());
      connect(shapermoninterface,SIGNAL(activated(int)), SLOT(shapermonitorinterfaceActivated(int)));
      grid->addMultiCellWidget(shapermoninterface,6,6,2,2);

      
      QLabel *labelshapermonInterfacenr = new QLabel(shapermonList);
      labelshapermonInterfacenr->setText("Interface nr:");
      grid->addMultiCellWidget(labelshapermonInterfacenr,6,6,3,3);

      shapermoninterfacenr = new QComboBox( FALSE, shapermonList, "interface nr");
      shapermoninterfacenr->insertItem("0");
      shapermoninterfacenr->insertItem("1");
      shapermoninterfacenr->insertItem("2");
      shapermoninterfacenr->insertItem("3");
      shapermoninterfacenr->insertItem("4");
      shapermoninterfacenr->insertItem("5");
      shapermoninterfacenr->setFixedHeight(shapermoninterfacenr->sizeHint().height());
      connect(shapermoninterfacenr,SIGNAL(activated(int)), SLOT(shapermonitorinterfacenrActivated(int)));
      grid->addMultiCellWidget(shapermoninterfacenr,6,6,4,4);

      QPushButton *btnQdisc = new QPushButton(shapermonList);
      btnQdisc->setText("Qdisc");
      btnQdisc->setFixedHeight(btnQdisc->sizeHint().height());
      connect(btnQdisc,SIGNAL(clicked()), this, SLOT(startqdiscMonitor()));
      grid->addWidget(btnQdisc,7,0);

      QPushButton *btnClass = new QPushButton(shapermonList);
      btnClass->setText("Class");
      btnClass->setFixedHeight(btnClass->sizeHint().height());
      connect(btnClass,SIGNAL(clicked()), this, SLOT(startclassMonitor()));
      grid->addWidget(btnClass,7,1);

      QPushButton *btnFilter = new QPushButton(shapermonList);
      btnFilter->setText("Filter");
      btnFilter->setFixedHeight(btnFilter->sizeHint().height());
      connect(btnFilter,SIGNAL(clicked()), this, SLOT(startfilterMonitor()));
      grid->addWidget(btnFilter,7,2);

      QPushButton *btnClose = new QPushButton(shapermonList);
      btnClose->setText("Close");
      btnClose->setFixedHeight(btnClose->sizeHint().height());
      connect(btnClose,SIGNAL(clicked()), this, SLOT(closeshaperMonitor()));
      grid->addWidget(btnClose,7,5);

      shapermonList->show();
      setCentralWidget(shapermonList);
    }
  else
    {
      if (!shapermonList->isVisible() )
	{
	  shapermonList->show();
	}
      else
	{
	  QMessageBox::critical(0,"Warning", "Already Running\n");
	}
    }      
};


void knetfilter::closeshaperMonitor() {
  
  shapermonList->close();

};


void knetfilter::shaperMonitor(KProcess *, char *data, int len) {

  if (len<0)
    return;
  static QString remainder;
  QString list;

  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;

  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;

  while (1)
   {
    newindex=list.find('\n',index);
    if(newindex==-1) {
      remainder=list.right(list.length()-index);
      break;
    } else {
      lines.append(list.mid(index,newindex-index));
      index=newindex+1;
    };
  };

  if(lines.count()>0){
    shapermonBox->insertStrList(&lines);
  };

  shapermonBox->insertItem(remainder.data());
  shapermonBox->setTopItem(shapermonBox->count()-shapermonBox->numItemsVisible());
};


// menu widget choice interface
void knetfilter::shapermonitorinterfaceActivated(int index) {

  switch(index) {
  default:
    shapermonitorinterfaceChoice = "eth";
  case 0:
    shapermonitorinterfaceChoice = "eth";
    break;
  case 1:
    shapermonitorinterfaceChoice = "tr";
    break;
  case 2:
    shapermonitorinterfaceChoice = "lec";
    break;
  case 3:
    shapermonitorinterfaceChoice = "atm";
    break;
  case 4:
    shapermonitorinterfaceChoice = "bond";
    break;
  case 5:
    shapermonitorinterfaceChoice = "lo";
    break;
  case 6:
    shapermonitorinterfaceChoice = "slip";
    break;
  case 7:
    shapermonitorinterfaceChoice = "plip";
    break;
  case 8:
    shapermonitorinterfaceChoice = "ppp";
    break;
  case 9:
    shapermonitorinterfaceChoice = "ippp";
    break;
  case 10:
    shapermonitorinterfaceChoice = "tap";
    break;
  case 11:
    shapermonitorinterfaceChoice = "tun";
    break;
  };

};


void knetfilter::shapermonitorinterfacenrActivated(int index) {

  switch(index) {
  default:
    shapermonitorinterfacenrChoice = 0;
  case 0:
    shapermonitorinterfacenrChoice = 0;
    shapermonitorinterfacenrChoicedmp = "0";
    break;
  case 1:
    shapermonitorinterfacenrChoice = 1;
    shapermonitorinterfacenrChoicedmp = "1";
    break;
  case 2:
    shapermonitorinterfacenrChoice = 2;
    shapermonitorinterfacenrChoicedmp = "2";
    break;
  case 3:
    shapermonitorinterfacenrChoice = 3;
    shapermonitorinterfacenrChoicedmp = "3";
    break;
  case 4:
    shapermonitorinterfacenrChoice = 4;
    shapermonitorinterfacenrChoicedmp = "4";
    break;
  case 5:
    shapermonitorinterfacenrChoice = 5;
    shapermonitorinterfacenrChoicedmp = "5";
    break;
  };

};

