/***************************************************************************
  transferpanel.cpp  -  description
  -------------------
begin                : Tue Jan 25 2000
copyright            : (C) 2000 by John Donoghue
email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knap_transferpanel.h"
#include "knap_listview.h"
#include <ksock.h>

#include <qlayout.h>
#include <qpopupmenu.h>
#include <kapp.h>
#include <qlabel.h>

#include <math.h>

#include "support_funcs.h"

#include "songinfo.h"
//#include "napstertransfer.h"
#include "napsterdownload1.h"
#include "napsterupload.h"
#include "napsterconnection.h"

#include "knap_preferences.h"

#include <stdlib.h>

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include <qtimer.h>

#include <iostream>

#include <qpainter.h>
#include <qcursor.h>

using namespace std;

#define UPDATETIME 2

class DownloadListItem : public QListViewItem
{
   public:
      DownloadListItem(QListView *parent,const char *s1,const char *s2,const char *s3,
	    const char *s4,const char *s5,const char *s6,const char *s7,const char *s8)
	 : QListViewItem(parent,s1,s2,s3,s4,s5,s6,s7,s8)
	 { }
      virtual QString text(int col) const
      {
	 static QString ret; // Copied on return from function so ok, even if ugly.

	 //    if (col==DLV_READ || col==DLV_SIZE || col==DLV_RATE) {
	 if (col==DLV_RATE) 
	 {
	    ret=convertSize(atoi(QListViewItem::text(col)));
	    return ret;
	 }
	 else if (col==DLV_READ) 
	 {
	    int read;
	    int size;
	    separate(QListViewItem::text(col), &read, &size);
	    ret = convertSize(read) + '/' + convertSize(size);
	    return ret;
	 }
	 else if (col==DLV_TIMELEFT) 
	 {
	    int timeleft = atoi(QListViewItem::text(col));
	    if (timeleft < 0) 
	    {
	       ret=""; // i18n("Unknown");
	       return ret;
	    }
	    int hours = (int)floor((double)(timeleft / 3600));
	    int minutes = (int)floor((double)((timeleft % 3600) / 60));
	    int seconds = timeleft % 60;
	    ret = QString().setNum(hours).rightJustify(2, '0') + ":" +
	       QString().setNum(minutes).rightJustify(2, '0') + ":" +
	       QString().setNum(seconds).rightJustify(2, '0');
	    return ret;
	 }
	 else
	    return QListViewItem::text(col);
      }

      virtual QString key(int col,bool asc) const
      {
	 static QString ret; // Copied on return from function so ok, even if ugly.


	 if(col==DLV_RATE) 
	 { // rate
	    ret.sprintf( "%010ld", atol(QListViewItem::text(col)) );
	    return ret;
	 }
	 return QListViewItem::text(col);
      }

      virtual void paintCell (QPainter * p,const QColorGroup &cg,int column,
	    int width,int align)
      {
	 if(column!=DLV_PROGRESS) QListViewItem::paintCell(p,cg,column,width,align);
	 else 
	 {
	    // paint the pseudo progressbar
	    p->setPen(cg.dark());
	    p->drawRect(0,0,width,height());
	    p->fillRect(1,1,width-2,height()-2,cg.base());
	    double v; // = width-1;

	    int rd;
	    int sz;
	    separate(QListViewItem::text(DLV_READ), &rd, &sz);

	    if(sz>0) 
	    {
	       v = ((double)rd / sz * (double)(width -2));

	       if(v>1.0) p->fillRect(1,1,(int)v,height()-2,cg.midlight());
	       v = ((double)rd / sz * 100.0);
	    }
	    else v = 0;

	    // show the text
	    p->setPen(cg.text());
	    p->drawText(0,0,width-1,height()-1,AlignCenter,QString().setNum((int)v) + "%");


	 }
      }
};



/*
 *  Constructor
 */
   KNAP_TransferPanel::KNAP_TransferPanel(QWidget *parent, const char *name )
: QFrame(parent,name)
{
   showtransferpath=false;

   transfers.setAutoDelete(true);

   setFrameStyle( QFrame::Panel | QFrame::Sunken );

   QGridLayout *grid=new QGridLayout(this,2,1,5,5);

   QLabel *l = new QLabel(name,this,"transferslabel");
   l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
   grid->addWidget(l,0,0);

   transferlistview=new KNAP_ListView(this,"transferview");
   transferlistview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
   //grid->addMultiCellWidget(transferlistview,1,1,0,0);
   grid->addWidget(transferlistview,1,0);

   transferlistview->addColumn(i18n("file name"),200);
   transferlistview->setColumnWidthMode(DLV_FILE,QListView::Manual);
   transferlistview->addColumn(i18n("read/size"),80);
   transferlistview->setColumnWidthMode(DLV_READ,QListView::Manual);
   transferlistview->addColumn(i18n("rate/s"),80);
   transferlistview->setColumnWidthMode(DLV_RATE,QListView::Manual);
   transferlistview->addColumn(i18n("user"),80);
   transferlistview->setColumnWidthMode(DLV_USER,QListView::Manual);
   transferlistview->addColumn(i18n("status"),80);
   transferlistview->setColumnWidthMode(DLV_STATUS,QListView::Manual);

   transferlistview->addColumn(i18n("progress"),80);
   transferlistview->setColumnWidthMode(DLV_PROGRESS,QListView::Manual);

   transferlistview->addColumn(i18n("time left"),80);
   transferlistview->setColumnWidthMode(DLV_TIMELEFT,QListView::Manual);

   transferlistview->loadWidths();

   // create the popup menu for the transferlist view
   transferpopupmenu=new QPopupMenu();
   if(transferpopupmenu) 
   {
      transferpopupmenu->insertItem(i18n("Clear Errors and Finished Transfers"),
	    this,SLOT(popupClear())) ;
//#ifdef DEVEL_CODE    
      transferpopupmenu->insertSeparator();
      transferpopupmenu->insertItem(i18n("Play/Stop"),this,SLOT(popupDownloadPlay())) ;
//#endif
      transferpopupmenu->insertSeparator();
      transferpopupmenu->insertItem(i18n("Ping user"),this,SLOT(popupPing()));
      transferpopupmenu->insertItem(i18n("Whois user"),this,SLOT(popupWhois()));
      transferpopupmenu->insertItem(i18n("Add User to friend list"),
	    this,SLOT(popupAddFriend()));

      transferpopupmenu->insertSeparator();
      transferpopupmenu->insertItem(i18n("Terminate transfer"),
	    this,SLOT(popupDownloadTerminate()));
#ifdef DEVEL_CODE
      transferpopupmenu->insertItem(i18n("Terminate transfer and delete file"),
	    this,SLOT(popupDownloadTerminateAndDelete()));
#endif
   }
   connect(transferlistview,
	 SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
	 this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));


   QTimer *timer=new QTimer(this);
   if(timer)
   {
      connect(timer,SIGNAL(timeout()),this,SLOT(timerUpdate()));

      timer->start(UPDATETIME * 1000); 
   } 

}


// Destructor
KNAP_TransferPanel::~KNAP_TransferPanel()
{
}



/*
 *  public slots
 */
void KNAP_TransferPanel::clear()
{
   transferlistview->clear();
}

QPopupMenu * KNAP_TransferPanel::getPopupMenu() const
{
   return transferpopupmenu;
}

/*
 *  private Slots
 */

void KNAP_TransferPanel::timerUpdate()
{
   //   cerr << "KNAP_TransferPanel::timerUpdate():\n";

   // time to update the lists
   SongInfo *song;
   for ( song=transfers.first(); song != 0; song=transfers.next() )
   {
      // find the song and the dload
      if(song->dload)
      {
	 song->dload->getInfo(&song->status,&song->read,&song->size,
	       &song->bps,&song->timeleft); 
      }
      updateTransferItem(song,song->dload ? song->dload->isDownload() : false);
      //}
}
}

void KNAP_TransferPanel::popupMenu( QListViewItem *i, const QPoint &pos, int col)
{
   QListViewItem *selecteditem=i;

   if(transferpopupmenu && selecteditem)
   {
      transferlistview->setSelected(selecteditem,true);
      transferpopupmenu->exec(QCursor::pos());
   }
}
/**
 * clear all finished and errored transfers 
 */
void KNAP_TransferPanel::popupClear()
{
   // TODO check works ~~~~~~~~~~~~~~~~~ !!!!!!!!!
   SongInfo *song;
   song=transfers.first();
   //for ( song=transfers.first(); song != 0; song=transfers.next() )

   while(song != 0)
   {
      // finished or an error happened
      if(song->status==NapsterTransfer::DL_FINISHED || song->status<0)
      {
	 QListViewItem *i = findItem(song);
	 if(i) delete i;
	 if(transfers.removeRef(song)!=true) // no remove happened - go to next
	    song=transfers.next();
	 else
	 {
	    // was removed - get the current now
	    //  NOTE: in verion 3 is song was last - this not points to new last
	    //  but doesnt matter here coz in next iteracton will call next
	    song = transfers.current();
	 } 	    
      }
      else song=transfers.next();
   }
}

void KNAP_TransferPanel::popupDownloadPlay()
{
   QListViewItem *selecteditem=transferlistview->currentItem();
   
   SongInfo *song;
   song=transfers.first();

   if(selecteditem) 
   {

      while(song != 0)
      {
        if(song->internal_id.findRev(selecteditem->text(DLV_XTRA))==0)
        {

         cerr << "KNAP_TransferPanel::popupDownloadPlay(): "
	     << song->fullpathname << endl;
	 return;
        }

        song=transfers.next();
      } 
     //emit sendcommand(QString("/play ") + selecteditem->text(DLV_FILE));
   }
}


void KNAP_TransferPanel::popupDownloadTerminate()
{
   QListViewItem *it=transferlistview->currentItem();

   if(it) 
   {
      //emit terminate(it);
      // cancel the dload

      //if(sg->internal_id.findRev(it->text(DLV_XTRA))==0) 
      SongInfo song(it->text(DLV_FILE),"", 0,0,0,0,it->text(DLV_USER));
      song.internal_id = it->text(DLV_XTRA);

      cerr << "KNAP_TransferPanel::popupDownloadTerminate(): " << song.filename << endl;

      // now find in dload list by the id - not an error - a terminate
      stopDownload(&song,true, 0);

   }
}


void KNAP_TransferPanel::popupDownloadTerminateAndDelete()
{
   QListViewItem *selecteditem=transferlistview->currentItem();

   if(selecteditem) {
      //emit terminate_and_delete(selecteditem);
   }
}


void KNAP_TransferPanel::popupPing()
{
   QListViewItem *selecteditem=transferlistview->currentItem();

   if(selecteditem) 
   {
      // emit ping(selecteditem->text(DLV_USER));
      emit sendcommand(QString("/ping ") + selecteditem->text(DLV_USER));
   }
}


void KNAP_TransferPanel::popupWhois()
{
   QListViewItem *selecteditem=transferlistview->currentItem();

   if(selecteditem) 
   {
      //emit whois(selecteditem->text(DLV_USER));
      emit sendcommand(QString("/whois ") + selecteditem->text(DLV_USER));
   }
}


void KNAP_TransferPanel::popupAddFriend()
{
   QListViewItem *item=transferlistview->firstChild();

   while(item) {
      if(item->isSelected()) 
      {
	 // selected
	 // emit addFriend(item->text(DLV_USER)); 
	 emit sendcommand(QString("/add ") + item->text(DLV_USER)); 
      }
      item = item->nextSibling();
   }
}



/*
 *  public Members
 */
//void KNAP_TransferPanel::addDownloadItem(SongInfo *song)
void KNAP_TransferPanel::addDownloadItem(const char *user,const char *file)
{
   //   if(!song) return;

   SongInfo *song = new SongInfo(file,"",0,0,0,0,user);

   // get name depending on if we want all of the name or not
   QString s_filename;
   if(!showtransferpath) s_filename=getFileName(song->filename);
   else s_filename=song->filename;


   // TODO check if already have this download!!!!!

   QListViewItem *i;

   QString s = ""; // TODO FIXME
   s += QString().setNum(song->read);
   s += "/";
   s += QString().setNum(song->size);

   // set the status to initialising 
   song->status = NapsterTransfer::DL_INIT;


   // create a unique ID for the song - this shouldnt be too bad 
   int  v = QTime().msecsTo(QTime::currentTime());
   song->internal_id = QDate::currentDate().toString() 
      + ":" + QString().setNum(v) + ":" + QString().setNum(transferlistview->childCount());


   // put the item in the listview
   /*
    *    i=new DownloadListItem(transferlistview,
    getFileName(song->filename), // s_filename 
    s,
    QString().setNum(song->rate),
    song->user,
    convertDownloadStatus(song->status),
    "",
    "",
   //song->md5);
   song->internal_id);
    */
   i=new DownloadListItem(transferlistview,
	 getFileName(song->filename), // s_filename 
	 "",
	 "",
	 song->user,
	 convertDownloadStatus(song->status),
	 "",
	 "",
	 //song->md5);
	 song->internal_id);

   song->fullpathname = file;
   
	 // we own the song now and will free it
   transfers.append(song);
}

bool KNAP_TransferPanel::stopDownload(SongInfo *si,bool findbyid,int naperror)
{
   SongInfo *song;
   song=transfers.first();

   while(song != 0)
   {
      if( song->status>0 && song->status!=NapsterTransfer::DL_FINISHED && // not finished
	    // found by id   
	    ((findbyid==true && si->internal_id.findRev(song->internal_id)==0) ||
	     // found by name
	     (findbyid==false && song->user==si->user && song->filename==si->filename))
	)
      {
	 if(song->dload) song->dload->cancel();

	 if(!naperror)
	    song->status = NapsterTransfer::DL_KILLED;
	 else 
	 {
	    if(naperror == NAP_REMOTEQUEUEFULL)
	    	song->status = NapsterTransfer::DL_REMOTEQUEUEFULL;
	    else
	    	song->status = NapsterTransfer::DL_REMOTEERROR;
	 }

	 return true;
      }

      song=transfers.next();
   } 
   return false;
}
/**
 * add the download task to the download
 */
bool KNAP_TransferPanel::startDownload(SongInfo *si, const char *saveto,const char *us)
{
   // find the download in the songinfo list
   // NOTE: this will note have a unique internal_id passed in
   SongInfo *song;
   song=transfers.first();
   //for ( song=transfers.first(); song != 0; song=transfers.next() )
   KNAP_Preferences p;

   while(song != 0)
   {
      if(song->status==NapsterTransfer::DL_INIT 
	    && (song->user == si->user) && (song->filename == si->filename)
	    && (song->dload ==0))
      {
	 //song->status = NapsterTransfer::DL_INIT;
	 // start the download
	 cerr << "KNAP_TransferPanel::startDownload: " << song->filename << endl;

	 NapsterDownload1 *dload=new NapsterDownload1(si->ip,
	       si->port,si->filename,
	       //si->user,si->speed,
	       us,0,
	       makeFullFilePath(expandFileName(p.downloadpath), 
		  getFileName(si->filename))); 

	 if(dload) 
	 {
	    song->dload=dload;  // save ptr to the download

	    song->dload->start();
	    sendcommand("/downloadstarted");
	 }


	 return true;
      }
      else song=transfers.next();
   }
   return false;
}
/**
 * add the download task to the download
 */
bool KNAP_TransferPanel::startDownload(KSocket *sock,SongInfo *si, const char *saveto,const char *us)
{
   // find the download in the songinfo list
   // NOTE: this will note have a unique internal_id passed in
   SongInfo *song;
   song=transfers.first();
   //for ( song=transfers.first(); song != 0; song=transfers.next() )
   KNAP_Preferences p;

   while(song != 0)
   {
      if(song->status==NapsterTransfer::DL_INIT 
	    && (song->user == si->user) && (song->filename == si->filename)
	    && (song->dload ==0))
      {
	 //song->status = NapsterTransfer::DL_INIT;
	 // start the download
	 cerr << "KNAP_TransferPanel::startDownload: type 2: " << song->filename << endl;
	 cerr << "KNAP_TransferPanel::startDownload: size was: " << song->size << endl;
	 cerr << "KNAP_TransferPanel::startDownload: size1 was: " << si->size << endl;

	 NapsterDownload1 *dload=new NapsterDownload1(sock,
	       si->filename,
	       //si->user,si->speed,
	       us,si->size,0,
	       makeFullFilePath(expandFileName(p.downloadpath), 
		  getFileName(si->filename))); 

	 if(dload) 
	 {
	    song->dload=dload;  // save ptr to the download

	    song->dload->start();
	    sendcommand("/downloadstarted");
	 }


	 return true;
      }
      else song=transfers.next();
   }
   return false;
}

QListViewItem * KNAP_TransferPanel::findItem(SongInfo *sg)
{
   if(!sg) return 0;

   QListViewItem *it=transferlistview->firstChild();

   // find the song - assuming the id is unique
   while(it) 
   {
      if(sg->internal_id.findRev(it->text(DLV_XTRA))==0) 
      {
	 break;
      }
      it=it->nextSibling();
   }
   return it;
}

/*
 * update the song with new data after finding it in the list
 */
void KNAP_TransferPanel::updateTransferItem(SongInfo *sg,bool isdownload)
{
   if(!sg) return;

   QString s_filename;
   if(!showtransferpath) s_filename=getFileName(sg->filename);
   else s_filename=sg->filename;

   QListViewItem *it=transferlistview->firstChild();


   // find the song - assuming the id is unique
   while(it) 
   {
      //if(sg->md5.findRev(it->text(DLV_XTRA))==0) {
      if(sg->internal_id.findRev(it->text(DLV_XTRA))==0) 
      {
	 QString rs = QString().setNum(sg->read);
	 rs += " / ";
	 rs += QString().setNum(sg->size);
	 it->setText(DLV_READ,rs);
	 it->setText(DLV_RATE,QString().setNum(sg->bps));

	 if(sg->status!=NapsterTransfer::DL_REMOTEERROR || sg->status!=NapsterTransfer::DL_REMOTEQUEUEFULL
	       || (sg->dload==0 && sg->status==NapsterTransfer::DL_REMOTEERROR)
	       || (sg->dload==0 && sg->status==NapsterTransfer::DL_REMOTEQUEUEFULL))
	 {
	    it->setText(DLV_STATUS,convertDownloadStatus(sg->status)); // status
	 }
	 else
	 {
	    it->setText(DLV_STATUS,sg->dload->getData());
	 }
	 // changed from != so wont be updated on errors
	 if(sg->status>NapsterTransfer::DL_INIT)
	 {
	    it->setText(DLV_PROGRESS,"");
	    it->setText(DLV_TIMELEFT,QString().setNum(sg->timeleft));
	 }

	 if((sg->status < 0 || sg->status==NapsterTransfer::DL_FINISHED) 
	       && sg->ignore==false && sg->dload!=0)
	 {
            sg->ignore = true;
	    //if((PropertiesDlg::readPrefs()).beep) kapp->beep();
	    if(isdownload) sendcommand("/downloadended");
	    else sendcommand("/uploadended");
	 }
	 break;
      }
      it=it->nextSibling();
   }
}

void KNAP_TransferPanel::removeDownloadItem(SongInfo *sg)
{
   if(!sg) return;

   QListViewItem *it=transferlistview->firstChild();

   while(it) 
   {
      //if(sg->md5.findRev(it->text(DLV_XTRA))==0) {
      if(sg->internal_id.findRev(it->text(DLV_XTRA))==0) 
      {
	 delete it; // found it
	 break;
      }
      it=it->nextSibling();
   }
   return;
}


/*
 * get the number of items in the panel
 */
int KNAP_TransferPanel::numItems() const
{
   return transferlistview->childCount();
}


bool KNAP_TransferPanel::showDownloadPath() const
{
   return showtransferpath;
}


void KNAP_TransferPanel::setShowDownloadPath(bool yes)
{
   QString s_filename;

   if(showtransferpath!=yes)
   {
      showtransferpath=yes;
   }
   return;
}


// convert a number into equivalent status string
QString KNAP_TransferPanel::convertDownloadStatus(long s)
{
   QString str;
   switch(s) 
   {
      case NapsterTransfer::DL_FINISHED:
	 str=i18n("Finished");
	 break;
      case NapsterTransfer::DL_INIT:
	 str=i18n("Initializing");
	 break;
      case NapsterTransfer::DL_ERROR:
	 str=i18n("Error");
	 break;
      case NapsterTransfer::DL_DOWNLOADING:
	 str=i18n("Downloading");
	 break;
      case NapsterTransfer::DL_NOCONNECT:
	 str=i18n("No connection");
	 break;
      case NapsterTransfer::DL_KILLED:
	 str=i18n("Terminated");
	 break;
      case NapsterTransfer::DL_NOLOCALFILE:
	 str=i18n("No file");
	 break;
      case NapsterTransfer::DL_TIMEOUT:
	 str=i18n("Timed out");
	 break;
      case NapsterTransfer::DL_QUEUED:
	 str=i18n("Queued");
	 break;
      case NapsterTransfer::DL_REMOTEERROR:
	 str=i18n("Remote error");

	 break; 
      case NapsterTransfer::DL_REMOTEQUEUEFULL:
	 str=i18n("Remote queue full");

	 break; 
      default:
	 str="??????";
   }
   return str;
}


/**
 * add the download task to the upload
 */
bool KNAP_TransferPanel::startUpload(KSocket *sock,SongInfo *si, const char *saveto,const char *us)
{
   // find the download in the songinfo list
   // NOTE: this will note have a unique internal_id passed in
   SongInfo *song;
   song=transfers.first();


   // TODO if not shared - write NOTSHARED to socket and close it


   while(song != 0)
   {
      if(song->status==NapsterTransfer::DL_INIT 
	    && (song->user == si->user) && (song->filename == si->filename)
	    && (song->dload ==0))
      {
	 //song->status = NapsterTransfer::DL_INIT;
	 // start the download
	 cerr << "KNAP_TransferPanel::startUpload: type 2: " << song->filename << endl;
	 cerr << "KNAP_TransferPanel::startUpload: size was: " << song->size << endl;
	 cerr << "KNAP_TransferPanel::startUpload: size1 was: " << si->size << endl;

	 QString filepath  = song->filename;

	 // convert the name to a unix name
	 filepath =  toUnixName(filepath); 
	 //song->filename = filepath;

	 cerr << "KNAP_TransferPanel::startUpload: unixname: " << filepath << endl;
	 NapsterUpload *dload=new NapsterUpload(sock,
	       filepath,
	       //si->user,si->speed,
	       us,si->size,0,
	       filepath); 

	 if(dload) 
	 {
	    song->dload=dload;  // save ptr to the download
	    song->dload->start();
	    sendcommand("/uploadstarted");
	 }


	 return true;
      }
      else song=transfers.next();
   }
   return false;
}     
/**
 * add the download task to the upload
 */

bool KNAP_TransferPanel::startUpload(SongInfo *si,const char *us)
{
   // find the download in the songinfo list
   // NOTE: this will note have a unique internal_id passed in
   SongInfo *song;
   song=transfers.first();


   // TODO if not shared - write NOTSHARED to socket and close it


   while(song != 0)
   {
      if(song->status==NapsterTransfer::DL_INIT 
	    && (song->user == si->user) && (song->filename == si->filename)
	    && (song->dload ==0))
      {
	 //song->status = NapsterTransfer::DL_INIT;
	 // start the download
	 cerr << "KNAP_TransferPanel::startUpload: type 1: " << song->filename << endl;
	 cerr << "KNAP_TransferPanel::startUpload: size was: " << song->size << endl;
	 cerr << "KNAP_TransferPanel::startUpload: size1 was: " << si->size << endl;

	 QString filepath  = song->filename;

	 // convert the name to a unix name
	 filepath =  toUnixName(filepath); 
	 //song->filename = filepath;

	 cerr << "KNAP_TransferPanel::startUpload: unixname: " << filepath << endl;

	 //NapsterUpload *dload = new NapsterUpload(
	 //     long ip,int port,const char *filename,const char *user,
	 // int speed,const char *dest);
	 NapsterUpload *dload=new NapsterUpload(si->ip,si->port,
	       filepath,
	       us,si->speed,
	       //us,si->size,0,
	       filepath); 

	 if(dload) 
	 {
	    song->dload=dload;  // save ptr to the download
	    song->dload->start();
	    sendcommand("/uploadstarted");
	 }


	 return true;
      }
      else song=transfers.next();
   }
   return false;
}

