/***************************************************************************
                          extlistview.cpp  -  description
                             -------------------
    begin                : Thu Jun 1 2000
    copyright            : (C) 2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knap_listview.h"

#include <kapp.h>
//#include <stdlib.h>

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include <qheader.h>

#include <iostream.h>
#include <stdlib.h>
/*
 * class for a list view that saves its widths to the prefs under the name
 * given to the widget
 */

KNAP_ListView::KNAP_ListView(QWidget *parent, const char *name )
: KListView(parent,name)
{
  // load the widths - not much point here since cant do anything 
  // about them
  //loadWidths();
  setAllColumnsShowFocus(true);
  connect(this,SIGNAL( doubleClicked (QListViewItem *,const QPoint &,int) ),
	this,SLOT( itemClicked (QListViewItem *,const QPoint &,int) ));
}
KNAP_ListView::~KNAP_ListView()
{
  // save the widths before we die
  saveWidths();
}

// function that does the saving
bool KNAP_ListView::saveWidths()
{
  QHeader *head =header();
  QStrList widthlist;
  int cols,i;

   KConfig *config = KGlobal::config();

  // we can't save if there is no header or name to save under
  if(head==NULL || name()==NULL) return false;

  cols = head->count();

  for(i=0;i<cols;i++)
  {
    widthlist.append( QString().setNum(columnWidth(i)) );
  }

  config->writeEntry(name(),widthlist);

  return true;
}

QListViewItem * KNAP_ListView::find(const char *findstr,bool casesensitive)
{
  QListViewItem *it=firstChild();

  while(it) {
     if(casesensitive && strcmp(it->text(0),findstr)==0)
       break;
     if(!casesensitive && stricmp(it->text(0),findstr)==0)
       break;

     it=it->nextSibling();
  }
  return it;
}

// function that does the loading
bool KNAP_ListView::loadWidths()
{
  QHeader *head =header();
  QStrList widthlist;
  int readcols;
  unsigned int cols,i;
  char *s;

   KConfig *config = KGlobal::config();

  // we can't load if there is no header or name to save under
  if(head==NULL || name()==NULL) return false;

  cols = head->count();

  readcols = config->readListEntry(name(),widthlist);

  for(i=0;i<widthlist.count();i++)
  {
    s = widthlist.at(i);
    if(i<cols && s!=NULL)
     setColumnWidth(i,atoi(s));
  }

  return true;
}

void KNAP_ListView::itemClicked(QListViewItem *i,const QPoint &p,int c)
{
  if(i==0) return; 

  const char *s = i->text(0);
  
  if(s) 
  {
     emit dblClicked(s);
     emit dblClicked(i);
  }
}
