/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITPROTOCOL_H
#define KMFRULEOPTIONEDITPROTOCOL_H

#include "../../core/kmfruleoptioneditinterface.h"

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

class KInstance;

namespace KMF {
class IPTRule;
class KMFRuleEditorProtocol;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditProtocol : public KMFRuleOptionEditInterface {
	Q_OBJECT
public:
	KMFRuleOptionEditProtocol(QObject *parent = 0, const char *name = 0);

	~KMFRuleOptionEditProtocol();
	void loadRule( IPTRule* rule );	
	QWidget* editWidget();
	const QString& optionEditName() const;
	const QString& description() const;

private slots:
	void slotShowOverview();

private:
	KMFRuleEditorProtocol *m_edit;
	IPTRule *m_rule;
	
};



class KMFRuleOptionEditProtocolFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFRuleOptionEditProtocolFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditProtocolFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};
}








#endif
