//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfprotocollistview.h"

// QT includes
#include <qlistview.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwidgetstack.h>
#include <qtextedit.h>
#include <qtimer.h>


// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project includes
#include "../core/kmfprotocolcategory.h"
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocollibrary.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfnethost.h"
#include "../kmfwidgets/kmflistviewitem.h"
#include "../kmfwidgets/kmfchecklistitem.h"
namespace KMF {
KMFProtocolListView::KMFProtocolListView ( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallProtocolListView ( parent,name,fl ) {
	m_reloading = false;
	loadProtocols();
	connect( m_lv_protocols, SIGNAL( pressed( QListViewItem* ) ),
		this, SLOT( slotNewProtocolSelected( QListViewItem* ) ) );
	
}

KMFProtocolListView::~KMFProtocolListView() {}

/*$SPECIALIZATION$*/
void KMFProtocolListView::setHost( KMFNetHost* host ) {
	setEnabled( true );
	
 	QValueList<KMFProtocol*>& allProts = KMFProtocolLibrary::instance()->allProtocols();
	QValueList<KMFProtocol*>::iterator it;
	for( it = allProts.begin(); it != allProts.end(); ++it ) {
/*	QPtrListIterator<KMFProtocol> it( *KMFProtocol::protocolLibrary() );
	while ( it.current() ) {*/
		KMFProtocol * prot = *it;
		QListViewItem *qitem = m_lv_protocols->findItem( prot->name(), 0 );
		if ( ! qitem ) {
			kdDebug() << "No item found for protocol: " << prot->name() << endl;
		}
		
		KMFCheckListItem *item = dynamic_cast<KMFCheckListItem*>( qitem );
		if ( ! item ) {
			kdDebug() << "Item is no KMFCheckListItem" << endl;
		}
		
		if ( host->findProtocolUsageByProtocolUuid( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( true );
		}
		if ( host->protocolInherited( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( false );
		}
		if ( ! host->findProtocolUsageByProtocolUuid( prot->uuid() )  && ! host->protocolInherited( prot->uuid() ) ) {
			item->setOn( false );
			item->setEnabled( true );
		}
	}
}
void KMFProtocolListView::setZone( KMFNetZone* zone ) {
	setEnabled( true );
	QValueList<KMFProtocol*>& allProts = KMFProtocolLibrary::instance()->allProtocols();
	QValueList<KMFProtocol*>::iterator it;
	for( it = allProts.begin(); it != allProts.end(); ++it ) {
		KMFProtocol * prot = *it;
		QListViewItem *qitem = m_lv_protocols->findItem( prot->name(), 0 );
		if ( ! qitem ) {
			kdDebug() << "No item found for protocol: " << prot->name() << endl;
		}
		
		KMFCheckListItem *item = dynamic_cast<KMFCheckListItem*>( qitem );
		if ( ! item ) {
			kdDebug() << "Item is no KMFCheckListItem" << endl;
		}
		
		if ( zone->findProtocolUsageByProtocolUuid( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( true );
		}
		if ( zone->protocolInherited( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( false );
		}
		if ( 	! zone->findProtocolUsageByProtocolUuid( prot->uuid() )  && 
				! zone->protocolInherited( prot->uuid() ) ) {
			item->setOn( false );
			item->setEnabled( true );
		}
	}
}

void KMFProtocolListView::loadProtocols() {
	kdDebug() << "KMFProtocolListView::loadProtocols(" << endl;
	
	m_reloading = true;
	QListViewItemIterator listViewIt( m_lv_protocols );
	while ( listViewIt.current() ) {
		QListViewItem * qitem = listViewIt.current();
		++listViewIt;
		KMFCheckListItem * item = 0;
		item = dynamic_cast<KMFCheckListItem*> ( qitem );
		if( item && item->protocolUsage() ) {
			item->protocolUsage()->deleteLater();
		}
		
	}
	m_lv_protocols->clear();
	
	
	setEnabled( false );
	QValueList<KMFProtocol*>& allProts = KMFProtocolLibrary::instance()->allProtocols();
	QValueList<KMFProtocol*>::iterator it;
	for( it = allProts.begin(); it != allProts.end(); ++it ) {
		KMFProtocol * prot = *it;
/*		disconnect( prot, SIGNAL( destroyed( QObject* ) ),
			this, SLOT( slotOnProtocolDeleted( QObject* ) ) );
		connect( prot, SIGNAL( destroyed( QObject* ) ),
			this, SLOT( slotOnProtocolDeleted( QObject* ) ) );*/
		
		KMFProtocolUsage *protUsage = prot->createUsage();
		protUsage->setProtocol( prot );
		
			

		
		QString cat = prot->category()->name();
		QListViewItem *parentItem = m_lv_protocols->findItem( cat, 0 );
		
		if ( ! parentItem ) {
			KMFListViewItem *newParentItem = new KMFListViewItem( m_lv_protocols, 0, prot->category() );
			newParentItem->setText( 0, cat );
			newParentItem->loadNetfilterObject( prot->category() );
			newParentItem->setOpen( true );
			parentItem = newParentItem;
		}
		
		KMFCheckListItem *item = new KMFCheckListItem( parentItem, 0 , prot->name() , QCheckListItem::CheckBox, protUsage );
		item->setText( 0, prot->name() );
		// item->setText( 1, prot->uuid().toString() );
	}
	m_reloading = false;
}

void KMFProtocolListView::slotOnProtocolDeleted( QObject* ) {
	if ( m_reloading ) {
		return;
	}
	// loadProtocols();
}

void KMFProtocolListView::slotNewProtocolSelected( QListViewItem* qitem ) {
	if ( KMFCheckListItem * item = dynamic_cast<KMFCheckListItem*> ( qitem ) ) {
		emit sigProtocolClicked( item->protocolUsage(), item->isOn() );
	} else if ( KMFListViewItem * item = dynamic_cast<KMFListViewItem*> ( qitem ) ){
		emit sigProtocolCategoryClicked( item->protocolCategory() );
	}
}

}


#include "kmfprotocollistview.moc"

