//
// C++ Interface: kmfnetworkwidget
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFNETWORKWIDGET_H
#define KMFNETWORKWIDGET_H

#include "kmyfirewallnetworkwidget.h"

// QT includes
#include <qwidget.h>
#include <qguardedptr.h>

// KDE includes
#include <kdemacros.h>

// project includes
#include "../core/kmfnetzone.h"
#include "../core/ipaddress.h"

class QFocusEvent;

/**
@author Christian Hubinger
*/

namespace KMF {
class KDE_EXPORT KMFNetworkWidget : public KMyFirewallNetworkWidget {
	Q_OBJECT
public:
	KMFNetworkWidget(QWidget *parent = 0, const char *name = 0);
	~KMFNetworkWidget();
	
	void loadZone( KMFNetZone* );
	void allowEdit( bool );
private slots:
	void slotAddressChanged( const QString& );
	void slotDescriptionChanged();
	void slotShortMaskChanged( int );
	void slotZoneDeleted();
	
protected:
	void focusOutEvent( QFocusEvent * );
	
private:
	void blockAllSignals( bool );	

private:
	QGuardedPtr<KMFNetZone> m_zone;
	bool m_allowEdit;



signals:
	void sigZoneChanged( KMFNetZone* );
};
}
#endif
