/***************************************************************************
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFIPTINSTALLER_H
#define KMFIPTINSTALLER_H
#include <qobject.h>
#include <qpixmap.h>
#include <qstringlist.h>

#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>



#include "../../core/kmfplugin.h"
#include "../../core/kmfinstallerinterface.h"

#include "../../kmyfirewall.h"
class QString;
class QStringList;
class QLabel;
class QPushButton;
class QGridLayout;
class KTempFile;
class KInstance;


namespace KMF {
class KMFProcOut;
class KMFError;
class KMFTarget;
class KMFErrorHandler;
class KMFCompilerInterface;

class KMFIPTInstaller :  public KMFPlugin, public KMFInstallerInterface {
	Q_OBJECT

public:
	KMFIPTInstaller( QObject* parent = 0, const char* name = 0 );
	~KMFIPTInstaller();
	virtual void loadScript( const QString& );
	virtual KMFCompilerInterface* compiler();
	virtual void cmdRunFW();
	virtual void cmdStopFW();
	virtual void cmdInstallFW();
	virtual void cmdUninstallFW();
	virtual void cmdShowRunningConfig( const QString& );
	virtual void generateInstallerPackage( KMFTarget*, const KURL& );
	virtual const QString& osName() const {
		return m_osName;
	}
	virtual const QString& osGUIName() const {
		return m_osGUIName;
	}
	virtual QValueList<KMFCompilerInterface*>* compilers();
	
	void generateInstallerPackage( KMFTarget* tg );
	
	
public slots:
	void slotCloseWindow();
	void slotJobFinished( bool, const QString& );

private: 
	void loadIcons();
	KMFProcOut* execWidget();
	KMFError* createInitScript( const QString& file, const QString& systemtype );

	QString cmdShowAll();
	QString cmdShowFilter();
	QString cmdShowNat();
	QString cmdShowMangle();
	
	void parseFileHeaders( const QString& source_file_path, const QString& target_file_path ); 
	void writeBase64DataField( const QString& source_file_path, const QString& target_file_path, const QString& data );
	
	
private:    // data
	QString m_script;
	QString m_osName;
	QString m_osGUIName;
	
	bool fw_is_running;
	QLabel *m_lrun;
	QLabel *m_lshow;
	QLabel *m_lconf;
	QLabel *m_linstall;
	QPushButton *m_brun_fw;
	QPushButton *m_bstop_fw;
	QPushButton *m_bshow_sript;
	QPushButton *m_bshow_all;
	QPushButton *m_bshow_filter;
	QPushButton *m_bshow_nat;
	QPushButton *m_bshow_mangle;
	QPushButton *m_binstall;
	QPushButton *m_buninstall;
	QPushButton *m_bclose;
	QGridLayout *m_layout;
	QPixmap icon_run, icon_stop, icon_show;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KTempFile *temp_file, *temp_file2;
	KMFProcOut *m_execWidget;
signals:
	void sigStatusChanged();
	void sigHideMe();
	void sigShowMe();
};




class KMFIPTInstallerFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFIPTInstallerFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFIPTInstallerFactory() {};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
};
}

#endif // KMFIPTINSTALLER_H
