/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#include "xmlnames.h"

namespace KMF {

// Document Elements
const QString& XML::GenericDoc_DocumentElement = "kmfgrs";
const QString& XML::IPTDoc_DocumentElement = "kmfrs";
const QString& XML::KMFNetwork_DocumentElement = "kmfnet";

// Elements
const QString& XML::Protocol_Element = "protocol";
const QString& XML::Table_Element = "table";
const QString& XML::Chain_Element = "chain";
const QString& XML::Rule_Element = "rule";
const QString& XML::RuleOption_Element = "ruleoption";
const QString& XML::RuleOptionValue_Element = "ruleoptionvalue";
const QString& XML::Logging_Element = "logging";
const QString& XML::Target_Element = "target";
const QString& XML::ProtocolUsage_Element = "protocolusage";
const QString& XML::Port_Element = "port";
const QString& XML::Abstract_Element = "abstract";
const QString& XML::ICMP_Element = "icmp";
const QString& XML::NAT_Element = "nat";
const QString& XML::NetHost_Element = "nethost";
const QString& XML::NetZone_Element = "netzone";
const QString& XML::FromIP_Element = "fromIP";
const QString& XML::NetMask_Element = "netMask";
const QString& XML::ProtocolCategory_Element = "protocolCategory";
const QString& XML::Interface_Element = "interface";
const QString& XML::OS_Element = "os";
const QString& XML::BackEnd_Element = "backend";
const QString& XML::Distribution_Element = "distribution";
const QString& XML::InitPath_Element = "initPath";
const QString& XML::IPTPath_Element = "IPTPath";
const QString& XML::ModprobePath_Element = "modprobePath";
const QString& XML::RcDefaultPath_Element = "rcDefaultPath";
const QString& XML::TargetConfig_Element = "targetconfig";





// Attributes
const QString& XML::Protocol_Attribute = "protocol";
const QString& XML::Uuid_Attribute = "uuid";
const QString& XML::Name_Attribute = "name";
const QString& XML::Description_Attribute = "description";
const QString& XML::GUIName_Attribute = "guiName";
const QString& XML::Address_Attribute = "address";
const QString& XML::ReadOnly_Attribute = "readonly";
const QString& XML::Type_Attribute = "type";
const QString& XML::TargetOption_Attribute = "targetoption";
const QString& XML::BuiltIn_Attribute = "builtin";
const QString& XML::DefaultTarget_Attribute = "default_target";
const QString& XML::Logging_Attribute = "logging";
const QString& XML::Target_Attribute = "target";
const QString& XML::Prefix_Attribute = "prefix";
const QString& XML::Limit_Attribute = "limit";
const QString& XML::Burst_Attribute = "burst";
const QString& XML::IO_Attribute = "io";
const QString& XML::ProtocolUuid_Attribute = "protocolUuid";
const QString& XML::Enabled_Attribute = "enabled";
const QString& XML::CustomRule_Attribute = "custom_rule";
const QString& XML::Num_Attribute = "num";
const QString& XML::Version_Attribute = "version";
const QString& XML::MinVersion_Attribute = "minVersion";
const QString& XML::MaxVersion_Attribute = "maxVersion";
const QString& XML::RestrictOutgoingConnections_Attribute = "restrictOutgoingConnections";
const QString& XML::AllowIncomingConnections_Attribute = "allowIncomingConnections";
const QString& XML::LogIncoming_Attribute = "logIncoming";
const QString& XML::LogOutgoing_Attribute = "logOutgoing";
const QString& XML::LimitRate_Attribute = "limitRate";
const QString& XML::LimitScale_Attribute = "limitScale";
const QString& XML::SSHPort_Attribute = "sshPort";


// Network
const QString& XML::Interface_Attribute = "interface";

// GENERIC DOC
const QString& XML::LogDropped_Attribute = "logDropped";
const QString& XML::LimitLog_Attribute = "limitLog";
const QString& XML::LogPrefix_Attribute = "logPrefix";
const QString& XML::AllowPingReply_Attribute = "allowPingReply";
const QString& XML::LimitPingReply_Attribute = "limitPingReply";
const QString& XML::UseNat_Attribute = "useNat";
const QString& XML::UseMasquerade_Attribute = "useMasquerade";
const QString& XML::NatAddress_Attribute = "natAddress";
const QString& XML::OutgoingInterface_Attribute = "outgoingInterface";

// IPTDOC
const QString& XML::UseFilter_Attribute = "use_filter";
const QString& XML::Use_Nat_Attribute = "use_nat";
const QString& XML::UseMangle_Attribute = "use_mangle";
const QString& XML::UseModules_Attribute = "use_modules";
const QString& XML::UseRpFilter_Attribute = "use_rp_filter";
const QString& XML::UseIPFwd_Attribute = "use_ipfwd";
const QString& XML::UseSynCookies_Attribute = "use_syn_cookies";
const QString& XML::UseMartians_Attribute = "use_martians";


// Values
const QString& XML::Yes_Value = "yes";
const QString& XML::No_Value = "no";
const QString& XML::BoolOn_Value = "bool:on";
const QString& XML::BoolOff_Value = "bool:off";
const QString& XML::Undefined_Value = "UNDEFINED";
const QString& XML::Incoming_Value = "INCOMING";
const QString& XML::Outgoing_Value = "OUTGOING";
const QString& XML::UDP_Value = "UDP";
const QString& XML::TCP_Value = "TCP";
const QString& XML::IPTablesGUIInterface_Value = "iptables";
const QString& XML::GenericGUIInterface_Value = "generic";


// Constants 

const QString& Constants::Localhost_Name = "localhost";
const QString& Constants::Localhost_IP = "127.0.0.1";
const QString& Constants::MyNetwork_Name = "mynetwork";
const QString& Constants::FilterTable_Name = "filter";
const QString& Constants::NatTable_Name = "nat";
const QString& Constants::MangleTable_Name = "mangle";

const QString& Constants::InputChain_Name = "INPUT";
const QString& Constants::OutputChain_Name = "OUTPUT";
const QString& Constants::ForwardChain_Name = "FORWARD";
const QString& Constants::PreRoutingChain_Name = "PREROUTING";
const QString& Constants::PostRoutingChain_Name = "POSTROUTING";

const QString& Constants::StartFirewallJob_Name = "start_firewall_job";
const QString& Constants::StopFirewallJob_Name = "stop_firewall_job";
const QString& Constants::InstallFirewallJob_Name = "install_firewall_job";
const QString& Constants::UninstallFirewallJob_Name = "uninstall_firewall_job";
const QString& Constants::ShowConfigJob_Name = "show_config_job";
// const QString& Constants::KdeSu_Cmd = "kdesu -t -i kmyfirewall -d -c ";

}

