/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef KMFTARGETCONFIG_H
#define KMFTARGETCONFIG_H


// QT includes
#include <qptrlist.h>
#include <qstring.h>
#include <qdom.h>
#include <qobject.h>


#include <qstring.h>

// KDE includes
#include <kdemacros.h>
#include <kurl.h>

// Project includes
#include "netfilterobject.h"

namespace KMF {
class KMFTarget;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
 */

class KDE_EXPORT KMFTargetConfig : public NetfilterObject {
	public: 
		KMFTargetConfig( KMFTarget* target, const char* name );
	
	virtual ~KMFTargetConfig();
		
	virtual int type();
	virtual void clear();
	
	virtual const QDomDocument& getDOMTree();
	virtual void loadXML(const QDomDocument&, QStringList& errors );
	virtual void loadXML( QDomNode, QStringList& errors );
	
	/**
	Get the target object for this configuration
	*/
	KMFTarget* target() const {
		return m_target;
	}
	
	/**
	Set Which OS are we using.
	*/
	void setOS( const QString & v );

	/**
	Get Which OS are we using.
	*/
	const QString& oS() const {
		return m_OS;
	}

	/**
	Set Firewalling backend name.
	*/
	void setBackend( const QString & );

	/**
	Get Firewalling backend name.
	*/
	const QString& backend() const {
		return m_Backend;
	}


	/**
	Set What kind of ditribution are we using.
	*/
	void setDistribution( const QString & v );

	/**
	Get What kind of ditribution are we using.
	*/
	const QString& distribution() const {
		return m_Distribution;
	}

	/**
	Set Path to the init scripts
	*/
	void setInitPath( const QString & v );

	/**
	Get Path to the init scripts
	*/
	const QString& initPath() const {
		return m_InitPath;
	}

	/**
	Set Path to the default runlevel directory.
	*/
	void setRcDefaultPath( const QString & v );

	/**
	Get Path to the default runlevel directory.
	*/
	const QString& rcDefaultPath() const {
		return m_RcDefaultPath;
	}

	/**
	Set Path to iptables binary.
	*/
	void setIPTPath( const QString & v );

	/**
	Get Path to iptables binary.
	*/
	const QString& IPTPath() const {
		return m_IPTPath;
	}

	/**
	Set Path to the modprobe binary.
	*/
	void setModprobePath( const QString & v );

	/**
	Get Path to the modprobe binary.
	*/
	const QString& modprobePath() const {
		return m_ModprobePath;
	}
	


	/**
	Set Network interfaces
	*/
	void setInterfaces( const QStringList & v );

	/**
	Get Network interfaces
	*/
	QStringList& interfaces() {
		return m_Interfaces;
	}
	
	/** 
	Get Indicator if the config is valid
	*/
	bool isValid() const;
	
	QString toString();

private:
	KMFTarget* m_target;
	
	QString m_targetName;
	KURL m_configFile;
	
	// GENERAL
	QString m_OS;
	QString m_Backend;

	// PATHS
	QString m_Distribution;
	QString m_InitPath;
	QString m_RcDefaultPath;
	QString m_IPTPath;
	QString m_ModprobePath;
	QString m_CurrentGenericConfiguration;
	QString m_CurrentIPTConfiguration;

	// INTERFACES
	QStringList m_Interfaces;
};
}
#endif
