/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/


#include "kmfgenericinterface_part.h"


// QT includes
#include <qlabel.h>

// KDE includes
#include <kinstance.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <kparts/genericfactory.h>

// Project includes
#include "kmfgenericinterface.h"

#include "../kmfwidgets/kmfmainwindow.h"

KMFGenericInterfacePart::KMFGenericInterfacePart( QWidget *parentWidget, const char *  widgetName ,
        QObject *parent, const char *name,
        const QStringList & /*args*/ )
		: KParts::ReadWritePart( parent, name ) {
	setInstance( KMFGenericInterfacePartFactory::instance() );

	m_genericinterface = new KMFGenericInterface( parentWidget, widgetName );

	KMFMainWindow *app = 0;
	app = dynamic_cast<KMFMainWindow*>( parent );
	if ( ! app ) {
		KMessageBox::error(0,"Oops wrong parent class found for kmfinstallerplugin!!!");
	}

	m_genericinterface->loadDoc( (KMFGenericDoc*) app->doc() );
	connect( app, SIGNAL( sigHasDoc( bool ) ),
		m_genericinterface, SLOT( setEnabled( bool ) ) );

	connect( app, SIGNAL( sigUpdateView() ),
		m_genericinterface, SLOT( slotUpdateView() ) );

	connect( app, SIGNAL( sigEnableActions( bool ) ),
		this, SLOT( slotEnableActions( bool ) ) );


	setWidget( m_genericinterface );
	setXMLFile( "kmfgenericinterfaceparetui.rc" );

	// we are read-write by default
	setReadWrite( true );

	// we are not modified since we haven't done anything yet
	setModified( false );

}

KMFGenericInterfacePart::~KMFGenericInterfacePart() {
	closeURL();
}

void KMFGenericInterfacePart::setReadWrite( bool rw ) {
	// notify your internal widget of the read-write state

	ReadWritePart::setReadWrite( rw );
}

void KMFGenericInterfacePart::setModified( bool modified ) {
	// get a handle on our Save action and make sure it is valid
// 	KAction * save = actionCollection() ->action( KStdAction::stdName( KStdAction::Save ) );
// 	if ( !save )
// 		return ;
// 
// 	// if so, we either enable or disable it based on the current
// 	// state
// 	if ( modified )
// 		save->setEnabled( true );
// 	else
// 		save->setEnabled( false );

	// in any event, we want our parent to do it's thing
	ReadWritePart::setModified( modified );
}

bool KMFGenericInterfacePart::openFile() {
	// m_file is always local so we can use QFile on it
	//     QFile file(m_file);
	//     if (file.open(IO_ReadOnly) == false)
	//         return false;
	//
	//     // our example widget is text-based, so we use QTextStream instead
	//     // of a raw QDataStream
	//     QTextStream stream(&file);
	//     QString str;
	//     while (!stream.eof())
	//         str += stream.readLine() + "\n";
	//
	//     file.close();
	//
	//     // now that we have the entire file, display it
	// //     m_widget->setText(str);
	//
	//     // just for fun, set the status bar
	//     emit setStatusBarText( m_url.prettyURL() );

	return true;
}

bool KMFGenericInterfacePart::saveFile() {
	// if we aren't read-write, return immediately
	/*    if (isReadWrite() == false)
	        return false;

	    // m_file is always local, so we use QFile
	    QFile file(m_file);
	    if (file.open(IO_WriteOnly) == false)
	        return false;

	    // use QTextStream to dump the text to the file
	    QTextStream stream(&file);
	    stream << m_widget->text();

	    file.close();
	*/ 
	return true;
}

void KMFGenericInterfacePart::slotEnableActions( bool ) {
	kdDebug() << "void KMFGenericInterfacePart::slotEnableActions( bool )" << endl;
}

// bool KMFGenericInterfacePart::closeURL()
// {
//     return true;
// }

// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

KInstance* KMFGenericInterfacePartFactory::s_instance = 0L;
KAboutData* KMFGenericInterfacePartFactory::s_about = 0L;

KMFGenericInterfacePartFactory::KMFGenericInterfacePartFactory()
		: KParts::Factory() {}

KMFGenericInterfacePartFactory::~KMFGenericInterfacePartFactory() {
	delete s_instance;
	delete s_about;

	s_instance = 0L;
}

KParts::Part* KMFGenericInterfacePartFactory::createPartObject( QWidget *parentWidget, const char *widgetName,
        QObject *parent, const char *name,
        const char *classname, const QStringList& args) {
	// Create an instance of our Part
	KMFGenericInterfacePart * obj = new KMFGenericInterfacePart( parentWidget, widgetName, parent, name ,args );

	// See if we are to be read-write or not
	if ( QCString( classname ) == "KParts::ReadOnlyPart" )
		obj->setReadWrite( false );

	return obj;
}

KInstance* KMFGenericInterfacePartFactory::instance() {
	if ( !s_instance ) {
		s_about = new KAboutData( "kmfgenericinterfacepart", I18N_NOOP( "kmfgenericinterfacepartPart" ), "0.1" );
		s_about->addAuthor( "Christian Hubinger", 0, "chubinger@gmail.com" );
		s_instance = new KInstance( s_about );
	}
	return s_instance;
}

extern "C" {
	void* init_libkmfgenericinterfacepart() {
		return new KMFGenericInterfacePartFactory;
	}
}



#include "kmfgenericinterface_part.moc"
