//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACE_H
#define KMFGENERICINTERFACE_H

#include <kjanuswidget.h>

/**
@author Christian Hubinger
*/

// QT includes
#include <qpixmap.h>

class QFrame;
class QVBox;
class QTabWidget;

// KDE includes



// Project includes

class KMFGenericInterfaceProtocol;
class KMFGenericInterfaceNat;
class KMFGenericInterfaceHost;
class KMFGenericInterfaceLogging;
class KMFGenericInterfaceEditProtocol;
class KMFGenericInterfaceIcmp;
class KMFGenericDoc;


class KMFGenericInterface : public KJanusWidget {
	Q_OBJECT
public:

	KMFGenericInterface( QWidget *parent = 0, const char *name = 0 );
	~KMFGenericInterface();

	void loadDoc( KMFGenericDoc* );


private slots:
	void slotPageChanged( QWidget* );
	void slotUpdateView();

private:
	void loadIcons();
private:
	KMFGenericInterfaceProtocol *m_protocolPageZones;
	KMFGenericInterfaceEditProtocol *m_protocolPageEditProtocol;
	KMFGenericInterfaceNat *m_natPage;
	KMFGenericInterfaceHost *m_hostPage;
	KMFGenericInterfaceLogging *m_loggingPage;
	KMFGenericInterfaceIcmp *m_icmpPage;

	KMFGenericDoc *m_doc;

	QFrame *zoneFrame, *protocolFrame, *editProtocolFrame,*icmpFrame,  *hostFrame,*natFrame, *logFrame;

	QPixmap icon_zone_page, icon_protocol_page,
					icon_edit_protocol_page, icon_icmp_page,
					icon_logging_page, icon_host_page, icon_nat_page;
};

#endif
